/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.SingleConnectionDatabase;
import com.imcode.db.commands.SqlUpdateCommand;
import com.imcode.db.commands.TransactionDatabaseCommand;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.MenuSaver;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.util.io.FileInputStreamSource;
import imcode.util.io.FileUtility;
import imcode.util.io.InputStreamSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

public class DocumentStoringVisitor
extends DocumentVisitor {
    protected Database database;
    protected ImcmsServices services;
    private static final int FILE_BUFFER_LENGTH = 2048;
    private static final int DB_FIELD_MAX_LENGTH__FILENAME = 255;

    public DocumentStoringVisitor(Database database, ImcmsServices services) {
        this.database = database;
        this.services = services;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFileDocumentFile(int fileDocumentId, FileDocumentDomainObject.FileDocumentFile fileDocumentFile, String fileId) {
        try {
            boolean sameFileOnDisk;
            InputStream in;
            InputStreamSource inputStreamSource = fileDocumentFile.getInputStreamSource();
            try {
                in = inputStreamSource.getInputStream();
            }
            catch (FileNotFoundException e) {
                throw new UnhandledException("The file for filedocument " + fileDocumentId + " has disappeared.", (Throwable)e);
            }
            if (null == in) {
                return;
            }
            File file = DocumentStoringVisitor.getFileForFileDocumentFile(fileDocumentId, fileId);
            FileInputStreamSource fileInputStreamSource = new FileInputStreamSource(file);
            boolean bl = sameFileOnDisk = file.exists() && inputStreamSource.equals(fileInputStreamSource);
            if (sameFileOnDisk) {
                return;
            }
            byte[] buffer = new byte[2048];
            FileOutputStream out = new FileOutputStream(file);
            try {
                int bytesRead;
                while (-1 != (bytesRead = in.read(buffer))) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)out).close();
                in.close();
            }
            fileDocumentFile.setInputStreamSource(fileInputStreamSource);
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static File getFileForFileDocumentFile(int fileDocumentId, String fileId) {
        File filePath = Imcms.getServices().getConfig().getFilePath();
        String filename = "" + fileDocumentId;
        if (StringUtils.isNotBlank((String)fileId)) {
            filename = filename + "." + FileUtility.escapeFilename(fileId);
        }
        File file = new File(filePath, filename);
        return file;
    }

    static String makeSqlInsertString(String tableName, String[] columnNames) {
        return "INSERT INTO " + tableName + " (" + StringUtils.join((Object[])columnNames, (String)",") + ")" + "VALUES(?" + StringUtils.repeat((String)",?", (int)(columnNames.length - 1)) + ")";
    }

    void updateTextDocumentTexts(TextDocumentDomainObject textDocument) {
        Map texts = textDocument.getTexts();
        String sqlDeleteTexts = "DELETE FROM texts WHERE meta_id = ?";
        Object[] parameters = new String[]{"" + textDocument.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlDeleteTexts, parameters))).intValue();
        Iterator iterator = texts.keySet().iterator();
        while (iterator.hasNext()) {
            Integer textIndex = (Integer)iterator.next();
            TextDomainObject text = (TextDomainObject)texts.get(textIndex);
            this.sqlInsertText(textDocument, textIndex, text);
        }
    }

    void updateTextDocumentImages(TextDocumentDomainObject textDocument) {
        Map images = textDocument.getImages();
        String sqlDeleteImages = "DELETE FROM images WHERE meta_id = ?";
        Object[] parameters = new String[]{"" + textDocument.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlDeleteImages, parameters))).intValue();
        Iterator iterator = images.keySet().iterator();
        while (iterator.hasNext()) {
            Integer imageIndex = (Integer)iterator.next();
            ImageDomainObject image = (ImageDomainObject)images.get(imageIndex);
            DocumentStoringVisitor.saveDocumentImage(textDocument.getId(), imageIndex, image);
        }
    }

    void updateTextDocumentIncludes(TextDocumentDomainObject textDocument) {
        Map includes = textDocument.getIncludes();
        String sqlDeleteDocumentIncludes = "DELETE FROM includes WHERE meta_id = ?";
        Object[] parameters = new String[]{"" + textDocument.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlDeleteDocumentIncludes, parameters))).intValue();
        Iterator iterator = includes.keySet().iterator();
        while (iterator.hasNext()) {
            Integer includeIndex = (Integer)iterator.next();
            Integer includedDocumentId = (Integer)includes.get(includeIndex);
            this.sqlInsertTextDocumentInclude(textDocument, includeIndex, includedDocumentId);
        }
    }

    private void sqlInsertText(TextDocumentDomainObject textDocument, Integer textIndex, TextDomainObject text) {
        Object[] parameters = new String[]{"" + textDocument.getId(), "" + textIndex, text.getText(), "" + text.getType()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO texts (meta_id, name, text, type) VALUES(?,?,?,?)", parameters))).intValue();
    }

    private void sqlInsertTextDocumentInclude(TextDocumentDomainObject textDocument, Integer includeIndex, Integer includedDocumentId) {
        Object[] parameters = new String[]{"" + textDocument.getId(), "" + includeIndex, "" + includedDocumentId};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand("INSERT INTO includes (meta_id, include_id, included_meta_id) VALUES(?,?,?)", parameters))).intValue();
    }

    public static void saveDocumentImage(int meta_id, int img_no, ImageDomainObject image) {
        String sqlStr = "update images\nset imgurl  = ?, \nwidth       = ?, \nheight      = ?, \nborder      = ?, \nv_space     = ?, \nh_space     = ?, \nimage_name  = ?, \ntarget      = ?, \nalign       = ?, \nalt_text    = ?, \nlow_scr     = ?, \nlinkurl     = ?, \ntype        = ?  \nwhere meta_id = ? \nand name = ? \n";
        int rowUpdateCount = DocumentStoringVisitor.sqlImageUpdateQuery(sqlStr, image, meta_id, img_no);
        if (0 == rowUpdateCount) {
            sqlStr = "insert into images (imgurl, width, height, border, v_space, h_space, image_name, target, align, alt_text, low_scr, linkurl, type, meta_id, name) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?)";
            DocumentStoringVisitor.sqlImageUpdateQuery(sqlStr, image, meta_id, img_no);
        }
    }

    private static int sqlImageUpdateQuery(String sqlStr, ImageDomainObject image, int meta_id, int img_no) {
        ImageSource imageSource = image.getSource();
        Object[] parameters = new String[]{imageSource.toStorageString(), "" + image.getWidth(), "" + image.getHeight(), "" + image.getBorder(), "" + image.getVerticalSpace(), "" + image.getHorizontalSpace(), image.getName(), image.getTarget(), image.getAlign(), image.getAlternateText(), image.getLowResolutionUrl(), image.getLinkUrl(), "" + imageSource.getTypeId(), "" + meta_id, "" + img_no};
        return (Integer)Imcms.getServices().getDatabase().execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters));
    }

    public void visitFileDocument(FileDocumentDomainObject fileDocument) {
        Map fileDocumentFiles = fileDocument.getFiles();
        String sqlDelete = "DELETE FROM fileupload_docs WHERE meta_id = ?";
        Object[] parameters1 = new String[]{"" + fileDocument.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlDelete, parameters1))).intValue();
        Iterator iterator = fileDocumentFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String fileId = (String)entry.getKey();
            FileDocumentDomainObject.FileDocumentFile fileDocumentFile = (FileDocumentDomainObject.FileDocumentFile)entry.getValue();
            String filename = fileDocumentFile.getFilename();
            if (filename.length() > 255) {
                filename = this.truncateFilename(filename, 255);
            }
            String sqlInsert = "INSERT INTO fileupload_docs (meta_id, variant_name, filename, mime, created_as_image, default_variant) VALUES(?,?,?,?,?,?)";
            boolean isDefaultFile = fileId.equals(fileDocument.getDefaultFileId());
            Object[] parameters = new String[]{"" + fileDocument.getId(), fileId, filename, fileDocumentFile.getMimeType(), fileDocumentFile.isCreatedAsImage() ? "1" : "0", isDefaultFile ? "1" : "0"};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlInsert, parameters))).intValue();
            this.saveFileDocumentFile(fileDocument.getId(), fileDocumentFile, fileId);
        }
        DocumentMapper.deleteOtherFileDocumentFiles(fileDocument);
    }

    private String truncateFilename(String filename, int length) {
        String truncatedFilename = StringUtils.left((String)filename, (int)length);
        String extensions = this.getExtensionsFromFilename(filename);
        if (extensions.length() > length) {
            return truncatedFilename;
        }
        String basename = StringUtils.chomp((String)filename, (String)extensions);
        String truncatedBasename = StringUtils.substring((String)basename, (int)0, (int)(length - extensions.length()));
        truncatedFilename = truncatedBasename + extensions;
        return truncatedFilename;
    }

    private String getExtensionsFromFilename(String filename) {
        String extensions = "";
        Matcher matcher = Pattern.compile("(?:\\.\\w+)+$").matcher(filename);
        if (matcher.find()) {
            extensions = matcher.group();
        }
        return extensions;
    }

    public void visitBrowserDocument(BrowserDocumentDomainObject browserDocument) {
        this.deleteBrowserDocument(browserDocument);
        this.saveNewBrowserDocument(browserDocument);
    }

    private void deleteBrowserDocument(BrowserDocumentDomainObject browserDocument) {
        String sqlStr = "DELETE FROM browser_docs WHERE meta_id = ?";
        Object[] parameters = new String[]{"" + browserDocument.getId()};
        ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlStr, parameters))).intValue();
    }

    public void saveNewBrowserDocument(BrowserDocumentDomainObject document) {
        String[] browserDocumentColumns = new String[]{"meta_id", "to_meta_id", "browser_id"};
        String sqlBrowserDocsInsertStr = DocumentStoringVisitor.makeSqlInsertString("browser_docs", browserDocumentColumns);
        Map browserDocumentMap = document.getBrowserDocumentIdMap();
        Iterator iterator = browserDocumentMap.keySet().iterator();
        while (iterator.hasNext()) {
            BrowserDocumentDomainObject.Browser browser = (BrowserDocumentDomainObject.Browser)iterator.next();
            Integer metaIdForBrowser = (Integer)browserDocumentMap.get(browser);
            Object[] parameters = new String[]{"" + document.getId(), "" + metaIdForBrowser, "" + browser.getId()};
            ((Integer)this.database.execute((DatabaseCommand)new SqlUpdateCommand(sqlBrowserDocsInsertStr, parameters))).intValue();
        }
    }

    protected void updateTextDocumentMenus(final TextDocumentDomainObject textDocument) {
        this.database.execute((DatabaseCommand)new TransactionDatabaseCommand(){

            public Object executeInTransaction(DatabaseConnection connection) {
                MenuSaver menuSaver = new MenuSaver((Database)new SingleConnectionDatabase(connection));
                menuSaver.updateTextDocumentMenus(textDocument, DocumentStoringVisitor.this.services);
                return null;
            }
        });
    }
}

