/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import imcode.server.document.DocumentDomainObject;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

class DocumentList
extends AbstractList
implements Serializable {
    private ArrayList list;
    private Map map;

    DocumentList(Map documentMap) {
        this.map = Collections.synchronizedMap(documentMap);
        this.list = new ArrayList(documentMap.size());
        Iterator iterator = this.map.values().iterator();
        while (iterator.hasNext()) {
            DocumentDomainObject document = (DocumentDomainObject)iterator.next();
            this.list.add(document);
        }
    }

    public synchronized Object remove(int index) {
        Object o = this.list.remove(index);
        DocumentDomainObject document = (DocumentDomainObject)o;
        this.map.remove(new Integer(document.getId()));
        return o;
    }

    public synchronized Object set(int index, Object o) {
        DocumentDomainObject document = (DocumentDomainObject)o;
        DocumentDomainObject previousDocument = (DocumentDomainObject)this.list.set(index, o);
        if (null != previousDocument) {
            this.map.remove(new Integer(previousDocument.getId()));
        }
        this.map.put(new Integer(document.getId()), document);
        return previousDocument;
    }

    public synchronized Object get(int index) {
        return this.list.get(index);
    }

    public synchronized Iterator iterator() {
        return this.list.iterator();
    }

    public synchronized boolean add(Object o) {
        DocumentDomainObject document = (DocumentDomainObject)o;
        this.map.put(new Integer(document.getId()), document);
        return this.list.add(o);
    }

    public synchronized int size() {
        return this.list.size();
    }

    public synchronized Map getMap() {
        return this.map;
    }

    public boolean contains(Object o) {
        if (o instanceof Integer) {
            return this.map.containsKey(o);
        }
        DocumentDomainObject document = (DocumentDomainObject)o;
        return this.map.containsKey(new Integer(document.getId()));
    }
}

