/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.shop;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class ShoppingItem
implements Comparable {
    private double price = 0.0;
    private Map descriptions = new TreeMap();

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public Map getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(Map descriptions) {
        this.descriptions = descriptions;
    }

    public void setDescription(int i, String description) {
        if (null == description) {
            this.descriptions.remove(new Integer(i));
        } else {
            this.descriptions.put(new Integer(i), description);
        }
    }

    public String getDescription(int i) {
        String description = (String)this.descriptions.get(new Integer(i));
        return null == description ? "" : description;
    }

    public boolean equals(Object o) {
        if (o instanceof ShoppingItem) {
            ShoppingItem item = (ShoppingItem)o;
            return item.price == this.price && ((Object)item.descriptions).equals(this.descriptions);
        }
        return false;
    }

    public int hashCode() {
        return new Double(this.price).hashCode() ^ ((Object)this.descriptions).hashCode();
    }

    public int compareTo(Object o) {
        ShoppingItem item = (ShoppingItem)o;
        int descriptionComparison = this.compareDescriptionTo(item);
        return 0 != descriptionComparison ? descriptionComparison : this.comparePriceTo(item);
    }

    int compareDescriptionTo(ShoppingItem item) {
        Iterator it1 = this.descriptions.entrySet().iterator();
        Iterator it2 = item.descriptions.entrySet().iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (it1.hasNext() && it2.hasNext()) {
                Map.Entry desc1 = it1.next();
                Map.Entry desc2 = it2.next();
                int descCompare = ((Integer)desc1.getKey()).compareTo((Integer)desc2.getKey());
                if (0 != descCompare) {
                    return -descCompare;
                }
                descCompare = ((String)desc1.getValue()).compareTo((String)desc2.getValue());
                if (0 == descCompare) continue;
                return descCompare;
            }
            return it1.hasNext() ? 1 : -1;
        }
        return 0;
    }

    private int comparePriceTo(ShoppingItem item) {
        if (this.price < item.price) {
            return -1;
        }
        if (this.price > item.price) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.descriptions.toString() + " " + this.price;
    }
}

