/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RolePermissionDomainObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;

public class UserDomainObject
extends Hashtable {
    public static final int DEFAULT_USER_ID = 2;
    protected int id;
    private String loginName;
    private String password;
    private String firstName = "";
    private String lastName = "";
    private String title = "";
    private String company = "";
    private String address = "";
    private String city = "";
    private String zip = "";
    private String country = "";
    private String countyCouncil = "";
    private String emailAddress = "";
    private boolean active;
    private String create_date;
    private String languageIso639_2;
    private TemplateGroupDomainObject templateGroup;
    private String loginType;
    private boolean imcmsExternal = false;
    private String workPhone = "";
    private String mobilePhone = "";
    private String homePhone = "";
    private String faxPhone = "";
    private String otherPhone = "";
    Set roles = new HashSet();
    private String currentContextPath;

    public UserDomainObject() {
        this.roles.add(RoleDomainObject.USERS);
    }

    public Object clone() {
        UserDomainObject clone = (UserDomainObject)super.clone();
        clone.roles = new HashSet(this.roles);
        return clone;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFullName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCompany() {
        return this.company;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return this.city;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getZip() {
        return this.zip;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountyCouncil(String countyCouncil) {
        this.countyCouncil = countyCouncil;
    }

    public String getCountyCouncil() {
        return this.countyCouncil;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getWorkPhone() {
        return this.workPhone;
    }

    public void setWorkPhone(String workphone) {
        this.workPhone = workphone;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilephone) {
        this.mobilePhone = mobilephone;
    }

    public String getHomePhone() {
        return this.homePhone;
    }

    public void setHomePhone(String homephone) {
        this.homePhone = homephone;
    }

    public String getFaxPhone() {
        return this.faxPhone;
    }

    public void setFaxPhone(String faxphone) {
        this.faxPhone = faxphone;
    }

    public String getOtherPhone() {
        return this.otherPhone;
    }

    public void setOtherPhone(String otherphone) {
        this.otherPhone = otherphone;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setCreateDate(String create_date) {
        this.create_date = create_date;
    }

    public String getCreateDate() {
        return this.create_date;
    }

    public void setTemplateGroup(TemplateGroupDomainObject template_group) {
        this.templateGroup = template_group;
    }

    public TemplateGroupDomainObject getTemplateGroup() {
        return this.templateGroup;
    }

    public String getLanguageIso639_2() {
        return this.languageIso639_2;
    }

    public void setLanguageIso639_2(String languageIso639_2) {
        this.languageIso639_2 = languageIso639_2;
    }

    public String getLoginType() {
        return this.loginType;
    }

    public void setLoginType(String loginType) {
        this.loginType = loginType;
    }

    public boolean isImcmsExternal() {
        return this.imcmsExternal;
    }

    public void setImcmsExternal(boolean external) {
        this.imcmsExternal = external;
    }

    public void addRole(RoleDomainObject role) {
        this.roles.add(role);
    }

    public void removeRole(RoleDomainObject role) {
        if (!RoleDomainObject.USERS.equals(role)) {
            this.roles.remove(role);
        }
    }

    public void setRoles(RoleDomainObject[] rolesForUser) {
        this.roles = new HashSet<RoleDomainObject>(Arrays.asList(rolesForUser));
        this.roles.add(RoleDomainObject.USERS);
    }

    public boolean hasRole(RoleDomainObject role) {
        return this.roles.contains(role);
    }

    public RoleDomainObject[] getRoles() {
        return this.roles.toArray(new RoleDomainObject[this.roles.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserDomainObject)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserDomainObject userDomainObject = (UserDomainObject)o;
        return this.id == userDomainObject.id;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.id;
        return result;
    }

    public boolean isDefaultUser() {
        return 2 == this.id;
    }

    public boolean isSuperAdmin() {
        return this.hasRole(RoleDomainObject.SUPERADMIN);
    }

    public boolean isUserAdmin() {
        return this.hasRole(RoleDomainObject.USERADMIN);
    }

    public boolean canEdit(DocumentDomainObject document) {
        return this.hasAtLeastPermissionSetIdOn(2, document);
    }

    public boolean canAccess(DocumentDomainObject document) {
        return this.hasAtLeastPermissionSetIdOn(3, document);
    }

    public boolean isSuperAdminOrHasFullPermissionOn(DocumentDomainObject document) {
        return this.isSuperAdminOrHasAtLeastPermissionSetIdOn(0, document);
    }

    public boolean canDefineRestrictedOneFor(DocumentDomainObject document) {
        return this.isSuperAdminOrHasFullPermissionOn(document);
    }

    public boolean canDefineRestrictedTwoFor(DocumentDomainObject document) {
        boolean hasFullPermission = this.isSuperAdminOrHasFullPermissionOn(document);
        boolean canEditPermissionsForDocument = this.canEditPermissionsFor(document);
        boolean hasAtLeastRestrictedOne = this.hasAtLeastRestrictedOnePermissionOn(document);
        boolean hasAtLeastRestrictedOnePermissionAndIsMorePrivilegedThanRestrictedTwo = hasAtLeastRestrictedOne && document.isRestrictedOneMorePrivilegedThanRestrictedTwo();
        return hasFullPermission || canEditPermissionsForDocument && hasAtLeastRestrictedOnePermissionAndIsMorePrivilegedThanRestrictedTwo;
    }

    private boolean hasAtLeastRestrictedOnePermissionOn(DocumentDomainObject document) {
        return this.hasAtLeastPermissionSetIdOn(1, document);
    }

    public String toString() {
        return "(user " + this.id + " \"" + this.loginName + "\")";
    }

    public void setCurrentContextPath(String currentContextPath) {
        this.currentContextPath = currentContextPath;
    }

    public String getCurrentContextPath() {
        return this.currentContextPath;
    }

    public boolean isSuperAdminOrHasAtLeastPermissionSetIdOn(int permissionSetId, DocumentDomainObject document) {
        return this.isSuperAdmin() || this.hasAtLeastPermissionSetIdOn(permissionSetId, document);
    }

    public boolean canEditPermissionsFor(DocumentDomainObject document) {
        return this.getPermissionSetFor(document).getEditPermissions();
    }

    public boolean canSetPermissionSetIdForRoleOnDocument(int permissionSetId, RoleDomainObject role, DocumentDomainObject document) {
        if (!this.canEditPermissionsFor(document)) {
            return false;
        }
        int currentPermissionSetId = document.getPermissionSetIdForRole(role);
        boolean userIsSuperAdminOrHasAtLeastTheCurrentPermissionSet = this.isSuperAdminOrHasAtLeastPermissionSetIdOn(currentPermissionSetId, document);
        boolean userIsSuperAdminOrHasAtLeastTheWantedPermissionSet = this.isSuperAdminOrHasAtLeastPermissionSetIdOn(permissionSetId, document);
        boolean userHasAtLeastRestrictedOne = this.hasAtLeastRestrictedOnePermissionOn(document);
        boolean changingRestrictedTwo = 2 == permissionSetId || 2 == currentPermissionSetId;
        boolean canDefineRestrictedTwoForDocument = this.canDefineRestrictedTwoFor(document);
        boolean canDo = userIsSuperAdminOrHasAtLeastTheWantedPermissionSet && userIsSuperAdminOrHasAtLeastTheCurrentPermissionSet && (!changingRestrictedTwo || !userHasAtLeastRestrictedOne || canDefineRestrictedTwoForDocument);
        return canDo;
    }

    public boolean canCreateDocumentOfTypeIdFromParent(int documentTypeId, DocumentDomainObject parent) {
        TextDocumentPermissionSetDomainObject documentPermissionSet = (TextDocumentPermissionSetDomainObject)this.getPermissionSetFor(parent);
        int[] allowedDocumentTypeIds = documentPermissionSet.getAllowedDocumentTypeIds();
        return ArrayUtils.contains((int[])allowedDocumentTypeIds, (int)documentTypeId);
    }

    public DocumentPermissionSetDomainObject getPermissionSetFor(DocumentDomainObject document) {
        int permissionSetId = this.getPermissionSetIdFor(document);
        switch (permissionSetId) {
            case 0: {
                return DocumentPermissionSetDomainObject.FULL;
            }
            case 3: {
                return DocumentPermissionSetDomainObject.READ;
            }
            case 1: {
                return document.getPermissionSetForRestrictedOne();
            }
            case 2: {
                return document.getPermissionSetForRestrictedTwo();
            }
            case 4: {
                return DocumentPermissionSetDomainObject.NONE;
            }
        }
        return null;
    }

    public int getPermissionSetIdFor(DocumentDomainObject document) {
        RoleDomainObject usersRole;
        Integer permissionSetId;
        if (null == document) {
            return 4;
        }
        if (this.isSuperAdmin()) {
            return 0;
        }
        Map rolesMappedToPermissionSetIds = document.getRolesMappedToPermissionSetIds();
        RoleDomainObject[] usersRoles = this.getRoles();
        int mostPrivilegedPermissionSetIdFoundYet = 4;
        for (int i = 0; i < usersRoles.length && (null == (permissionSetId = (Integer)rolesMappedToPermissionSetIds.get(usersRole = usersRoles[i])) || permissionSetId >= mostPrivilegedPermissionSetIdFoundYet || 0 != (mostPrivilegedPermissionSetIdFoundYet = permissionSetId.intValue())); ++i) {
        }
        return mostPrivilegedPermissionSetIdFoundYet;
    }

    public boolean hasAtLeastPermissionSetIdOn(int leastPrivilegedPermissionSetIdWanted, DocumentDomainObject document) {
        return this.getPermissionSetIdFor(document) <= leastPrivilegedPermissionSetIdWanted;
    }

    public boolean canAddDocumentToAnyMenu(DocumentDomainObject document) {
        return this.canEdit(document) || document.isLinkableByOtherUsers();
    }

    public boolean canSearchFor(DocumentDomainObject document) {
        boolean searchingUserHasPermissionToFindDocument = false;
        if (document.isSearchDisabled()) {
            if (this.isSuperAdmin()) {
                searchingUserHasPermissionToFindDocument = true;
            }
        } else {
            searchingUserHasPermissionToFindDocument = document.isPublished() ? this.canAccess(document) : this.canEdit(document);
        }
        return searchingUserHasPermissionToFindDocument;
    }

    public boolean canEditDocumentInformationFor(DocumentDomainObject document) {
        return this.getPermissionSetFor(document).getEditDocumentInformation();
    }

    public boolean canAccessAdminPages() {
        RolePermissionDomainObject rolePermissionToAccessAdminPages = RoleDomainObject.ADMIN_PAGES_PERMISSION;
        return this.isSuperAdmin() || this.isUserAdmin() || this.hasRoleWithPermission(rolePermissionToAccessAdminPages);
    }

    public boolean hasRoleWithPermission(RolePermissionDomainObject rolePermission) {
        Iterator iterator = this.roles.iterator();
        while (iterator.hasNext()) {
            RoleDomainObject role = (RoleDomainObject)iterator.next();
            if (!role.hasPermission(rolePermission)) continue;
            return true;
        }
        return false;
    }

    public boolean canSeeDocumentInMenus(DocumentDomainObject document) {
        return document.isActive() && this.canSeeDocumentWhenEditingMenus(document);
    }

    public boolean canSeeDocumentWhenEditingMenus(DocumentDomainObject document) {
        return document.isVisibleInMenusForUnauthorizedUsers() || this.canAccess(document);
    }
}

