/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import junit.framework.TestCase;
import org.apache.commons.lang.ArrayUtils;

public class TestUserDomainObject
extends TestCase {
    private UserDomainObject user;

    protected void setUp() throws Exception {
        super.setUp();
        this.user = new UserDomainObject();
    }

    public void testClone() {
        UserDomainObject clone = (UserDomainObject)this.user.clone();
        TestUserDomainObject.assertNotSame((String)"Roles cloned", (Object)clone.roles, (Object)this.user.roles);
    }

    public void testUserAlwaysHasUsersRole() {
        TestUserDomainObject.assertTrue((boolean)this.user.hasRole(RoleDomainObject.USERS));
        TestUserDomainObject.assertTrue((boolean)ArrayUtils.contains((Object[])this.user.getRoles(), (Object)RoleDomainObject.USERS));
        this.user.removeRole(RoleDomainObject.USERS);
        TestUserDomainObject.assertTrue((boolean)this.user.hasRole(RoleDomainObject.USERS));
        TestUserDomainObject.assertTrue((boolean)ArrayUtils.contains((Object[])this.user.getRoles(), (Object)RoleDomainObject.USERS));
        this.user.setRoles(new RoleDomainObject[0]);
        TestUserDomainObject.assertTrue((boolean)this.user.hasRole(RoleDomainObject.USERS));
        TestUserDomainObject.assertTrue((boolean)ArrayUtils.contains((Object[])this.user.getRoles(), (Object)RoleDomainObject.USERS));
    }

    public void testCanAddDocumentToAnyMenu() {
        TextDocumentDomainObject textDocument = new TextDocumentDomainObject();
        TestUserDomainObject.assertFalse((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        RoleDomainObject readRole = new RoleDomainObject("read");
        textDocument.setPermissionSetIdForRole(readRole, 3);
        this.user.addRole(readRole);
        TestUserDomainObject.assertFalse((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        textDocument.setLinkableByOtherUsers(true);
        TestUserDomainObject.assertTrue((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        textDocument.setLinkableByOtherUsers(false);
        TestUserDomainObject.assertFalse((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
        RoleDomainObject editRole = new RoleDomainObject("edit");
        textDocument.setPermissionSetIdForRole(editRole, 0);
        this.user.addRole(editRole);
        TestUserDomainObject.assertTrue((boolean)this.user.canAddDocumentToAnyMenu(textDocument));
    }
}

