/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.db.IntegrityConstraintViolationSQLException;
import imcode.server.db.MockDatabase;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import junit.framework.TestCase;
import org.apache.commons.lang.ArrayUtils;

public class TestImcmsAuthenticatorAndUserAndRoleMapper
extends TestCase {
    public void testAddRoleNameTwice() throws Exception {
        AddRoleMockDatabase database = new AddRoleMockDatabase();
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = new ImcmsAuthenticatorAndUserAndRoleMapper(database, null);
        imcmsAuthenticatorAndUserAndRoleMapper.addRole("Test");
        imcmsAuthenticatorAndUserAndRoleMapper.addRole("Test");
    }

    public void testAddRoleTwice() {
        AddRoleMockDatabase database = new AddRoleMockDatabase();
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = new ImcmsAuthenticatorAndUserAndRoleMapper(database, null);
        RoleDomainObject role = new RoleDomainObject(3, "Test", 0);
        imcmsAuthenticatorAndUserAndRoleMapper.addRole(role);
        try {
            imcmsAuthenticatorAndUserAndRoleMapper.addRole(role);
            TestImcmsAuthenticatorAndUserAndRoleMapper.fail((String)"Should have thrown exception on second attempt to add same role.");
        }
        catch (IntegrityConstraintViolationSQLException icvse) {
            // empty catch block
        }
    }

    public void testAddExternalUser() {
        AddUserMockDatabase database = new AddUserMockDatabase();
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = new ImcmsAuthenticatorAndUserAndRoleMapper(database, null);
        UserDomainObject user = new UserDomainObject();
        user.setLoginName("Test");
        user.setImcmsExternal(true);
        user.setLanguageIso639_2("eng");
        imcmsAuthenticatorAndUserAndRoleMapper.addUser(user, null);
        TestImcmsAuthenticatorAndUserAndRoleMapper.assertNotNull((Object)database.updateQueryParameters);
        TestImcmsAuthenticatorAndUserAndRoleMapper.assertFalse((boolean)ArrayUtils.contains((Object[])database.updateQueryParameters, null));
    }

    private static class AddRoleMockDatabase
    extends MockDatabase {
        boolean roleInserted;

        private AddRoleMockDatabase() {
        }

        public String sqlQueryStr(String sqlStr, String[] params) {
            if (this.roleInserted) {
                throw new IntegrityConstraintViolationSQLException(null);
            }
            this.roleInserted = true;
            return "3";
        }

        public String[] sqlQuery(String sqlStr, String[] params) {
            if (this.roleInserted && "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles WHERE role_name = ?".equals(sqlStr)) {
                return new String[]{"3", "Test", "0", "0"};
            }
            return new String[0];
        }
    }

    private static class AddUserMockDatabase
    extends MockDatabase {
        private String[] updateQueryParameters;

        private AddUserMockDatabase() {
        }

        public String sqlProcedureStr(String procedure, String[] params) {
            return "3";
        }

        public int sqlUpdateQuery(String sqlStr, String[] params) {
            this.updateQueryParameters = params;
            return 1;
        }
    }
}

