/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.util.ChainableReversibleNullComparator;
import imcode.server.document.textdocument.MenuItemComparator;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.user.UserDomainObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.UnhandledException;

public class MenuDomainObject
implements Cloneable,
Serializable {
    private int id;
    private int sortOrder;
    private HashMap menuItems;
    public static final int MENU_SORT_ORDER__BY_HEADLINE = 1;
    public static final int MENU_SORT_ORDER__BY_MANUAL_ORDER_REVERSED = 2;
    public static final int MENU_SORT_ORDER__BY_MODIFIED_DATETIME_REVERSED = 3;
    public static final int MENU_SORT_ORDER__BY_MANUAL_TREE_ORDER = 4;
    public static final int MENU_SORT_ORDER__DEFAULT = 1;
    public static final int DEFAULT_SORT_KEY = 500;
    private static final int DEFAULT_SORT_KEY_INCREMENT = 10;

    public MenuDomainObject() {
        this(0, 1);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            MenuDomainObject clone = (MenuDomainObject)super.clone();
            clone.menuItems = new HashMap();
            Iterator iterator = this.menuItems.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Integer documentId = (Integer)entry.getKey();
                MenuItemDomainObject menuItem = (MenuItemDomainObject)entry.getValue();
                clone.menuItems.put(documentId, menuItem.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public MenuDomainObject(int id, int sortOrder) {
        this.id = id;
        this.sortOrder = sortOrder;
        this.menuItems = new HashMap();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public MenuItemDomainObject[] getMenuItemsUserCanSee(UserDomainObject user) {
        List menuItemsUserCanSee = this.getMenuItemsVisibleToUser(user);
        return menuItemsUserCanSee.toArray(new MenuItemDomainObject[menuItemsUserCanSee.size()]);
    }

    List getMenuItemsVisibleToUser(UserDomainObject user) {
        MenuItemDomainObject[] menuItemsArray = this.getMenuItems();
        ArrayList<MenuItemDomainObject> menuItemsUserCanSee = new ArrayList<MenuItemDomainObject>(this.menuItems.size());
        for (int i = 0; i < menuItemsArray.length; ++i) {
            MenuItemDomainObject menuItem = menuItemsArray[i];
            if (!user.canSeeDocumentWhenEditingMenus(menuItem.getDocument())) continue;
            menuItemsUserCanSee.add(menuItem);
        }
        Collections.sort(menuItemsUserCanSee, this.getMenuItemComparatorForSortOrder(this.sortOrder));
        return menuItemsUserCanSee;
    }

    public MenuItemDomainObject[] getPublishedMenuItemsUserCanSee(UserDomainObject user) {
        List menuItems = this.getMenuItemsVisibleToUser(user);
        CollectionUtils.filter((Collection)menuItems, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((MenuItemDomainObject)object).getDocument().isActive();
            }
        });
        return menuItems.toArray(new MenuItemDomainObject[menuItems.size()]);
    }

    public MenuItemDomainObject[] getMenuItems() {
        HashMap menuItemsClone = (HashMap)this.menuItems.clone();
        ArrayList<MenuItemDomainObject> menuItemsList = new ArrayList<MenuItemDomainObject>(menuItemsClone.size());
        Iterator iterator = menuItemsClone.values().iterator();
        while (iterator.hasNext()) {
            MenuItemDomainObject menuItem = (MenuItemDomainObject)iterator.next();
            if (null == menuItem.getDocument()) continue;
            menuItemsList.add(menuItem);
        }
        MenuItemDomainObject[] menuItemsArray = menuItemsList.toArray(new MenuItemDomainObject[menuItemsList.size()]);
        Arrays.sort(menuItemsArray, this.getMenuItemComparatorForSortOrder(this.sortOrder));
        return menuItemsArray;
    }

    public void addMenuItem(MenuItemDomainObject menuItem) {
        if (null == menuItem.getSortKey()) {
            Integer maxSortKey = this.getMaxSortKey();
            Integer sortKey = null != maxSortKey ? new Integer(maxSortKey + 10) : new Integer(500);
            menuItem.setSortKey(sortKey);
        }
        this.menuItems.put(new Integer(menuItem.getDocumentReference().getDocumentId()), menuItem);
    }

    private Integer getMaxSortKey() {
        Collection menuItemSortKeys = CollectionUtils.collect(this.menuItems.values(), (Transformer)new Transformer(){

            public Object transform(Object o) {
                return ((MenuItemDomainObject)o).getSortKey();
            }
        });
        if (menuItemSortKeys.isEmpty()) {
            return null;
        }
        return (Integer)Collections.max(menuItemSortKeys);
    }

    private Comparator getMenuItemComparatorForSortOrder(int sortOrder) {
        ChainableReversibleNullComparator comparator = MenuItemComparator.HEADLINE.chain(MenuItemComparator.ID);
        if (sortOrder == 4) {
            comparator = MenuItemComparator.TREE_SORT_KEY.chain(comparator);
        } else if (sortOrder == 2) {
            comparator = MenuItemComparator.SORT_KEY.reversed().chain(comparator);
        } else if (sortOrder == 3) {
            comparator = MenuItemComparator.MODIFIED_DATETIME.reversed().chain(comparator);
        }
        return comparator;
    }

    public void setSortOrder(int sortOrder) {
        switch (sortOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.sortOrder = sortOrder;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad sort order. Use one of the constants.");
            }
        }
    }

    public boolean isEmpty() {
        return this.menuItems.isEmpty();
    }

    public void removeMenuItemByDocumentId(int childId) {
        this.menuItems.remove(new Integer(childId));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MenuDomainObject)) {
            return false;
        }
        MenuDomainObject otherMenu = (MenuDomainObject)obj;
        return otherMenu.sortOrder == this.sortOrder && otherMenu.menuItems.equals(this.menuItems);
    }

    public int hashCode() {
        return this.sortOrder + this.menuItems.hashCode();
    }

    public int getSize() {
        return this.menuItems.size();
    }
}

