/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.index.DirectoryIndex;
import imcode.server.document.index.IndexException;
import imcode.util.io.FileUtility;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;

class IndexBuildingThread
extends Thread {
    private Set documentsToAddToNewIndex = Collections.synchronizedSet(new LinkedHashSet());
    private Set documentsToRemoveFromNewIndex = Collections.synchronizedSet(new LinkedHashSet());
    private final File indexDirectory;
    private boolean indexing;
    private static final Logger log = Logger.getLogger((String)IndexBuildingThread.class.getName());

    IndexBuildingThread(File indexDirectory) {
        super("Background indexing thread");
        this.setPriority(1);
        this.setDaemon(true);
        this.indexDirectory = indexDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        IndexBuildingThread indexBuildingThread;
        try {
            try {
                File newIndexDirectory = this.getDirectoryForNewIndex(this.indexDirectory);
                DirectoryIndex newIndex = new DirectoryIndex(newIndexDirectory);
                IndexBuildingThread indexBuildingThread2 = this;
                synchronized (indexBuildingThread2) {
                    this.indexing = true;
                }
                newIndex.rebuild();
                indexBuildingThread2 = this;
                synchronized (indexBuildingThread2) {
                    this.indexing = false;
                    this.considerDocumentsAddedOrRemovedDuringIndexing(newIndex);
                    FileUtility.backupRename(newIndex.getDirectory(), this.indexDirectory);
                }
                log.info((Object)"Indexing completed.");
            }
            catch (Throwable e) {
                log.fatal((Object)"Failed to index all documents.", e);
                Object var7_6 = null;
                IndexBuildingThread indexBuildingThread2 = this;
                synchronized (indexBuildingThread2) {
                    this.indexing = false;
                    return;
                }
            }
            Object var7_5 = null;
            indexBuildingThread = this;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            IndexBuildingThread indexBuildingThread3 = this;
            synchronized (indexBuildingThread3) {
                this.indexing = false;
                throw throwable;
            }
        }
        synchronized (indexBuildingThread) {
            this.indexing = false;
            return;
        }
    }

    private File getDirectoryForNewIndex(File indexDirectory) {
        File newIndexDirectory = indexDirectory;
        if (IndexReader.indexExists((File)newIndexDirectory)) {
            newIndexDirectory = new File(newIndexDirectory.getParentFile(), newIndexDirectory.getName() + ".new");
        }
        return newIndexDirectory;
    }

    private synchronized void considerDocumentsAddedOrRemovedDuringIndexing(DirectoryIndex index) throws IndexException {
        DocumentDomainObject document;
        log.debug((Object)"Considering documents added and removed during indexing.");
        Iterator iterator = this.documentsToAddToNewIndex.iterator();
        while (iterator.hasNext()) {
            document = (DocumentDomainObject)iterator.next();
            index.indexDocument(document);
            iterator.remove();
        }
        iterator = this.documentsToRemoveFromNewIndex.iterator();
        while (iterator.hasNext()) {
            document = (DocumentDomainObject)iterator.next();
            index.removeDocument(document);
            iterator.remove();
        }
    }

    public synchronized void addDocument(DocumentDomainObject document) {
        if (this.indexing) {
            this.documentsToAddToNewIndex.add(document);
        }
    }

    public synchronized void removeDocument(DocumentDomainObject document) {
        if (this.indexing) {
            this.documentsToRemoveFromNewIndex.add(document);
        }
    }
}

