/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermission;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import java.io.Serializable;

public class TextDocumentPermissionSetDomainObject
extends DocumentPermissionSetDomainObject
implements Serializable {
    private TemplateGroupDomainObject[] allowedTemplateGroups = new TemplateGroupDomainObject[0];
    private int[] allowedDocumentTypeIds = new int[0];
    private TemplateDomainObject defaultTemplate;
    public static final DocumentPermission EDIT_TEXTS = new DocumentPermission("editTexts");
    public static final DocumentPermission EDIT_MENUS = new DocumentPermission("editMenus");
    public static final DocumentPermission EDIT_TEMPLATE = new DocumentPermission("editTemplates");
    public static final DocumentPermission EDIT_INCLUDES = new DocumentPermission("editIncludes");
    public static final DocumentPermission EDIT_IMAGES = new DocumentPermission("editImages");

    public TextDocumentPermissionSetDomainObject(int typeId) {
        super(typeId);
    }

    public boolean getEditTexts() {
        return this.hasPermission(EDIT_TEXTS);
    }

    public void setEditTexts(boolean editTexts) {
        this.setPermission(EDIT_TEXTS, editTexts);
    }

    public boolean getEditMenus() {
        return this.hasPermission(EDIT_MENUS);
    }

    public void setEditMenus(boolean editMenus) {
        this.setPermission(EDIT_MENUS, editMenus);
    }

    public boolean getEditTemplates() {
        return this.hasPermission(EDIT_TEMPLATE);
    }

    public void setEditTemplates(boolean editTemplates) {
        this.setPermission(EDIT_TEMPLATE, editTemplates);
    }

    public boolean getEditIncludes() {
        return this.hasPermission(EDIT_INCLUDES);
    }

    public void setEditIncludes(boolean editIncludes) {
        this.setPermission(EDIT_INCLUDES, editIncludes);
    }

    public boolean getEditImages() {
        return this.hasPermission(EDIT_IMAGES);
    }

    public void setEditImages(boolean editImages) {
        this.setPermission(EDIT_IMAGES, editImages);
    }

    public void setFromBits(DocumentDomainObject document, DocumentPermissionSetMapper documentPermissionSetMapper, int permissionBits, boolean forNewDocuments) {
        documentPermissionSetMapper.setTextDocumentPermissionSetFromBits(document, this, permissionBits, forNewDocuments);
    }

    public void setAllowedTemplateGroups(TemplateGroupDomainObject[] allowedTemplateGroupNames) {
        this.allowedTemplateGroups = allowedTemplateGroupNames;
    }

    public TemplateGroupDomainObject[] getAllowedTemplateGroups(ImcmsServices services) {
        return this.allowedTemplateGroups;
    }

    public void setAllowedDocumentTypeIds(int[] allowedDocumentTypeIds) {
        this.allowedDocumentTypeIds = allowedDocumentTypeIds;
    }

    public int[] getAllowedDocumentTypeIds() {
        return this.allowedDocumentTypeIds;
    }

    public void setDefaultTemplate(TemplateDomainObject defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public TemplateDomainObject getDefaultTemplate() {
        return this.defaultTemplate;
    }
}

