/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.user.RoleDomainObject;
import java.util.Date;
import junit.framework.TestCase;

public class TestDocumentDomainObject
extends TestCase {
    DocumentDomainObject document;

    protected void setUp() throws Exception {
        super.setUp();
        this.document = new DocumentDomainObject(){

            public DocumentTypeDomainObject getDocumentType() {
                return null;
            }

            public void accept(DocumentVisitor documentVisitor) {
            }
        };
    }

    public void testDeepCloneRoles() throws CloneNotSupportedException {
        RoleDomainObject role = RoleDomainObject.SUPERADMIN;
        TestDocumentDomainObject.assertEquals((int)this.document.getPermissionSetIdForRole(role), (int)4);
        DocumentDomainObject clone = (DocumentDomainObject)this.document.clone();
        clone.setPermissionSetIdForRole(role, 0);
        TestDocumentDomainObject.assertEquals((int)clone.getPermissionSetIdForRole(role), (int)0);
        TestDocumentDomainObject.assertEquals((int)this.document.getPermissionSetIdForRole(role), (int)4);
    }

    public void testGetPublicationStatus() throws Exception {
        TestDocumentDomainObject.assertEquals((Object)DocumentDomainObject.LifeCyclePhase.NEW, (Object)this.document.getLifeCyclePhase());
        this.document.setStatus(1);
        TestDocumentDomainObject.assertEquals((Object)DocumentDomainObject.LifeCyclePhase.DISAPPROVED, (Object)this.document.getLifeCyclePhase());
        this.document.setStatus(2);
        TestDocumentDomainObject.assertEquals((Object)DocumentDomainObject.LifeCyclePhase.APPROVED, (Object)this.document.getLifeCyclePhase());
        this.document.setPublicationStartDatetime(new Date(0L));
        TestDocumentDomainObject.assertEquals((Object)DocumentDomainObject.LifeCyclePhase.PUBLISHED, (Object)this.document.getLifeCyclePhase());
        this.document.setArchivedDatetime(new Date(0L));
        TestDocumentDomainObject.assertEquals((Object)DocumentDomainObject.LifeCyclePhase.ARCHIVED, (Object)this.document.getLifeCyclePhase());
        this.document.setPublicationEndDatetime(new Date(0L));
        TestDocumentDomainObject.assertEquals((Object)DocumentDomainObject.LifeCyclePhase.UNPUBLISHED, (Object)this.document.getLifeCyclePhase());
    }
}

