/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.user.UserDomainObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class TemplateMapper {
    private static final String SPROC_GET_TEMPLATES_IN_GROUP = "GetTemplatesInGroup";
    private static final String SPROC_GET_TEMPLATE_GROUPS_FOR_USER = "GetTemplategroupsForUser";
    private static final String SPROC_GET_TEMPLATE_GROUPS = "GetTemplateGroups";
    private ImcmsServices service;

    public TemplateMapper(ImcmsServices service) {
        this.service = service;
    }

    public void addTemplateToGroup(TemplateDomainObject template, TemplateGroupDomainObject templateGroup) {
        String sqlStr = "INSERT INTO templates_cref (group_id,template_id) VALUES(?,?)";
        this.service.sqlUpdateQuery(sqlStr, new String[]{"" + templateGroup.getId(), "" + template.getId()});
    }

    public TemplateDomainObject[] createHtmlOptionListOfAllTemplatesExceptOne(TemplateDomainObject template) {
        TemplateDomainObject[] allTemplates = this.getAllTemplates();
        ArrayList<TemplateDomainObject> allTemplatesExceptOne = new ArrayList<TemplateDomainObject>(allTemplates.length - 1);
        for (int i = 0; i < allTemplates.length; ++i) {
            if (template.equals(allTemplates[i])) continue;
            allTemplatesExceptOne.add(allTemplates[i]);
        }
        TemplateDomainObject[] arrayOfAllTemplatesExceptOne = allTemplatesExceptOne.toArray(new TemplateDomainObject[allTemplatesExceptOne.size()]);
        return arrayOfAllTemplatesExceptOne;
    }

    public String createHtmlOptionListOfTemplateGroups(TemplateGroupDomainObject selectedTemplateGroup) {
        TemplateGroupDomainObject[] templateGroups = this.service.getTemplateMapper().getAllTemplateGroups();
        return this.createHtmlOptionListOfTemplateGroups(templateGroups, selectedTemplateGroup);
    }

    public String createHtmlOptionListOfTemplateGroups(TemplateGroupDomainObject[] templateGroups, TemplateGroupDomainObject selectedTemplateGroup) {
        String temps = "";
        for (int i = 0; i < templateGroups.length; ++i) {
            TemplateGroupDomainObject templateGroup = templateGroups[i];
            boolean selected = null != selectedTemplateGroup && selectedTemplateGroup.equals(templateGroup);
            temps = temps + "<option value=\"" + templateGroup.getId() + "\"" + (selected ? " selected" : "") + ">" + templateGroup.getName() + "</option>";
        }
        return temps;
    }

    public String createHtmlOptionListOfTemplates(TemplateDomainObject[] templates, TemplateDomainObject selectedTemplate) {
        HashSet<String> demoTemplateIds = new HashSet<String>();
        demoTemplateIds.addAll(Arrays.asList(this.service.getDemoTemplateIds()));
        String temps = "";
        for (int i = 0; i < templates.length; ++i) {
            TemplateDomainObject template = templates[i];
            boolean selected = selectedTemplate != null && selectedTemplate.equals(template);
            boolean hasDemoTemplate = demoTemplateIds.contains("" + template.getId());
            temps = temps + "<option value=\"" + template.getId() + "\"" + (selected ? " selected" : "") + ">" + (hasDemoTemplate ? "*" : "") + template.getName() + "</option>";
        }
        return temps;
    }

    public String createHtmlOptionListOfTemplatesWithDocumentCount(UserDomainObject user) {
        String htmlStr = "";
        TemplateMapper templateMapper = this.service.getTemplateMapper();
        TemplateDomainObject[] templates = templateMapper.getAllTemplates();
        for (int i = 0; i < templates.length; ++i) {
            TemplateDomainObject template = templates[i];
            ArrayList<String> tags = new ArrayList<String>();
            tags.add("#template_name#");
            tags.add(template.getName());
            tags.add("#docs#");
            tags.add("" + templateMapper.getCountOfDocumentsUsingTemplate(template));
            tags.add("#template_id#");
            tags.add("" + template.getId());
            htmlStr = htmlStr + this.service.getAdminTemplate("template_list_row.html", user, tags);
        }
        return htmlStr;
    }

    public void deleteTemplate(TemplateDomainObject template) {
        String sqlStr = "delete from templates_cref where template_id = ?";
        this.service.sqlUpdateQuery(sqlStr, new String[]{"" + template.getId()});
        sqlStr = "delete from templates where template_id = ?";
        this.service.sqlUpdateQuery(sqlStr, new String[]{"" + template.getId()});
        File f = new File(this.service.getTemplatePath() + "/text/" + template.getId() + ".html");
        if (f.exists()) {
            f.delete();
        }
    }

    public void deleteTemplateGroup(int grp_id) {
        this.service.sqlUpdateQuery("delete from templates_cref where group_id = ?", new String[]{"" + grp_id});
        this.service.sqlUpdateQuery("delete from templategroups where group_id = ?", new String[]{"" + grp_id});
    }

    public TemplateGroupDomainObject[] getAllTemplateGroups() {
        String[][] sprocResult = this.service.sqlProcedureMulti(SPROC_GET_TEMPLATE_GROUPS, new String[0]);
        return this.createTemplateGroupsFromSqlResult(sprocResult);
    }

    public TemplateGroupDomainObject[] getAllTemplateGroupsAvailableForUserOnDocument(UserDomainObject user, int metaId) {
        String[][] sprocResult = TemplateMapper.sprocGetTemplateGroupsForUser(this.service, user, metaId);
        return this.createTemplateGroupsFromSqlResult(sprocResult);
    }

    public TemplateDomainObject[] getAllTemplates() {
        String sqlStr = "select template_id,template_name,simple_name from templates order by simple_name";
        String[][] queryResult = this.service.sqlQueryMulti(sqlStr, new String[0]);
        return this.createTemplatesFromSqlResult(queryResult);
    }

    private int getCountOfDocumentsUsingTemplate(TemplateDomainObject template) {
        String queryResult = this.service.sqlQueryStr("SELECT COUNT(meta_id) FROM text_docs WHERE template_id = ?", new String[]{"" + template.getId()});
        int countOfDocumentsUsingTemplate = Integer.parseInt(queryResult);
        return countOfDocumentsUsingTemplate;
    }

    public DocumentDomainObject[] getDocumentsUsingTemplate(TemplateDomainObject template) {
        String[][] temp = this.service.sqlQueryMulti("select td.meta_id, meta_headline from text_docs td join meta m on td.meta_id = m.meta_id where template_id = ? order by td.meta_id", new String[]{"" + template.getId()});
        DocumentMapper documentMapper = this.service.getDocumentMapper();
        DocumentDomainObject[] documents = new DocumentDomainObject[temp.length];
        for (int i = 0; i < documents.length; ++i) {
            int documentId = Integer.parseInt(temp[i][0]);
            documents[i] = documentMapper.getDocument(documentId);
        }
        return documents;
    }

    public TemplateDomainObject getTemplateById(int template_id) {
        String sqlStr = "select template_id,template_name,simple_name from templates where template_id = ?";
        String[] queryResult = this.service.sqlQuery(sqlStr, new String[]{"" + template_id});
        return this.createTemplateFromSqlResultRow(queryResult);
    }

    public TemplateDomainObject getTemplateByName(String templateSimpleName) {
        String sqlStr = "select template_id,template_name,simple_name from templates where simple_name = ?";
        String[] queryResult = this.service.sqlQuery(sqlStr, new String[]{templateSimpleName});
        return this.createTemplateFromSqlResultRow(queryResult);
    }

    public TemplateGroupDomainObject getTemplateGroupById(int templateGroupId) {
        String sqlStr = "SELECT group_id,group_name FROM templategroups WHERE group_id = ?";
        String[] queryResult = this.service.sqlQuery(sqlStr, new String[]{"" + templateGroupId});
        return this.createTemplateGroupFromSqlResultRow(queryResult);
    }

    public TemplateGroupDomainObject getTemplateGroupByName(String name) {
        String[] sqlResultRow = this.service.sqlQuery("select group_id, group_name from templategroups where group_name = ?", new String[]{name});
        return this.createTemplateGroupFromSqlResultRow(sqlResultRow);
    }

    public TemplateDomainObject[] getTemplatesInGroup(TemplateGroupDomainObject templateGroup) {
        String[][] templateData = this.service.sqlProcedureMulti(SPROC_GET_TEMPLATES_IN_GROUP, new String[]{"" + templateGroup.getId()});
        TemplateDomainObject[] templates = new TemplateDomainObject[templateData.length];
        for (int i = 0; i < templateData.length; ++i) {
            int templateId = Integer.parseInt(templateData[i][0]);
            templates[i] = this.getTemplateById(templateId);
        }
        return templates;
    }

    public TemplateDomainObject[] getTemplatesNotInGroup(TemplateGroupDomainObject templateGroup) {
        List<TemplateDomainObject> templatesInGroup = Arrays.asList(this.getTemplatesInGroup(templateGroup));
        HashSet<TemplateDomainObject> allTemplates = new HashSet<TemplateDomainObject>(Arrays.asList(this.getAllTemplates()));
        allTemplates.removeAll(templatesInGroup);
        Object[] templatesNotInGroup = allTemplates.toArray(new TemplateDomainObject[allTemplates.size()]);
        Arrays.sort(templatesNotInGroup);
        return templatesNotInGroup;
    }

    public void removeTemplateFromGroup(TemplateDomainObject template, TemplateGroupDomainObject templateGroup) {
        String sqlStr = "DELETE FROM templates_cref WHERE group_id = ? AND template_id = ?";
        this.service.sqlUpdateQuery(sqlStr, new String[]{"" + templateGroup.getId(), "" + template.getId()});
    }

    public void renameTemplate(TemplateDomainObject template, String newNameForTemplate) {
        String sqlStr = "UPDATE templates SET simple_name = ? WHERE template_id = ?";
        this.service.sqlUpdateQuery(sqlStr, new String[]{newNameForTemplate, "" + template.getId()});
    }

    public void renameTemplateGroup(TemplateGroupDomainObject templateGroup, String newName) {
        String sqlStr = "update templategroups\nset group_name = ?\nwhere group_id = ?\n";
        this.service.sqlUpdateQuery(sqlStr, new String[]{newName, "" + templateGroup.getId()});
    }

    public void replaceAllUsagesOfTemplate(TemplateDomainObject template, TemplateDomainObject newTemplate, ImcmsServices imcref) {
        if (null != template && null != newTemplate) {
            String sqlStr = "update text_docs set template_id = ? where template_id = ?";
            imcref.sqlUpdateQuery(sqlStr, new String[]{"" + newTemplate.getId(), "" + template.getId()});
        }
    }

    private static String[][] sprocGetTemplateGroupsForUser(ImcmsServices service, UserDomainObject user, int meta_id) {
        return service.sqlProcedureMulti(SPROC_GET_TEMPLATE_GROUPS_FOR_USER, new String[]{String.valueOf(meta_id), String.valueOf(user.getId())});
    }

    private TemplateDomainObject createTemplateFromSqlResultRow(String[] sqlResultRow) {
        if (0 == sqlResultRow.length) {
            return null;
        }
        int templateId = Integer.parseInt(sqlResultRow[0]);
        String templateName = sqlResultRow[1];
        String simpleName = sqlResultRow[2];
        TemplateDomainObject result = new TemplateDomainObject(templateId, templateName, simpleName);
        return result;
    }

    private TemplateGroupDomainObject createTemplateGroupFromSqlResultRow(String[] sqlResultRow) {
        if (0 == sqlResultRow.length) {
            return null;
        }
        int templateGroupId = Integer.parseInt(sqlResultRow[0]);
        String templateGroupName = sqlResultRow[1];
        TemplateGroupDomainObject templateGroupDomainObject = new TemplateGroupDomainObject(templateGroupId, templateGroupName);
        return templateGroupDomainObject;
    }

    private TemplateGroupDomainObject[] createTemplateGroupsFromSqlResult(String[][] sprocResult) {
        TemplateGroupDomainObject[] templateGroups = new TemplateGroupDomainObject[sprocResult.length];
        for (int i = 0; i < sprocResult.length; ++i) {
            templateGroups[i] = this.createTemplateGroupFromSqlResultRow(sprocResult[i]);
        }
        return templateGroups;
    }

    private TemplateDomainObject[] createTemplatesFromSqlResult(String[][] queryResult) {
        TemplateDomainObject[] templates = new TemplateDomainObject[queryResult.length];
        for (int i = 0; i < queryResult.length; ++i) {
            templates[i] = this.createTemplateFromSqlResultRow(queryResult[i]);
        }
        return templates;
    }

    public void createTemplateGroup(String name) {
        this.service.sqlUpdateQuery("declare @new_id int\nselect @new_id = max(group_id)+1 from templategroups\ninsert into templategroups values(@new_id,?)", new String[]{name});
    }

    public boolean templateGroupContainsTemplate(TemplateGroupDomainObject templateGroup, TemplateDomainObject template) {
        return ArrayUtils.contains((Object[])this.getTemplatesInGroup(templateGroup), (Object)template);
    }
}

