/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermission;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class DocumentPermissionSetDomainObject
implements Serializable {
    public static final int TYPE_ID__FULL = 0;
    public static final int TYPE_ID__RESTRICTED_1 = 1;
    public static final int TYPE_ID__RESTRICTED_2 = 2;
    public static final int TYPE_ID__READ = 3;
    public static final int TYPE_ID__NONE = 4;
    public static final DocumentPermissionSetDomainObject NONE = new TextDocumentPermissionSetDomainObject(4){

        public boolean hasPermission(DocumentPermission permission) {
            return false;
        }
    };
    public static final DocumentPermissionSetDomainObject READ = new TextDocumentPermissionSetDomainObject(3){

        public boolean hasPermission(DocumentPermission permission) {
            return false;
        }
    };
    public static final DocumentPermissionSetDomainObject FULL = new TextDocumentPermissionSetDomainObject(0){

        public TemplateGroupDomainObject[] getAllowedTemplateGroups(ImcmsServices services) {
            return services.getTemplateMapper().getAllTemplateGroups();
        }

        public int[] getAllowedDocumentTypeIds() {
            return DocumentTypeDomainObject.getAllDocumentTypeIds();
        }

        public boolean hasPermission(DocumentPermission permission) {
            return true;
        }
    };
    static final DocumentPermission EDIT = new DocumentPermission("edit");
    private static final String PERMISSION_SET_NAME__FULL = "Full";
    private static final String PERMISSION_SET_NAME__RESTRICTED_1 = "Restricted One";
    private static final String PERMISSION_SET_NAME__RESTRICTED_2 = "Restricted Two";
    private static final String PERMISSION_SET_NAME__READ = "Read";
    private static final String PERMISSION_SET_NAME__NONE = "None";
    private int typeId;
    private Set permissions = new HashSet();
    static final DocumentPermission EDIT_DOCUMENT_INFORMATION = new DocumentPermission("editDocumentInformation");
    static final DocumentPermission EDIT_PERMISSIONS = new DocumentPermission("editPermissions");

    public DocumentPermissionSetDomainObject(int typeId) {
        if (0 > typeId || 4 < typeId) {
            throw new IllegalArgumentException("Invalid typeId: " + typeId);
        }
        this.typeId = typeId;
    }

    void setPermission(DocumentPermission permission, boolean b) {
        if (b) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    public boolean hasPermission(DocumentPermission permission) {
        return this.permissions.contains(permission);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getType() {
        return DocumentPermissionSetDomainObject.getName(this.typeId);
    }

    private static String getName(int userPermissionSetId) {
        String result;
        switch (userPermissionSetId) {
            case 0: {
                result = PERMISSION_SET_NAME__FULL;
                break;
            }
            case 1: {
                result = PERMISSION_SET_NAME__RESTRICTED_1;
                break;
            }
            case 2: {
                result = PERMISSION_SET_NAME__RESTRICTED_2;
                break;
            }
            case 3: {
                result = PERMISSION_SET_NAME__READ;
                break;
            }
            default: {
                result = PERMISSION_SET_NAME__NONE;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getType());
        switch (this.typeId) {
            case 1: 
            case 2: {
                buff.append(" (").append("editDocumentInformation=" + this.getEditDocumentInformation() + ", ").append("editPermissions=" + this.getEditPermissions() + ", ").append(")");
            }
        }
        return buff.toString();
    }

    public boolean getEditDocumentInformation() {
        return this.hasPermission(EDIT_DOCUMENT_INFORMATION);
    }

    public void setEditDocumentInformation(boolean editDocumentInformation) {
        this.setPermission(EDIT_DOCUMENT_INFORMATION, editDocumentInformation);
    }

    public boolean getEditPermissions() {
        return this.hasPermission(EDIT_PERMISSIONS);
    }

    public void setEditPermissions(boolean editPermissions) {
        this.setPermission(EDIT_PERMISSIONS, editPermissions);
    }

    void setFromBits(DocumentDomainObject document, DocumentPermissionSetMapper documentPermissionSetMapper, int permissionBits, boolean forNewDocuments) {
        documentPermissionSetMapper.setDocumentPermissionSetFromBits(this, permissionBits);
    }

    public boolean getEdit() {
        return this.hasPermission(EDIT);
    }

    public void setEdit(boolean edit) {
        this.setPermission(EDIT, edit);
    }
}

