/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.imcms.api.CategoryAlreadyExistsException;
import com.imcode.imcms.flow.DocumentPageFlow;
import imcode.server.Config;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.LanguageMapper;
import imcode.server.db.Database;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentCreatingVisitor;
import imcode.server.document.DocumentDeletingVisitor;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentInitializingVisitor;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.DocumentReference;
import imcode.server.document.DocumentSavingVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.MaxCategoryDomainObjectsOfTypeExceededException;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Clock;
import imcode.util.IdNamePair;
import imcode.util.Utility;
import imcode.util.io.FileUtility;
import java.io.File;
import java.io.FileFilter;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.math.IntRange;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.oro.text.perl.Perl5Util;

public class DocumentMapper {
    private static final Logger log = Logger.getLogger((String)DocumentMapper.class.getName());
    private static final int UNLIMITED_MAX_CATEGORY_CHOICES = 0;
    private static final int META_HEADLINE_MAX_LENGTH = 255;
    private static final int META_TEXT_MAX_LENGTH = 1000;
    private static final String SPROC_SECTION_GET_INHERIT_ID = "SectionGetInheritId";
    static final String SPROC_GET_DOCUMENT_INFO = "GetDocumentInfo";
    private static final String SPROC_GET_TEXT = "GetText";
    private static final String SPROC_SECTION_GET_ALL = "SectionGetAll";
    private static final String SPROC_GET_DOC_TYPES_FOR_USER = "GetDocTypesForUser";
    static final String SPROC_SET_PERMISSION_SET_ID_FOR_ROLE_ON_DOCUMENT = "SetRoleDocPermissionSetId";
    private static final String COPY_HEADLINE_SUFFIX_TEMPLATE = "copy_prefix.html";
    private final ImcmsAuthenticatorAndUserAndRoleMapper userAndRoleMapper;
    private final Database database;
    private final DocumentPermissionSetMapper documentPermissionSetMapper;
    private final DocumentIndex documentIndex;
    private final DocumentCache documentCache;
    private final Clock clock;
    private final ImcmsServices services;
    public static final String SQL_GET_ALL_CATEGORIES_OF_TYPE = "SELECT categories.category_id, categories.name, categories.description, categories.image\nFROM categories\nJOIN category_types ON categories.category_type_id = category_types.category_type_id\nWHERE categories.category_type_id = ?\nORDER BY categories.name";
    public static final String SQL_GET_CATEGORY = "SELECT categories.category_id, categories.name, categories.description, categories.image\nFROM categories\nJOIN category_types\nON categories.category_type_id = category_types.category_type_id\nWHERE category_types.name = ?\nAND categories.name = ?";
    public static final String SQL__CATEGORY_TYPE__COLUMNS = "category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited";

    public DocumentMapper(ImcmsServices services, Database database, ImcmsAuthenticatorAndUserAndRoleMapper userRegistry, DocumentPermissionSetMapper documentPermissionSetMapper, DocumentIndex documentIndex, Clock clock, Config config) {
        this.database = database;
        this.clock = clock;
        this.services = services;
        this.userAndRoleMapper = userRegistry;
        this.documentPermissionSetMapper = documentPermissionSetMapper;
        this.documentIndex = documentIndex;
        int documentCacheMaxSize = config.getDocumentCacheMaxSize();
        this.documentCache = new DocumentCache(Collections.synchronizedMap(new LRUMap(documentCacheMaxSize)), this);
    }

    public DocumentDomainObject createDocumentOfTypeFromParent(int documentTypeId, DocumentDomainObject parent, UserDomainObject user) {
        DocumentDomainObject newDocument;
        if (!user.canCreateDocumentOfTypeIdFromParent(documentTypeId, parent)) {
            throw new SecurityException("User can't create documents from document " + parent.getId());
        }
        try {
            if (2 == documentTypeId) {
                newDocument = (DocumentDomainObject)parent.clone();
                TextDocumentDomainObject newTextDocument = (TextDocumentDomainObject)newDocument;
                newTextDocument.removeAllTexts();
                newTextDocument.removeAllImages();
                newTextDocument.removeAllIncludes();
                newTextDocument.removeAllMenus();
                this.setTemplateForNewTextDocument(newTextDocument, user, parent);
            } else {
                newDocument = DocumentDomainObject.fromDocumentTypeId(documentTypeId);
                newDocument.setAttributes((DocumentDomainObject.Attributes)parent.getAttributes().clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
        newDocument.setId(0);
        newDocument.setHeadline("");
        newDocument.setMenuText("");
        newDocument.setMenuImage("");
        this.makeDocumentLookNew(newDocument, user);
        newDocument.removeNonInheritedCategories();
        return newDocument;
    }

    private void setTemplateForNewTextDocument(TextDocumentDomainObject newTextDocument, UserDomainObject user, DocumentDomainObject parent) {
        int permissionSetId = user.getPermissionSetIdFor(parent);
        TemplateDomainObject template = null;
        if (1 == permissionSetId) {
            template = ((TextDocumentPermissionSetDomainObject)newTextDocument.getPermissionSetForRestrictedOneForNewDocuments()).getDefaultTemplate();
        } else if (2 == permissionSetId) {
            template = ((TextDocumentPermissionSetDomainObject)newTextDocument.getPermissionSetForRestrictedTwoForNewDocuments()).getDefaultTemplate();
        } else if (parent instanceof TextDocumentDomainObject) {
            template = ((TextDocumentDomainObject)parent).getDefaultTemplate();
        }
        if (null != template) {
            newTextDocument.setTemplate(template);
        }
    }

    private void makeDocumentLookNew(DocumentDomainObject document, UserDomainObject user) {
        Date now = new Date();
        this.makeDocumentLookCreated(document, user, now);
        document.setPublicationStartDatetime(now);
        document.setArchivedDatetime(null);
        document.setPublicationEndDatetime(null);
        document.setStatus(0);
    }

    private void makeDocumentLookCreated(DocumentDomainObject document, UserDomainObject user, Date now) {
        document.setCreator(user);
        document.setCreatedDatetime(now);
        document.setModifiedDatetime(now);
    }

    public CategoryDomainObject[] getAllCategoriesOfType(CategoryTypeDomainObject categoryType) {
        String sqlQuery = SQL_GET_ALL_CATEGORIES_OF_TYPE;
        String[][] sqlResult = this.database.sqlQueryMulti(sqlQuery, new String[]{"" + categoryType.getId()});
        CategoryDomainObject[] categoryDomainObjects = new CategoryDomainObject[sqlResult.length];
        for (int i = 0; i < sqlResult.length; ++i) {
            int categoryId = Integer.parseInt(sqlResult[i][0]);
            String categoryName = sqlResult[i][1];
            String categoryDescription = sqlResult[i][2];
            String categoryImage = sqlResult[i][3];
            categoryDomainObjects[i] = new CategoryDomainObject(categoryId, categoryName, categoryDescription, categoryImage, categoryType);
        }
        return categoryDomainObjects;
    }

    public boolean isUniqueCategoryTypeName(String categoryTypeName) {
        CategoryTypeDomainObject[] categoryTypes = this.getAllCategoryTypes();
        for (int i = 0; i < categoryTypes.length; ++i) {
            CategoryTypeDomainObject categoryType = categoryTypes[i];
            if (!categoryType.getName().equalsIgnoreCase(categoryTypeName)) continue;
            return false;
        }
        return true;
    }

    public CategoryTypeDomainObject[] getAllCategoryTypes() {
        String sqlQuery = "SELECT category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited FROM category_types ORDER BY name";
        String[][] sqlResult = this.database.sqlQueryMulti(sqlQuery, new String[0]);
        CategoryTypeDomainObject[] categoryTypes = new CategoryTypeDomainObject[sqlResult.length];
        for (int i = 0; i < categoryTypes.length; ++i) {
            CategoryTypeDomainObject categoryType;
            categoryTypes[i] = categoryType = this.createCategoryTypeFromSqlResult(sqlResult[i], 0);
        }
        return categoryTypes;
    }

    private CategoryTypeDomainObject createCategoryTypeFromSqlResult(String[] sqlRow, int offset) {
        int categoryTypeId = Integer.parseInt(sqlRow[offset + 0]);
        String typeName = sqlRow[offset + 1];
        int maxChoices = Integer.parseInt(sqlRow[offset + 2]);
        boolean inherited = 0 != Integer.parseInt(sqlRow[offset + 3]);
        CategoryTypeDomainObject categoryTypeDomainObject = new CategoryTypeDomainObject(categoryTypeId, typeName, maxChoices, inherited);
        return categoryTypeDomainObject;
    }

    public SectionDomainObject[] getAllSections() {
        String[][] sqlRows = this.database.sqlProcedureMulti(SPROC_SECTION_GET_ALL, new String[0]);
        SectionDomainObject[] allSections = new SectionDomainObject[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            int sectionId = Integer.parseInt(sqlRows[i][0]);
            String sectionName = sqlRows[i][1];
            allSections[i] = new SectionDomainObject(sectionId, sectionName);
        }
        Arrays.sort(allSections, new SectionNameComparator());
        return allSections;
    }

    public CategoryDomainObject getCategory(CategoryTypeDomainObject categoryType, String categoryName) {
        String sqlQuery = SQL_GET_CATEGORY;
        String[] sqlResult = this.database.sqlQuery(sqlQuery, new String[]{categoryType.getName(), categoryName});
        if (0 != sqlResult.length) {
            int categoryId = Integer.parseInt(sqlResult[0]);
            String categoryNameFromDb = sqlResult[1];
            String categoryDescription = sqlResult[2];
            String categoryImge = sqlResult[3];
            return new CategoryDomainObject(categoryId, categoryNameFromDb, categoryDescription, categoryImge, categoryType);
        }
        return null;
    }

    public CategoryDomainObject getCategoryById(int categoryId) {
        String sqlQuery = "SELECT categories.name, categories.description, categories.image, category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited\nFROM categories\nJOIN category_types ON categories.category_type_id = category_types.category_type_id\nWHERE categories.category_id = ?";
        String[] categorySqlResult = this.database.sqlQuery(sqlQuery, new String[]{"" + categoryId});
        if (0 != categorySqlResult.length) {
            String categoryName = categorySqlResult[0];
            String categoryDescription = categorySqlResult[1];
            String categoryImage = categorySqlResult[2];
            CategoryTypeDomainObject categoryType = this.createCategoryTypeFromSqlResult(categorySqlResult, 3);
            return new CategoryDomainObject(categoryId, categoryName, categoryDescription, categoryImage, categoryType);
        }
        return null;
    }

    public CategoryTypeDomainObject getCategoryType(String categoryTypeName) {
        String sqlStr = "SELECT category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited\nFROM category_types\nWHERE category_types.name = ?";
        String[] sqlResult = this.database.sqlQuery(sqlStr, new String[]{categoryTypeName});
        if (null == sqlResult || 0 == sqlResult.length) {
            return null;
        }
        return this.createCategoryTypeFromSqlResult(sqlResult, 0);
    }

    public CategoryTypeDomainObject getCategoryTypeById(int categoryTypeId) {
        String sqlStr = "select category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited from category_types where category_type_id = ? ";
        String[] sqlResult = this.database.sqlQuery(sqlStr, new String[]{"" + categoryTypeId});
        if (null == sqlResult || 0 == sqlResult.length) {
            return null;
        }
        return this.createCategoryTypeFromSqlResult(sqlResult, 0);
    }

    public void deleteCategoryTypeFromDb(CategoryTypeDomainObject categoryType) {
        String sqlstr = "delete from category_types where category_type_id = ?";
        this.database.sqlUpdateQuery(sqlstr, new String[]{categoryType.getId() + ""});
    }

    public CategoryTypeDomainObject addCategoryTypeToDb(CategoryTypeDomainObject categoryType) {
        String sqlstr = "insert into category_types (name, max_choices, inherited) values(?,?,?) SELECT @@IDENTITY";
        String newId = this.database.sqlQueryStr(sqlstr, new String[]{categoryType.getName(), categoryType.getMaxChoices() + "", categoryType.isInherited() ? "1" : "0"});
        return this.getCategoryTypeById(Integer.parseInt(newId));
    }

    public void updateCategoryType(CategoryTypeDomainObject categoryType) {
        String sqlstr = "update category_types set name= ?, max_choices= ?  where category_type_id = ? ";
        this.database.sqlUpdateQuery(sqlstr, new String[]{categoryType.getName(), categoryType.getMaxChoices() + "", categoryType.getId() + ""});
    }

    public CategoryDomainObject addCategory(CategoryDomainObject category) throws CategoryAlreadyExistsException {
        String sqlstr = "insert into categories  (category_type_id, name, description, image) values(?,?,?,?) SELECT @@IDENTITY";
        String newId = this.database.sqlQueryStr(sqlstr, new String[]{category.getType().getId() + "", category.getName(), category.getDescription(), category.getImageUrl()});
        int categoryId = Integer.parseInt(newId);
        category.setId(categoryId);
        return this.getCategoryById(categoryId);
    }

    public void updateCategory(CategoryDomainObject category) {
        String sqlstr = "update categories set category_type_id = ?, name= ?, description = ?, image = ?  where category_id = ? ";
        this.database.sqlUpdateQuery(sqlstr, new String[]{category.getType().getId() + "", category.getName(), category.getDescription(), category.getImageUrl(), category.getId() + ""});
    }

    public void deleteCategoryFromDb(CategoryDomainObject category) {
        String sqlstr = "delete from categories where category_id = ?";
        this.database.sqlUpdateQuery(sqlstr, new String[]{category.getId() + ""});
    }

    public DocumentDomainObject getDocument(int metaId) {
        DocumentDomainObject document;
        NDC.push((String)"getDocument");
        try {
            document = (DocumentDomainObject)this.documentCache.get(new Integer(metaId));
            if (null != document) {
                document = (DocumentDomainObject)document.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
        NDC.pop();
        return document;
    }

    public DocumentReference getDocumentReference(DocumentDomainObject document) {
        if (null == document) {
            throw new NullArgumentException("document");
        }
        return this.getDocumentReference(document.getId());
    }

    DocumentReference getDocumentReference(int childId) {
        return new DocumentReference(childId, this);
    }

    private DocumentDomainObject getDocumentFromDb(int metaId) {
        NDC.push((String)"getDocumentFromDb");
        log.debug((Object)("Getting document " + metaId + " from db."));
        String[] result = this.sprocGetDocumentInfo(metaId);
        DocumentDomainObject document = null;
        if (0 != result.length) {
            document = this.getDocumentFromSqlResultRow(result);
            this.initDocumentAttributes(document);
            this.initDocumentCategories(document);
            this.initRolesMappedToDocumentPermissionSetIds(document);
            document.accept(new DocumentInitializingVisitor(this.services, this.database));
        }
        NDC.pop();
        return document;
    }

    public void initDocumentAttributes(DocumentDomainObject document) {
        document.setSections(this.getSections(document.getId()));
        document.setKeywords(this.getKeywords(document.getId()));
        document.setPermissionSetForRestrictedOne(this.documentPermissionSetMapper.getPermissionSetRestrictedOne(document));
        document.setPermissionSetForRestrictedTwo(this.documentPermissionSetMapper.getPermissionSetRestrictedTwo(document));
        document.setPermissionSetForRestrictedOneForNewDocuments(this.documentPermissionSetMapper.getPermissionSetRestrictedOneForNewDocuments(document));
        document.setPermissionSetForRestrictedTwoForNewDocuments(this.documentPermissionSetMapper.getPermissionSetRestrictedTwoForNewDocuments(document));
    }

    public void initDocumentCategories(DocumentDomainObject document) {
        this.addCategoriesFromDatabaseToDocument(document);
    }

    public void initRolesMappedToDocumentPermissionSetIds(DocumentDomainObject document) {
        String[][] sprocResult = this.database.sqlQueryMulti("SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions, rr.set_id\nFROM  roles, roles_rights AS rr\nWHERE rr.role_id = roles.role_id AND rr.meta_id = ?", new String[]{"" + document.getId()});
        for (int i = 0; i < sprocResult.length; ++i) {
            RoleDomainObject role = this.userAndRoleMapper.getRoleFromSqlResult(sprocResult[i]);
            int rolePermissionSetId = Integer.parseInt(sprocResult[i][4]);
            document.setPermissionSetIdForRole(role, rolePermissionSetId);
        }
    }

    public SectionDomainObject getSectionById(int sectionId) {
        String sectionName = this.database.sqlQueryStr("SELECT section_name FROM sections WHERE section_id = ?", new String[]{"" + sectionId});
        if (null == sectionName) {
            return null;
        }
        return new SectionDomainObject(sectionId, sectionName);
    }

    public SectionDomainObject getSectionByName(String name) {
        String[] sectionSqlRow = this.database.sqlQuery("SELECT section_id, section_name FROM sections WHERE section_name = ?", new String[]{name});
        if (0 == sectionSqlRow.length) {
            return null;
        }
        int sectionId = Integer.parseInt(sectionSqlRow[0]);
        String sectionName = sectionSqlRow[1];
        return new SectionDomainObject(sectionId, sectionName);
    }

    private SectionDomainObject[] getSections(int meta_id) {
        String[][] sectionData = this.database.sqlProcedureMulti(SPROC_SECTION_GET_INHERIT_ID, new String[]{String.valueOf(meta_id)});
        SectionDomainObject[] sections = new SectionDomainObject[sectionData.length];
        for (int i = 0; i < sectionData.length; ++i) {
            int sectionId = Integer.parseInt(sectionData[i][0]);
            String sectionName = sectionData[i][1];
            sections[i] = new SectionDomainObject(sectionId, sectionName);
        }
        return sections;
    }

    public TextDomainObject getText(int metaId, int no) {
        String[] results = this.sprocGetText(metaId, no);
        if (results == null || results.length == 0) {
            return null;
        }
        String text = results[0];
        int type = Integer.parseInt(results[1]);
        return new TextDomainObject(text, type);
    }

    public void removeInclusion(int includingMetaId, int includeIndex) {
        this.deleteInclude(includingMetaId, includeIndex);
    }

    public void saveNewDocument(DocumentDomainObject document, UserDomainObject user) throws MaxCategoryDomainObjectsOfTypeExceededException {
        if (!user.canEdit(document)) {
            return;
        }
        this.checkMaxDocumentCategoriesOfType(document);
        this.makeDocumentLookCreated(document, user, new Date());
        int newMetaId = this.sqlInsertIntoMeta(document);
        if (!user.isSuperAdminOrHasFullPermissionOn(document)) {
            document.setPermissionSetForRestrictedOne(document.getPermissionSetForRestrictedOneForNewDocuments());
            document.setPermissionSetForRestrictedTwo(document.getPermissionSetForRestrictedTwoForNewDocuments());
        }
        document.setId(newMetaId);
        this.updateDocumentSectionsCategoriesKeywords(document);
        this.updateDocumentRolePermissions(document, user, null);
        this.documentPermissionSetMapper.saveRestrictedDocumentPermissionSets(document, user, null);
        document.accept(new DocumentCreatingVisitor(user, this.database));
        this.invalidateDocument(document);
    }

    private void updateDocumentSectionsCategoriesKeywords(DocumentDomainObject document) {
        this.updateDocumentSections(document.getId(), document.getSections());
        this.updateDocumentCategories(document);
        this.updateDocumentKeywords(document.getId(), document.getKeywords());
    }

    private int sqlInsertIntoMeta(DocumentDomainObject document) {
        Object[] metaColumnNames = new String[]{"doc_type", "meta_headline", "meta_text", "meta_image", "owner_id", "permissions", "shared", "show_meta", "lang_prefix", "date_created", "date_modified", "disable_search", "target", "activate", "archived_datetime", "publisher_id", "status", "publication_start_datetime", "publication_end_datetime"};
        String sqlPlaceHolders = "?" + StringUtils.repeat((String)",?", (int)(metaColumnNames.length - 1));
        String sqlStr = "INSERT INTO meta (" + StringUtils.join((Object[])metaColumnNames, (String)",") + ") VALUES (" + sqlPlaceHolders + ") SELECT @@IDENTITY";
        ArrayList<String> sqlColumnValues = new ArrayList<String>();
        sqlColumnValues.add(document.getDocumentTypeId() + "");
        sqlColumnValues.add(document.getHeadline());
        sqlColumnValues.add(document.getMenuText());
        sqlColumnValues.add(document.getMenuImage());
        sqlColumnValues.add(document.getCreator().getId() + "");
        sqlColumnValues.add(this.makeSqlStringFromBoolean(document.isRestrictedOneMorePrivilegedThanRestrictedTwo()));
        sqlColumnValues.add(this.makeSqlStringFromBoolean(document.isLinkableByOtherUsers()));
        sqlColumnValues.add(this.makeSqlStringFromBoolean(document.isVisibleInMenusForUnauthorizedUsers()));
        sqlColumnValues.add(document.getLanguageIso639_2());
        sqlColumnValues.add(DocumentMapper.makeSqlStringFromDate(document.getCreatedDatetime()));
        sqlColumnValues.add(DocumentMapper.makeSqlStringFromDate(document.getModifiedDatetime()));
        sqlColumnValues.add(this.makeSqlStringFromBoolean(document.isSearchDisabled()));
        sqlColumnValues.add(document.getTarget());
        sqlColumnValues.add("1");
        sqlColumnValues.add(DocumentMapper.makeSqlStringFromDate(document.getArchivedDatetime()));
        sqlColumnValues.add(null != document.getPublisher() ? document.getPublisher().getId() + "" : null);
        sqlColumnValues.add("" + document.getStatus());
        sqlColumnValues.add(DocumentMapper.makeSqlStringFromDate(document.getPublicationStartDatetime()));
        sqlColumnValues.add(DocumentMapper.makeSqlStringFromDate(document.getPublicationEndDatetime()));
        String metaIdStr = this.database.sqlQueryStr(sqlStr, sqlColumnValues.toArray(new String[sqlColumnValues.size()]));
        int metaId = Integer.parseInt(metaIdStr);
        return metaId;
    }

    private String makeSqlStringFromBoolean(boolean bool) {
        return bool ? "1" : "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws MaxCategoryDomainObjectsOfTypeExceededException {
        DocumentDomainObject oldDocument = this.getDocument(document.getId());
        if (!user.canEdit(oldDocument)) {
            return;
        }
        this.checkMaxDocumentCategoriesOfType(document);
        try {
            Date lastModifiedDatetime = Utility.truncateDateToMinutePrecision(document.getLastModifiedDatetime());
            Date modifiedDatetime = Utility.truncateDateToMinutePrecision(document.getModifiedDatetime());
            boolean modifiedDatetimeUnchanged = lastModifiedDatetime.equals(modifiedDatetime);
            if (modifiedDatetimeUnchanged) {
                document.setModifiedDatetime(this.clock.getCurrentDate());
            }
            this.sqlUpdateMeta(document);
            this.updateDocumentSectionsCategoriesKeywords(document);
            if (user.canEditPermissionsFor(oldDocument)) {
                this.updateDocumentRolePermissions(document, user, oldDocument);
                this.documentPermissionSetMapper.saveRestrictedDocumentPermissionSets(document, user, oldDocument);
            }
            document.accept(new DocumentSavingVisitor(user, oldDocument, this.database));
        }
        finally {
            this.invalidateDocument(document);
        }
    }

    public void invalidateDocument(DocumentDomainObject document) {
        this.documentIndex.indexDocument(document);
        this.documentCache.remove(new Integer(document.getId()));
    }

    void updateDocumentRolePermissions(DocumentDomainObject document, UserDomainObject user, DocumentDomainObject oldDocument) {
        RoleDomainObject role;
        HashMap<RoleDomainObject, Integer> rolesMappedtoPermissionSetIds = new HashMap<RoleDomainObject, Integer>();
        if (null != oldDocument) {
            Set rolesMappedToPermissionsForOldDocument = oldDocument.getRolesMappedToPermissionSetIds().keySet();
            Iterator iterator = rolesMappedToPermissionsForOldDocument.iterator();
            while (iterator.hasNext()) {
                role = (RoleDomainObject)iterator.next();
                rolesMappedtoPermissionSetIds.put(role, new Integer(4));
            }
        }
        rolesMappedtoPermissionSetIds.putAll(document.getRolesMappedToPermissionSetIds());
        Iterator it = rolesMappedtoPermissionSetIds.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry rolePermissionTuple = it.next();
            role = (RoleDomainObject)rolePermissionTuple.getKey();
            int permissionSetId = (Integer)rolePermissionTuple.getValue();
            if (null != oldDocument && !user.canSetPermissionSetIdForRoleOnDocument(permissionSetId, role, oldDocument)) continue;
            this.database.sqlUpdateProcedure(SPROC_SET_PERMISSION_SET_ID_FOR_ROLE_ON_DOCUMENT, new String[]{"" + role.getId(), "" + document.getId(), "" + permissionSetId});
        }
    }

    private void checkMaxDocumentCategoriesOfType(DocumentDomainObject document) throws MaxCategoryDomainObjectsOfTypeExceededException {
        CategoryTypeDomainObject[] categoryTypes = this.getAllCategoryTypes();
        for (int i = 0; i < categoryTypes.length; ++i) {
            CategoryTypeDomainObject categoryType = categoryTypes[i];
            int maxChoices = categoryType.getMaxChoices();
            CategoryDomainObject[] documentCategoriesOfType = document.getCategoriesOfType(categoryType);
            if (0 == maxChoices || documentCategoriesOfType.length <= maxChoices) continue;
            throw new MaxCategoryDomainObjectsOfTypeExceededException("Document may have at most " + maxChoices + " categories of type '" + categoryType.getName() + "'");
        }
    }

    private void updateDocumentCategories(DocumentDomainObject document) {
        this.removeAllCategoriesFromDocument(document);
        CategoryDomainObject[] categories = document.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            CategoryDomainObject category = categories[i];
            this.addCategoryToDocument(category, document);
        }
    }

    private void addCategoryToDocument(CategoryDomainObject category, DocumentDomainObject document) {
        int categoryId = category.getId();
        this.database.sqlUpdateQuery("INSERT INTO document_categories (meta_id, category_id) VALUES(?,?)", new String[]{"" + document.getId(), "" + categoryId});
    }

    public String[] getAllDocumentsOfOneCategory(CategoryDomainObject category) {
        String sqlstr = "select meta_id from document_categories where category_id = ? ";
        String[] res = this.database.sqlQuery(sqlstr, new String[]{category.getId() + ""});
        return res;
    }

    private void removeAllCategoriesFromDocument(DocumentDomainObject document) {
        this.database.sqlUpdateQuery("DELETE FROM document_categories WHERE meta_id = ?", new String[]{"" + document.getId()});
    }

    public void deleteOneCategoryFromDocument(DocumentDomainObject document, CategoryDomainObject category) {
        this.database.sqlUpdateQuery("DELETE FROM document_categories WHERE meta_id = ? and category_id = ?", new String[]{document.getId() + "", category.getId() + ""});
    }

    private void sqlUpdateMeta(DocumentDomainObject document) {
        String headline = document.getHeadline();
        String text = document.getMenuText();
        StringBuffer sqlStr = new StringBuffer("update meta set ");
        ArrayList sqlUpdateColumns = new ArrayList();
        ArrayList<String> sqlUpdateValues = new ArrayList<String>();
        DocumentMapper.makeDateSqlUpdateClause("publication_start_datetime", document.getPublicationStartDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeDateSqlUpdateClause("publication_end_datetime", document.getPublicationEndDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeDateSqlUpdateClause("archived_datetime", document.getArchivedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeDateSqlUpdateClause("date_created", document.getCreatedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        String headlineThatFitsInDB = headline.substring(0, Math.min(headline.length(), 254));
        DocumentMapper.makeStringSqlUpdateClause("meta_headline", headlineThatFitsInDB, sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeStringSqlUpdateClause("meta_image", document.getMenuImage(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeDateSqlUpdateClause("date_modified", document.getModifiedDatetime(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeStringSqlUpdateClause("target", document.getTarget(), sqlUpdateColumns, sqlUpdateValues);
        String textThatFitsInDB = text.substring(0, Math.min(text.length(), 999));
        DocumentMapper.makeStringSqlUpdateClause("meta_text", textThatFitsInDB, sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeStringSqlUpdateClause("lang_prefix", document.getLanguageIso639_2(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeBooleanSqlUpdateClause("disable_search", document.isSearchDisabled(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeBooleanSqlUpdateClause("shared", document.isLinkableByOtherUsers(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeBooleanSqlUpdateClause("show_meta", document.isVisibleInMenusForUnauthorizedUsers(), sqlUpdateColumns, sqlUpdateValues);
        DocumentMapper.makeBooleanSqlUpdateClause("permissions", document.isRestrictedOneMorePrivilegedThanRestrictedTwo(), sqlUpdateColumns, sqlUpdateValues);
        UserDomainObject publisher = document.getPublisher();
        DocumentMapper.makeIntSqlUpdateClause("publisher_id", publisher == null ? null : new Integer(publisher.getId()), sqlUpdateColumns, sqlUpdateValues);
        UserDomainObject creator = document.getCreator();
        if (null != creator) {
            DocumentMapper.makeIntSqlUpdateClause("owner_id", new Integer(creator.getId()), sqlUpdateColumns, sqlUpdateValues);
        }
        DocumentMapper.makeIntSqlUpdateClause("status", new Integer(document.getStatus()), sqlUpdateColumns, sqlUpdateValues);
        sqlStr.append(StringUtils.join(sqlUpdateColumns.iterator(), (String)","));
        sqlStr.append(" where meta_id = ?");
        sqlUpdateValues.add("" + document.getId());
        this.database.sqlUpdateQuery(sqlStr.toString(), sqlUpdateValues.toArray(new String[sqlUpdateValues.size()]));
    }

    public void setInclude(int includingMetaId, int includeIndex, int includedMetaId) {
        this.database.sqlUpdateProcedure("SetInclude", new String[]{"" + includingMetaId, "" + includeIndex, "" + includedMetaId});
    }

    public void deleteInclude(int including_meta_id, int include_id) {
        this.database.sqlUpdateProcedure("DeleteInclude", new String[]{"" + including_meta_id, "" + include_id});
    }

    private void updateDocumentKeywords(int meta_id, String[] keywords) {
        HashSet<String> allKeywords = new HashSet<String>(Arrays.asList(this.getAllKeywords()));
        this.deleteKeywordsFromDocument(meta_id);
        for (int i = 0; i < keywords.length; ++i) {
            String keyword = keywords[i];
            boolean keywordExists = allKeywords.contains(keyword);
            if (!keywordExists) {
                this.addKeyword(keyword);
            }
            this.addExistingKeywordToDocument(meta_id, keyword);
        }
        this.deleteUnusedKeywords();
    }

    private void addExistingKeywordToDocument(int meta_id, String keyword) {
        int keywordId = Integer.parseInt(this.database.sqlQueryStr("SELECT class_id FROM classification WHERE code = ?", new String[]{keyword}));
        this.database.sqlUpdateQuery("INSERT INTO meta_classification (meta_id, class_id) VALUES(?,?)", new String[]{"" + meta_id, "" + keywordId});
    }

    private void deleteUnusedKeywords() {
        this.database.sqlUpdateQuery("DELETE FROM classification WHERE class_id NOT IN (SELECT class_id FROM meta_classification)", new String[0]);
    }

    private void addKeyword(String keyword) {
        this.database.sqlUpdateQuery("INSERT INTO classification VALUES(?)", new String[]{keyword});
    }

    private String[] getAllKeywords() {
        return this.database.sqlQuery("SELECT code FROM classification", new String[0]);
    }

    private void deleteKeywordsFromDocument(int meta_id) {
        String sqlDeleteKeywordsFromDocument = "DELETE FROM meta_classification WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlDeleteKeywordsFromDocument, new String[]{"" + meta_id});
    }

    private void addCategoriesFromDatabaseToDocument(DocumentDomainObject document) {
        String[][] categories = this.database.sqlQueryMulti("SELECT categories.category_id, categories.name, categories.image, categories.description, category_types.category_type_id, category_types.name, category_types.max_choices, category_types.inherited FROM document_categories JOIN categories  ON document_categories.category_id = categories.category_id JOIN category_types  ON categories.category_type_id = category_types.category_type_id WHERE document_categories.meta_id = ?", new String[]{"" + document.getId()});
        for (int i = 0; i < categories.length; ++i) {
            String[] categoryArray = categories[i];
            int categoryId = Integer.parseInt(categoryArray[0]);
            String categoryName = categoryArray[1];
            String categoryImage = categoryArray[2];
            String categoryDescription = categoryArray[3];
            CategoryTypeDomainObject categoryType = this.createCategoryTypeFromSqlResult(categoryArray, 4);
            CategoryDomainObject category = new CategoryDomainObject(categoryId, categoryName, categoryDescription, categoryImage, categoryType);
            document.addCategory(category);
        }
    }

    private void addSectionToDocument(int metaId, int sectionId) {
        this.database.sqlUpdateQuery("INSERT INTO meta_section VALUES(?,?)", new String[]{"" + metaId, "" + sectionId});
    }

    private static void makeBooleanSqlUpdateClause(String columnName, boolean bool, List sqlUpdateColumns, List sqlUpdateValues) {
        sqlUpdateColumns.add(columnName + " = ?");
        sqlUpdateValues.add(bool ? "1" : "0");
    }

    private static void makeDateSqlUpdateClause(String columnName, Date date, List sqlUpdateColumns, List sqlUpdateValues) {
        DocumentMapper.makeStringSqlUpdateClause(columnName, DocumentMapper.makeSqlStringFromDate(date), sqlUpdateColumns, sqlUpdateValues);
    }

    private static String makeSqlStringFromDate(Date date) {
        if (null == date) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    private static void makeIntSqlUpdateClause(String columnName, Integer integer, ArrayList sqlUpdateColumns, ArrayList sqlUpdateValues) {
        if (null != integer) {
            sqlUpdateColumns.add(columnName + " = ?");
            sqlUpdateValues.add("" + integer);
        } else {
            sqlUpdateColumns.add(columnName + " = NULL");
        }
    }

    private static void makeStringSqlUpdateClause(String columnName, String value, List sqlUpdateColumns, List sqlUpdateValues) {
        if (null != value) {
            sqlUpdateColumns.add(columnName + " = ?");
            sqlUpdateValues.add(value);
        } else {
            sqlUpdateColumns.add(columnName + " = NULL");
        }
    }

    private void removeAllSectionsFromDocument(int metaId) {
        this.database.sqlUpdateQuery("DELETE FROM meta_section WHERE meta_id = ?", new String[]{"" + metaId});
    }

    private void updateDocumentSections(int metaId, SectionDomainObject[] sections) {
        this.removeAllSectionsFromDocument(metaId);
        for (int i = 0; null != sections && i < sections.length; ++i) {
            SectionDomainObject section = sections[i];
            this.addSectionToDocument(metaId, section.getId());
        }
    }

    private String[] sprocGetDocumentInfo(int metaId) {
        String[] result = this.database.sqlProcedure(SPROC_GET_DOCUMENT_INFO, new String[]{String.valueOf(metaId)});
        return result;
    }

    private DocumentDomainObject getDocumentFromSqlResultRow(String[] result) {
        int documentTypeId = Integer.parseInt(result[1]);
        DocumentDomainObject document = DocumentDomainObject.fromDocumentTypeId(documentTypeId);
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = this.userAndRoleMapper;
        document.setId(Integer.parseInt(result[0]));
        document.setHeadline(result[2]);
        document.setMenuText(result[3]);
        document.setMenuImage(result[4]);
        UserDomainObject creator = imcmsAuthenticatorAndUserAndRoleMapper.getUser(Integer.parseInt(result[5]));
        document.setCreator(creator);
        document.setRestrictedOneMorePrivilegedThanRestrictedTwo(this.getBooleanFromSqlResultString(result[6]));
        document.setLinkableByOtherUsers(this.getBooleanFromSqlResultString(result[7]));
        document.setVisibleInMenusForUnauthorizedUsers(this.getBooleanFromSqlResultString(result[8]));
        document.setLanguageIso639_2(LanguageMapper.getAsIso639_2OrDefaultLanguage(result[9], this.services.getDefaultLanguage()));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        document.setCreatedDatetime(this.parseDateFormat(dateFormat, result[10]));
        Date modifiedDatetime = this.parseDateFormat(dateFormat, result[11]);
        document.setModifiedDatetime(modifiedDatetime);
        document.setLastModifiedDatetime(modifiedDatetime);
        document.setSearchDisabled(this.getBooleanFromSqlResultString(result[12]));
        document.setTarget(result[13]);
        document.setArchivedDatetime(this.parseDateFormat(dateFormat, result[14]));
        String publisherIdStr = result[15];
        if (null != publisherIdStr) {
            UserDomainObject publisher = imcmsAuthenticatorAndUserAndRoleMapper.getUser(Integer.parseInt(publisherIdStr));
            document.setPublisher(publisher);
        }
        document.setStatus(Integer.parseInt(result[16]));
        document.setPublicationStartDatetime(this.parseDateFormat(dateFormat, result[17]));
        document.setPublicationEndDatetime(this.parseDateFormat(dateFormat, result[18]));
        return document;
    }

    private boolean getBooleanFromSqlResultString(String columnValue) {
        return !"0".equals(columnValue);
    }

    private Date parseDateFormat(DateFormat dateFormat, String dateString) {
        try {
            return dateFormat.parse(dateString);
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private String[] sprocGetText(int meta_id, int no) {
        String[] params = new String[]{"" + meta_id, "" + no};
        String[] results = this.database.sqlProcedure(SPROC_GET_TEXT, params);
        return results;
    }

    private String[] getKeywords(int meta_id) {
        String sqlStr = "select code from classification c join meta_classification mc on mc.class_id = c.class_id where mc.meta_id = ?";
        String[] keywords = this.database.sqlQuery(sqlStr, new String[]{"" + meta_id});
        return keywords;
    }

    public DocumentIndex getDocumentIndex() {
        return this.documentIndex;
    }

    public String[][] getParentDocumentAndMenuIdsForDocument(DocumentDomainObject document) {
        String sqlStr = "SELECT meta_id,menu_index FROM childs, menus WHERE menus.menu_id = childs.menu_id AND to_meta_id = ?";
        return this.database.sqlQueryMulti(sqlStr, new String[]{"" + document.getId()});
    }

    public String[][] getAllMimeTypesWithDescriptions(UserDomainObject user) {
        String sqlStr = "SELECT mime, mime_name FROM mime_types WHERE lang_prefix = ? AND mime_id > 0 ORDER BY mime_id";
        String[][] mimeTypes = this.database.sqlQueryMulti(sqlStr, new String[]{user.getLanguageIso639_2()});
        return mimeTypes;
    }

    public String[] getAllMimeTypes() {
        String sqlStr = "SELECT mime FROM mime_types WHERE mime_id > 0 ORDER BY mime_id";
        String[] mimeTypes = this.database.sqlQuery(sqlStr, new String[0]);
        return mimeTypes;
    }

    public void addToMenu(TextDocumentDomainObject parentDocument, int parentMenuIndex, DocumentDomainObject documentToAddToMenu, UserDomainObject user) {
        parentDocument.getMenu(parentMenuIndex).addMenuItem(new MenuItemDomainObject(this.getDocumentReference(documentToAddToMenu)));
        this.saveDocument(parentDocument, user);
    }

    public BrowserDocumentDomainObject.Browser[] getAllBrowsers() {
        String sqlStr = "SELECT browser_id, name, value FROM browsers WHERE browser_id != 0";
        String[][] sqlResult = this.database.sqlQueryMulti(sqlStr, new String[0]);
        ArrayList<BrowserDocumentDomainObject.Browser> browsers = new ArrayList<BrowserDocumentDomainObject.Browser>();
        for (int i = 0; i < sqlResult.length; ++i) {
            browsers.add(this.createBrowserFromSqlRow(sqlResult[i]));
        }
        return browsers.toArray(new BrowserDocumentDomainObject.Browser[browsers.size()]);
    }

    public BrowserDocumentDomainObject.Browser getBrowserById(int browserIdToGet) {
        if (browserIdToGet == BrowserDocumentDomainObject.Browser.DEFAULT.getId()) {
            return BrowserDocumentDomainObject.Browser.DEFAULT;
        }
        String sqlStr = "SELECT browser_id, name, value FROM browsers WHERE browser_id = ?";
        String[] sqlRow = this.database.sqlQuery(sqlStr, new String[]{"" + browserIdToGet});
        BrowserDocumentDomainObject.Browser browser = this.createBrowserFromSqlRow(sqlRow);
        return browser;
    }

    protected BrowserDocumentDomainObject.Browser createBrowserFromSqlRow(String[] sqlRow) {
        int browserId = Integer.parseInt(sqlRow[0]);
        String browserName = sqlRow[1];
        int browserSpecificity = Integer.parseInt(sqlRow[2]);
        BrowserDocumentDomainObject.Browser browser = new BrowserDocumentDomainObject.Browser(browserId, browserName, browserSpecificity);
        return browser;
    }

    public void deleteDocument(DocumentDomainObject document) {
        this.database.sqlUpdateProcedure("DocumentDelete", new String[]{"" + document.getId()});
        document.accept(new DocumentDeletingVisitor());
        this.invalidateDocument(document);
    }

    public IdNamePair[] getCreatableDocumentTypeIdsAndNamesInUsersLanguage(DocumentDomainObject document, UserDomainObject user) {
        String[][] sqlRows = this.database.sqlProcedureMulti(SPROC_GET_DOC_TYPES_FOR_USER, new String[]{"" + document.getId(), "" + user.getId(), user.getLanguageIso639_2()});
        IdNamePair[] idNamePairs = new IdNamePair[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            String[] sqlRow = sqlRows[i];
            idNamePairs[i] = new IdNamePair(Integer.parseInt(sqlRow[0]), sqlRow[1]);
        }
        return idNamePairs;
    }

    public Map getAllDocumentTypeIdsAndNamesInUsersLanguage(UserDomainObject user) {
        String[][] rows = this.database.sqlQueryMulti("SELECT doc_type, type FROM doc_types WHERE lang_prefix = ? ORDER BY doc_type", new String[]{user.getLanguageIso639_2()});
        TreeMap<Integer, String> allDocumentTypeIdsAndNamesInUsersLanguage = new TreeMap<Integer, String>();
        for (int i = 0; i < rows.length; ++i) {
            String[] row = rows[i];
            Integer documentTypeId = Integer.valueOf(row[0]);
            String documentTypeNameInUsersLanguage = row[1];
            allDocumentTypeIdsAndNamesInUsersLanguage.put(documentTypeId, documentTypeNameInUsersLanguage);
        }
        return allDocumentTypeIdsAndNamesInUsersLanguage;
    }

    public TextDocumentMenuIndexPair[] getDocumentMenuPairsContainingDocument(DocumentDomainObject document) {
        String sqlSelectMenus = "SELECT meta_id, menu_index FROM menus, childs WHERE menus.menu_id = childs.menu_id AND childs.to_meta_id = ? ORDER BY meta_id, menu_index";
        String[][] sqlRows = this.database.sqlQueryMulti(sqlSelectMenus, new String[]{"" + document.getId()});
        TextDocumentMenuIndexPair[] documentMenuPairs = new TextDocumentMenuIndexPair[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            String[] sqlRow = sqlRows[i];
            int containingDocumentId = Integer.parseInt(sqlRow[0]);
            int menuIndex = Integer.parseInt(sqlRow[1]);
            TextDocumentDomainObject containingDocument = (TextDocumentDomainObject)this.getDocument(containingDocumentId);
            documentMenuPairs[i] = new TextDocumentMenuIndexPair(containingDocument, menuIndex);
        }
        return documentMenuPairs;
    }

    public Iterator getDocumentsIterator(IntRange idRange) {
        return new DocumentsIterator(this.getDocumentIds(idRange));
    }

    private int[] getDocumentIds(IntRange idRange) {
        String sqlSelectIds = "SELECT meta_id FROM meta WHERE meta_id >= ? AND meta_id <= ? ORDER BY meta_id";
        String[] documentIdStrings = this.database.sqlQuery(sqlSelectIds, new String[]{"" + idRange.getMinimumInteger(), "" + idRange.getMaximumInteger()});
        int[] documentIds = new int[documentIdStrings.length];
        for (int i = 0; i < documentIdStrings.length; ++i) {
            documentIds[i] = Integer.parseInt(documentIdStrings[i]);
        }
        return documentIds;
    }

    public int[] getAllDocumentIds() {
        String[] documentIdStrings = this.database.sqlQuery("SELECT meta_id FROM meta ORDER BY meta_id", new String[0]);
        int[] documentIds = new int[documentIdStrings.length];
        for (int i = 0; i < documentIdStrings.length; ++i) {
            documentIds[i] = Integer.parseInt(documentIdStrings[i]);
        }
        return documentIds;
    }

    static void deleteFileDocumentFilesAccordingToFileFilter(FileFilter fileFilter) {
        File filePath = Imcms.getServices().getConfig().getFilePath();
        File[] filesToDelete = filePath.listFiles(fileFilter);
        for (int i = 0; i < filesToDelete.length; ++i) {
            filesToDelete[i].delete();
        }
    }

    static void deleteAllFileDocumentFiles(FileDocumentDomainObject fileDocument) {
        DocumentMapper.deleteFileDocumentFilesAccordingToFileFilter(new FileDocumentFileFilter(fileDocument));
    }

    public DocumentPermissionSetMapper getDocumentPermissionSetMapper() {
        return this.documentPermissionSetMapper;
    }

    static void deleteOtherFileDocumentFiles(FileDocumentDomainObject fileDocument) {
        DocumentMapper.deleteFileDocumentFilesAccordingToFileFilter(new SuperfluousFileDocumentFilesFileFilter(fileDocument));
    }

    public void clearDocumentCache() {
        this.documentCache.clear();
    }

    public int getLowestDocumentId() {
        return Integer.parseInt(this.database.sqlQueryStr("SELECT MIN(meta_id) FROM meta", new String[0]));
    }

    public int getHighestDocumentId() {
        return Integer.parseInt(this.database.sqlQueryStr("SELECT MAX(meta_id) FROM meta", new String[0]));
    }

    public void copyDocument(DocumentDomainObject selectedChild, UserDomainObject user) {
        String copyHeadlineSuffix = this.services.getAdminTemplate(COPY_HEADLINE_SUFFIX_TEMPLATE, user, null);
        selectedChild.setHeadline(selectedChild.getHeadline() + copyHeadlineSuffix);
        this.makeDocumentLookNew(selectedChild, user);
        this.services.getDocumentMapper().saveNewDocument(selectedChild, user);
    }

    public void saveCategory(CategoryDomainObject category) throws CategoryAlreadyExistsException {
        CategoryDomainObject categoryInDb = this.getCategory(category.getType(), category.getName());
        if (null != categoryInDb && category.getId() != categoryInDb.getId()) {
            throw new CategoryAlreadyExistsException("A category with name \"" + category.getName() + "\" already exists in category type \"" + category.getType().getName() + "\".");
        }
        if (0 == category.getId()) {
            this.addCategory(category);
        } else {
            this.updateCategory(category);
        }
    }

    private static class SectionNameComparator
    implements Comparator {
        private SectionNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            SectionDomainObject section1 = (SectionDomainObject)o1;
            SectionDomainObject section2 = (SectionDomainObject)o2;
            return section1.getName().compareToIgnoreCase(section2.getName());
        }
    }

    private static class DocumentCache
    extends AbstractMapDecorator {
        private DocumentMapper documentMapper;

        DocumentCache(Map map, DocumentMapper documentMapper) {
            super(map);
            this.documentMapper = documentMapper;
        }

        public Object get(Object key) {
            SoftReference[] documentSoftReferenceArray = (SoftReference[])this.map.get(key);
            DocumentDomainObject document = null;
            if (null != documentSoftReferenceArray && null != documentSoftReferenceArray[0]) {
                document = (DocumentDomainObject)documentSoftReferenceArray[0].get();
            }
            if (null == document) {
                int documentId = (Integer)key;
                documentSoftReferenceArray = new SoftReference[1];
                this.map.put(key, documentSoftReferenceArray);
                document = this.documentMapper.getDocumentFromDb(documentId);
                documentSoftReferenceArray[0] = new SoftReference<DocumentDomainObject>(document);
            }
            return document;
        }
    }

    private static class SuperfluousFileDocumentFilesFileFilter
    extends FileDocumentFileFilter {
        private SuperfluousFileDocumentFilesFileFilter(FileDocumentDomainObject fileDocument) {
            super(fileDocument);
        }

        public boolean accept(File file, int fileDocumentId, String fileId) {
            boolean correctFileForFileDocumentFile = file.equals(DocumentSavingVisitor.getFileForFileDocument(fileDocumentId, fileId));
            boolean fileDocumentHasFile = null != this.fileDocument.getFile(fileId);
            return super.accept(file, fileDocumentId, fileId) && (!correctFileForFileDocumentFile || !fileDocumentHasFile);
        }
    }

    private static class FileDocumentFileFilter
    implements FileFilter {
        protected final FileDocumentDomainObject fileDocument;

        protected FileDocumentFileFilter(FileDocumentDomainObject fileDocument) {
            this.fileDocument = fileDocument;
        }

        public boolean accept(File file) {
            Perl5Util perl5Util = new Perl5Util();
            String filename = file.getName();
            if (perl5Util.match("/(\\d+)(?:_se|\\.(.*))?/", filename)) {
                String idStr = perl5Util.group(1);
                String variantName = FileUtility.unescapeFilename(StringUtils.defaultString((String)perl5Util.group(2)));
                return this.accept(file, Integer.parseInt(idStr), variantName);
            }
            return false;
        }

        public boolean accept(File file, int fileDocumentId, String fileId) {
            return fileDocumentId == this.fileDocument.getId();
        }
    }

    public static class SaveEditedDocumentCommand
    implements DocumentPageFlow.SaveDocumentCommand {
        public void saveDocument(DocumentDomainObject document, UserDomainObject user) {
            Imcms.getServices().getDocumentMapper().saveDocument(document, user);
        }
    }

    private class DocumentsIterator
    implements Iterator {
        int[] documentIds;
        int index = 0;

        DocumentsIterator(int[] documentIds) {
            this.documentIds = (int[])documentIds.clone();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.documentIds.length;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return DocumentMapper.this.getDocument(this.documentIds[this.index++]);
        }
    }

    public static class TextDocumentMenuIndexPair {
        private TextDocumentDomainObject document;
        private int menuIndex;

        public TextDocumentMenuIndexPair(TextDocumentDomainObject document, int menuIndex) {
            this.document = document;
            this.menuIndex = menuIndex;
        }

        public TextDocumentDomainObject getDocument() {
            return this.document;
        }

        public int getMenuIndex() {
            return this.menuIndex;
        }
    }
}

