/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.db.Database;
import imcode.server.document.DocumentStoringVisitor;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;

public class DocumentCreatingVisitor
extends DocumentStoringVisitor {
    public DocumentCreatingVisitor(UserDomainObject user, Database database) {
        super(user, database);
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject document) {
        String[] htmlDocumentColumns = new String[]{"meta_id", "frame_set"};
        String sqlUrlDocsInsertStr = DocumentCreatingVisitor.makeSqlInsertString("frameset_docs", htmlDocumentColumns);
        this.database.sqlUpdateQuery(sqlUrlDocsInsertStr, new String[]{"" + document.getId(), document.getHtml()});
    }

    public void visitUrlDocument(UrlDocumentDomainObject document) {
        String[] urlDocumentColumns = new String[]{"meta_id", "frame_name", "target", "url_ref", "url_txt", "lang_prefix"};
        String sqlUrlDocsInsertStr = DocumentStoringVisitor.makeSqlInsertString("url_docs", urlDocumentColumns);
        this.database.sqlUpdateQuery(sqlUrlDocsInsertStr, new String[]{"" + document.getId(), "", "", document.getUrl(), "", ""});
    }

    public void visitTextDocument(TextDocumentDomainObject textDocument) {
        String sqlTextDocsInsertStr = "INSERT INTO text_docs (meta_id, template_id, group_id, default_template, default_template_1, default_template_2) VALUES (?,?,?,?,?,?)";
        TemplateDomainObject textDocumentTemplate = textDocument.getTemplate();
        TemplateDomainObject defaultTemplate = textDocument.getDefaultTemplate();
        TemplateDomainObject defaultTemplateForRestricted1 = ((TextDocumentPermissionSetDomainObject)textDocument.getPermissionSetForRestrictedOneForNewDocuments()).getDefaultTemplate();
        TemplateDomainObject defaultTemplateForRestricted2 = ((TextDocumentPermissionSetDomainObject)textDocument.getPermissionSetForRestrictedTwoForNewDocuments()).getDefaultTemplate();
        int templateId = textDocumentTemplate.getId();
        int templateGroupId = textDocument.getTemplateGroupId();
        int textDocumentId = textDocument.getId();
        this.database.sqlUpdateQuery(sqlTextDocsInsertStr, new String[]{"" + textDocumentId, "" + templateId, "" + templateGroupId, null != defaultTemplate ? "" + defaultTemplate.getId() : null, null != defaultTemplateForRestricted1 ? "" + defaultTemplateForRestricted1.getId() : "-1", null != defaultTemplateForRestricted2 ? "" + defaultTemplateForRestricted2.getId() : "-1"});
        this.updateTextDocumentTexts(textDocument);
        this.updateTextDocumentImages(textDocument);
        this.updateTextDocumentIncludes(textDocument);
    }
}

