/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.diverse;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Properties;
import java.util.StringTokenizer;

public class SettingsAccessor {
    private String fileName;
    private Properties settingsTable;
    private String delimiter;
    private UserDomainObject user;
    private String directory;

    public SettingsAccessor(String fileName, UserDomainObject user, String directory) {
        this.fileName = fileName;
        this.user = user;
        this.directory = directory;
        this.settingsTable = new Properties();
        this.delimiter = "||";
    }

    public void setDelimiter(String newDelim) {
        this.delimiter = newDelim;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadSettings() throws IOException {
        Properties result;
        ImcmsServices imcref = Imcms.getServices();
        BufferedReader inputFromFile = new BufferedReader(new StringReader(imcref.getTemplateFromDirectory(this.fileName, this.user, null, this.directory)));
        SettingsAccessor settingsAccessor = this;
        synchronized (settingsAccessor) {
            String aLine;
            Properties table = new Properties();
            while ((aLine = inputFromFile.readLine()) != null) {
                String propName = "";
                String propVal = "";
                StringTokenizer st = new StringTokenizer(aLine, this.delimiter);
                if (st.hasMoreTokens()) {
                    propName = this.convertArgument(st.nextToken().trim());
                }
                if (st.hasMoreTokens()) {
                    propVal = st.nextToken().trim();
                }
                table.put(propName, propVal);
            }
            result = table;
        }
        this.settingsTable = result;
        inputFromFile.close();
    }

    public String toString() {
        return this.settingsTable.toString();
    }

    public String getSetting(String wantedProp) {
        String retStr = null;
        String wantedStr = this.convertArgument(wantedProp);
        retStr = (String)this.settingsTable.get(wantedStr);
        return retStr;
    }

    private String convertArgument(String theProp) {
        return theProp.toUpperCase();
    }
}

