/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.util.HumanReadable;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.WebAppGlobalConstants;
import imcode.server.user.UserDomainObject;
import imcode.util.MultipartFormdataParser;
import imcode.util.Utility;
import imcode.util.io.FileUtility;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class FileAdmin
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)"FileAdmin");
    private static final int BUFFER_SIZE = 65536;
    private static final String ADMIN_TEMPLATE_FILE_ADMIN_COPY_OVERWRIGHT_WARNING = "FileAdminCopyOverwriteWarning.html";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            Utility.redirectToStartDocument(req, res);
            return;
        }
        Utility.setNoCache(res);
        File dir1 = null;
        File dir2 = null;
        File[] roots = this.getRoots();
        switch (roots.length) {
            default: {
                dir1 = roots[0];
                dir2 = roots[1];
                break;
            }
            case 1: {
                dir2 = dir1 = roots[0];
            }
            case 0: 
        }
        this.outputFileAdmin(res, user, dir1, dir2);
    }

    private boolean isUnderRoot(File path, File[] roots) {
        for (int i = 0; i < roots.length; ++i) {
            if (!FileUtility.directoryIsAncestorOfOrEqualTo(roots[i], path)) continue;
            return true;
        }
        return false;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String dir2Parameter;
        File dir2;
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            Utility.redirectToStartDocument(req, res);
            return;
        }
        Utility.setNoCache(res);
        MultipartFormdataParser mp = this.getMultiPartFormDataParserForRequest(req);
        if (mp.getParameter("cancel") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
        File[] roots = this.getRoots();
        File webappPath = WebAppGlobalConstants.getInstance().getAbsoluteWebAppPath();
        String dir1Parameter = mp.getParameter("dir1");
        File dir1 = new File(dir1Parameter);
        if (!dir1.isAbsolute()) {
            dir1 = new File(webappPath, dir1Parameter);
        }
        if (!(dir2 = new File(dir2Parameter = mp.getParameter("dir2"))).isAbsolute()) {
            dir2 = new File(webappPath, dir2Parameter);
        }
        if (!this.isUnderRoot(dir1, roots) || !this.isUnderRoot(dir2, roots)) {
            this.doGet(req, res);
            return;
        }
        String[] files1 = mp.getParameterValues("files1");
        String[] files2 = mp.getParameterValues("files2");
        String name = mp.getParameter("name");
        boolean outputHasBeenHandled = false;
        if (mp.getParameter("change1") != null) {
            dir1 = this.changeDir(files1, dir1, roots);
        } else if (mp.getParameter("change2") != null) {
            dir2 = this.changeDir(files2, dir2, roots);
        } else if (mp.getParameter("mkdir1") != null) {
            File destDir = dir1;
            outputHasBeenHandled = this.makeDirectory(name, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("mkdir2") != null) {
            File destDir = dir2;
            outputHasBeenHandled = this.makeDirectory(name, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("delete1") != null) {
            File dir = dir1;
            String[] files = files1;
            outputHasBeenHandled = this.delete(dir, files, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("delete2") != null) {
            File dir = dir2;
            String[] files = files2;
            outputHasBeenHandled = this.delete(dir, files, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("deleteok") != null) {
            this.deleteOk(mp, roots);
        } else if (mp.getParameter("upload1") != null) {
            File destDir = dir1;
            outputHasBeenHandled = this.upload(mp, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("upload2") != null) {
            File destDir = dir2;
            outputHasBeenHandled = this.upload(mp, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("download1") != null) {
            outputHasBeenHandled = this.download(files1, dir1, res);
        } else if (mp.getParameter("download2") != null) {
            outputHasBeenHandled = this.download(files2, dir2, res);
        } else if (mp.getParameter("rename1") != null) {
            File dir = dir1;
            String[] files = files1;
            outputHasBeenHandled = this.rename(files, name, dir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("rename2") != null) {
            File dir = dir2;
            String[] files = files2;
            outputHasBeenHandled = this.rename(files, name, dir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("copy1") != null) {
            File sourceDir = dir1;
            File destDir = dir2;
            String[] files = files1;
            outputHasBeenHandled = this.copy(files, sourceDir, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("copy2") != null) {
            File sourceDir = dir2;
            File destDir = dir1;
            String[] files = files2;
            outputHasBeenHandled = this.copy(files, sourceDir, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("copyok") != null) {
            this.copyOk(mp, roots);
        } else if (mp.getParameter("move1") != null) {
            File sourceDir = dir1;
            File destDir = dir2;
            String[] files = files1;
            outputHasBeenHandled = this.move(files, sourceDir, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("move2") != null) {
            File sourceDir = dir2;
            File destDir = dir1;
            String[] files = files2;
            outputHasBeenHandled = this.move(files, sourceDir, destDir, dir1, dir2, res, user, imcref);
        } else if (mp.getParameter("moveok") != null) {
            this.moveOk(mp, roots);
        }
        if (!outputHasBeenHandled) {
            this.outputFileAdmin(res, user, dir1, dir2);
        }
    }

    private File[] getRoots() {
        String rootpaths = Imcms.getServices().getConfig().getFileAdminRootPaths();
        ArrayList<File> rootList = new ArrayList<File>();
        if (rootpaths != null) {
            StringTokenizer st = new StringTokenizer(rootpaths, ":;");
            int tokenCount = st.countTokens();
            for (int i = 0; i < tokenCount; ++i) {
                String oneRoot = st.nextToken().trim();
                File oneRootFile = FileUtility.getFileFromWebappRelativePath(oneRoot);
                if (!oneRootFile.isDirectory()) continue;
                rootList.add(oneRootFile);
            }
        }
        File[] roots = rootList.toArray(new File[rootList.size()]);
        return roots;
    }

    private boolean move(String[] files, File sourceDir, File destDir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (files != null && !sourceDir.equals(destDir)) {
            File[] sourceFileTree = this.makeFileTreeList(this.makeAbsoluteFileList(sourceDir, files), false);
            File[] relativeSourceFileTree = this.makeRelativeFileList(sourceDir, sourceFileTree);
            StringBuffer optionList = new StringBuffer();
            StringBuffer fileList = new StringBuffer();
            for (int i = 0; i < relativeSourceFileTree.length; ++i) {
                File destFile = new File(destDir, relativeSourceFileTree[i].getPath());
                fileList.append(relativeSourceFileTree[i]).append(File.pathSeparator);
                if (!destFile.exists()) continue;
                String optionString = destFile.getCanonicalPath() + (destFile.isDirectory() ? File.separator : " [" + destFile.length() + "]");
                optionList.append("<option>").append(optionString).append("</option>");
            }
            if (optionList.length() > 0) {
                this.outputMoveOverwriteWarning(optionList.toString(), sourceDir, destDir, fileList.toString(), dir1, dir2, res, user, imcref);
                handledOutput = true;
            } else {
                File[] destFiles = this.makeAbsoluteFileList(destDir, relativeSourceFileTree);
                for (int i = 0; i < sourceFileTree.length; ++i) {
                    File destFile = destFiles[i];
                    destFile.getParentFile().mkdirs();
                    File sourceFile = sourceFileTree[i];
                    if (sourceFile.isFile()) {
                        FileUtils.copyFile((File)sourceFile, (File)destFile);
                    }
                    if (sourceFile.length() != destFile.length()) continue;
                    FileUtils.forceDelete((File)sourceFile);
                }
            }
        }
        return handledOutput;
    }

    private boolean copy(String[] files, File sourceDir, File destDir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (files != null && !sourceDir.equals(destDir)) {
            File[] sourceFileTree = this.makeFileTreeList(this.makeAbsoluteFileList(sourceDir, files), true);
            File[] relativeSourceFileTree = this.makeRelativeFileList(sourceDir, sourceFileTree);
            StringBuffer optionList = new StringBuffer();
            StringBuffer fileList = new StringBuffer();
            for (int i = 0; i < relativeSourceFileTree.length; ++i) {
                File destFile = new File(destDir, relativeSourceFileTree[i].getPath());
                fileList.append(relativeSourceFileTree[i]).append(File.pathSeparator);
                if (!destFile.exists()) continue;
                String optionString = destFile.getCanonicalPath() + (destFile.isDirectory() ? File.separator : " [" + destFile.length() + ']');
                optionList.append("<option>").append(optionString).append("</option>");
            }
            if (optionList.length() > 0) {
                this.ouputCopyOverwriteWarning(optionList.toString(), sourceDir, destDir, fileList.toString(), dir1, dir2, res, user, imcref);
                handledOutput = true;
            } else {
                File[] destFileTree = this.makeAbsoluteFileList(destDir, relativeSourceFileTree);
                for (int i = 0; i < sourceFileTree.length; ++i) {
                    File sourceFile = sourceFileTree[i];
                    File destFile = destFileTree[i];
                    if (sourceFile.isDirectory()) {
                        destFile.mkdir();
                        continue;
                    }
                    FileUtils.copyFile((File)sourceFile, (File)destFile);
                }
            }
        }
        return handledOutput;
    }

    private boolean rename(String[] files, String name, File dir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (files != null && files.length == 1) {
            if (name != null && name.length() > 0) {
                File oldFilename = new File(dir, files[0]);
                File newFilename = new File(dir, name);
                if (oldFilename.exists()) {
                    oldFilename.renameTo(newFilename);
                }
            } else {
                this.outputBlankFilenameError(dir1, dir2, res, user, imcref);
                handledOutput = true;
            }
        }
        return handledOutput;
    }

    private boolean download(String[] files, File dir, HttpServletResponse res) throws IOException {
        boolean handledOutput = false;
        if (files != null && files.length == 1) {
            File file = new File(dir, files[0]);
            try {
                int bytes_read;
                res.setContentType("application/octet-stream");
                res.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + '\"');
                BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
                byte[] buffer = new byte[65536];
                res.setContentLength(fin.available());
                ServletOutputStream out = res.getOutputStream();
                while ((bytes_read = fin.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes_read);
                }
                handledOutput = true;
            }
            catch (FileNotFoundException ex) {
                log.debug((Object)"Download failed", (Throwable)ex);
            }
        }
        return handledOutput;
    }

    private boolean delete(File dir, String[] files, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        File[] farray = this.makeFileTreeList(this.makeAbsoluteFileList(dir, files), false);
        File[] filelist = this.makeRelativeFileList(dir, farray);
        if (filelist != null && filelist.length > 0) {
            this.outputDeleteWarning(filelist, dir1, dir2, dir, res, user, imcref);
            handledOutput = true;
        }
        return handledOutput;
    }

    private boolean makeDirectory(String name, File dir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        boolean handledOutput = false;
        if (name != null && name.length() > 0) {
            File newname = new File(dir, name);
            if (!newname.exists()) {
                newname.mkdir();
            }
        } else {
            this.outputBlankFilenameError(dir1, dir2, res, user, imcref);
            handledOutput = true;
        }
        return handledOutput;
    }

    private boolean upload(MultipartFormdataParser mp, File destDir, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        File uniqueFile;
        boolean handledOutput = false;
        String fileContents = mp.getParameter("file");
        if (fileContents == null || fileContents.length() < 1) {
            this.outputBlankFileError(dir1, dir2, res, user, imcref);
            handledOutput = true;
            return handledOutput;
        }
        String filename = new File(mp.getFilename("file")).getName();
        File file = new File(destDir, filename);
        if (file.equals(uniqueFile = FileAdmin.findUniqueFilename(file)) || file.renameTo(uniqueFile)) {
            FileOutputStream fout = new FileOutputStream(file);
            byte[] bytes = fileContents.getBytes("8859_1");
            fout.write(bytes);
            fout.flush();
            fout.close();
            if (!file.equals(uniqueFile)) {
                this.outputFileExistedAndTheOriginalWasRenamedNotice(dir1, dir2, uniqueFile.getName(), res, user, imcref);
                handledOutput = true;
            }
        } else {
            handledOutput = false;
        }
        return handledOutput;
    }

    private MultipartFormdataParser getMultiPartFormDataParserForRequest(HttpServletRequest req) throws IOException {
        int length = req.getContentLength();
        ServletInputStream in = req.getInputStream();
        byte[] buffer = new byte[length];
        for (int bytes_read = 0; bytes_read < length; bytes_read += in.read(buffer, bytes_read, length - bytes_read)) {
        }
        String contentType = req.getContentType();
        MultipartFormdataParser mp = new MultipartFormdataParser(buffer, contentType);
        return mp;
    }

    private void outputFileAdmin(HttpServletResponse res, UserDomainObject user, File dir1, File dir2) throws IOException {
        Utility.setDefaultHtmlContentType(res);
        res.getOutputStream().print(this.parseFileAdmin(user, dir1, dir2));
    }

    static File findUniqueFilename(File file) {
        int counter = 1;
        String previousSuffix = "";
        while (file.exists()) {
            String filenameWithoutSuffix = StringUtils.substringBeforeLast((String)file.getName(), (String)previousSuffix);
            String suffix = "." + counter;
            ++counter;
            file = new File(file.getParentFile(), filenameWithoutSuffix + suffix);
            previousSuffix = suffix;
        }
        return file;
    }

    private void outputMoveOverwriteWarning(String option_list, File sourceDir, File destDir, String file_list, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#filelist#");
        vec.add(option_list);
        vec.add("#source#");
        vec.add(sourceDir.getCanonicalPath());
        vec.add("#dest#");
        vec.add(destDir.getCanonicalPath());
        vec.add("#files#");
        vec.add(file_list);
        vec.add("#dir1#");
        vec.add(dir1.getCanonicalPath());
        vec.add("#dir2#");
        vec.add(dir2.getCanonicalPath());
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminMoveOverwriteWarning.html", user, vec));
    }

    private void ouputCopyOverwriteWarning(String option_list, File sourceDir, File destDir, String file_list, File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#filelist#");
        vec.add(option_list);
        vec.add("#source#");
        vec.add(sourceDir.getCanonicalPath());
        vec.add("#dest#");
        vec.add(destDir.getCanonicalPath());
        vec.add("#files#");
        vec.add(file_list);
        vec.add("#dir1#");
        vec.add(dir1.getCanonicalPath());
        vec.add("#dir2#");
        vec.add(dir2.getCanonicalPath());
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate(ADMIN_TEMPLATE_FILE_ADMIN_COPY_OVERWRIGHT_WARNING, user, vec));
    }

    private void outputFileExistedAndTheOriginalWasRenamedNotice(File dir1, File dir2, String newFilename, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#dir1#");
        vec.add(dir1.getCanonicalPath());
        vec.add("#dir2#");
        vec.add(dir2.getCanonicalPath());
        vec.add("#filename#");
        vec.add(newFilename);
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminFileExisted.html", user, vec));
    }

    private void outputBlankFileError(File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#dir1#");
        vec.add(dir1.getCanonicalPath());
        vec.add("#dir2#");
        vec.add(dir2.getCanonicalPath());
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminFileBlank.html", user, vec));
    }

    private void outputDeleteWarning(File[] filelist, File dir1, File dir2, File sourceDir, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        StringBuffer files = new StringBuffer();
        StringBuffer optionlist = new StringBuffer();
        for (int i = 0; i < filelist.length; ++i) {
            File foo = new File(sourceDir, filelist[i].getPath());
            String bar = foo.getCanonicalPath() + (foo.isDirectory() ? File.separator : " [" + foo.length() + "]");
            optionlist.append("<option>").append(bar).append("</option>");
            files.append(filelist[i]).append(File.pathSeparator);
        }
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#filelist#");
        vec.add(optionlist.toString());
        vec.add("#files#");
        vec.add(files.toString());
        vec.add("#source#");
        vec.add(sourceDir.getCanonicalPath());
        vec.add("#dir1#");
        vec.add(dir1.getCanonicalPath());
        vec.add("#dir2#");
        vec.add(dir2.getCanonicalPath());
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminDeleteWarning.html", user, vec));
    }

    private void outputBlankFilenameError(File dir1, File dir2, HttpServletResponse res, UserDomainObject user, ImcmsServices imcref) throws IOException {
        ArrayList<String> vec = new ArrayList<String>();
        vec.add("#dir1#");
        vec.add(dir1.getCanonicalPath());
        vec.add("#dir2#");
        vec.add(dir2.getCanonicalPath());
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        out.print(imcref.getAdminTemplate("FileAdminNameBlank.html", user, vec));
    }

    private void moveOk(MultipartFormdataParser mp, File[] roots) throws IOException {
        String src = mp.getParameter("source");
        String dst = mp.getParameter("dest");
        String files = mp.getParameter("files");
        if (src != null && dst != null && files != null) {
            File srcdir = new File(src);
            File dstdir = new File(dst);
            if (this.isUnderRoot(srcdir, roots) && this.isUnderRoot(dstdir, roots)) {
                StringTokenizer st = new StringTokenizer(files, ":;");
                while (st.hasMoreTokens()) {
                    String foo = st.nextToken();
                    File source = new File(srcdir, foo);
                    File dest = new File(dstdir, foo);
                    dest.getParentFile().mkdirs();
                    if (source.isFile()) {
                        FileUtils.copyFile((File)source, (File)dest);
                    }
                    if (source.length() != dest.length()) continue;
                    FileUtils.forceDelete((File)source);
                }
            }
        }
    }

    private void copyOk(MultipartFormdataParser mp, File[] roots) throws IOException {
        String src = mp.getParameter("source");
        String dst = mp.getParameter("dest");
        String files = mp.getParameter("files");
        if (src != null && dst != null && files != null) {
            File srcdir = new File(src);
            File dstdir = new File(dst);
            if (this.isUnderRoot(srcdir, roots) && this.isUnderRoot(dstdir, roots)) {
                StringTokenizer st = new StringTokenizer(files, ":;");
                while (st.hasMoreTokens()) {
                    String foo = st.nextToken();
                    File source = new File(srcdir, foo);
                    File dest = new File(dstdir, foo);
                    if (source.isDirectory()) {
                        dest.mkdir();
                        continue;
                    }
                    FileUtils.copyFile((File)source, (File)dest);
                }
            }
        }
    }

    private void deleteOk(MultipartFormdataParser mp, File[] roots) throws IOException {
        String path;
        String files = mp.getParameter("files");
        if (files != null && (path = mp.getParameter("source")) != null) {
            StringTokenizer st = new StringTokenizer(files, ":;");
            while (st.hasMoreTokens()) {
                File foo = new File(path, st.nextToken());
                if (!foo.exists() || !this.isUnderRoot(foo.getParentFile(), roots)) continue;
                FileUtils.forceDelete((File)foo);
            }
        }
    }

    private File changeDir(String[] files, File dir, File[] roots) {
        File resultDir = dir;
        if (files != null && files.length == 1) {
            File newDir = new File(files[0]);
            if (!newDir.isAbsolute()) {
                newDir = new File(dir, files[0]);
                if (newDir.isDirectory() && this.isUnderRoot(newDir, roots)) {
                    resultDir = newDir;
                }
            } else if (this.isUnderRoot(newDir, roots)) {
                resultDir = newDir;
            }
        }
        return resultDir;
    }

    private File[] makeAbsoluteFileList(File parent, String[] filePaths) {
        File[] files = new File[filePaths.length];
        for (int i = 0; i < filePaths.length; ++i) {
            String filePath = filePaths[i];
            files[i] = new File(filePath);
        }
        return this.makeAbsoluteFileList(parent, files);
    }

    private File[] makeAbsoluteFileList(File parent, File[] files) {
        if (files == null || parent == null) {
            return null;
        }
        LinkedList<File> list = new LinkedList<File>();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getPath();
            if ("..".equals(filename) || new File(filename).isAbsolute()) continue;
            list.add(new File(parent, filename));
        }
        return list.toArray(new File[list.size()]);
    }

    private File[] makeRelativeFileList(File relativeParentDir, File[] files) {
        if (files == null || relativeParentDir == null) {
            return null;
        }
        File[] relativeFileList = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            relativeFileList[i] = FileUtility.relativizeFile(relativeParentDir, file);
        }
        return relativeFileList;
    }

    private File[] makeFileTreeList(File[] files, boolean dirfirst) {
        if (files == null) {
            return new File[0];
        }
        LinkedList<File> list = new LinkedList<File>();
        for (int i = 0; i < files.length; ++i) {
            if (dirfirst) {
                list.add(files[i]);
            }
            if (files[i].isDirectory()) {
                File[] sub_list = this.makeFileTreeList(files[i].listFiles(), dirfirst);
                for (int j = 0; j < sub_list.length; ++j) {
                    list.add(sub_list[j]);
                }
            }
            if (dirfirst) continue;
            list.add(files[i]);
        }
        File[] result = new File[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (File)list.removeFirst();
        }
        return result;
    }

    private String parseFileAdmin(UserDomainObject user, File fd1, File fd2) throws IOException {
        String optionlist;
        ImcmsServices imcref = Imcms.getServices();
        File[] rootlist = this.getRoots();
        ArrayList<String> vec = new ArrayList<String>();
        File webappPath = WebAppGlobalConstants.getInstance().getAbsoluteWebAppPath();
        if (fd1 != null) {
            vec.add("#dir1#");
            vec.add(this.getPathRelativeTo(fd1, webappPath) + File.separator);
            optionlist = this.createDirectoryOptionList(rootlist, fd1);
            vec.add("#files1#");
            vec.add(optionlist);
        } else {
            vec.add("#dir1#");
            vec.add("");
            vec.add("#files1#");
            vec.add("");
        }
        if (fd2 != null) {
            vec.add("#dir2#");
            vec.add(this.getPathRelativeTo(fd2, webappPath) + File.separator);
            optionlist = this.createDirectoryOptionList(rootlist, fd2);
            vec.add("#files2#");
            vec.add(optionlist);
        } else {
            vec.add("#dir2#");
            vec.add("");
            vec.add("#files2#");
            vec.add("");
        }
        return imcref.getAdminTemplate("FileAdmin.html", user, vec);
    }

    private String getPathRelativeTo(File file, File root) throws IOException {
        if (!FileUtility.directoryIsAncestorOfOrEqualTo(root, file)) {
            return file.getCanonicalPath();
        }
        if (file.equals(root)) {
            return "";
        }
        return FileUtility.relativizeFile(root, file).getPath();
    }

    private String createDirectoryOptionList(File[] rootlist, File directory) throws IOException {
        StringBuffer optionlist = new StringBuffer();
        for (int i = 0; i < rootlist.length; ++i) {
            optionlist.append(this.getDirectoryOption(rootlist[i]));
        }
        File parent = directory.getParentFile();
        if (this.isUnderRoot(parent, rootlist)) {
            optionlist.append(this.getDirectoryOption(parent, ".."));
        }
        File[] dirlist = directory.listFiles((FileFilter)DirectoryFileFilter.INSTANCE);
        Arrays.sort(dirlist, this.getFileComparator());
        for (int i = 0; null != dirlist && i < dirlist.length; ++i) {
            optionlist.append(this.getDirectoryOption(dirlist[i], dirlist[i].getName()));
        }
        File[] filelist = directory.listFiles((FileFilter)new NotFileFilter(DirectoryFileFilter.INSTANCE));
        Arrays.sort(filelist, this.getFileComparator());
        for (int i = 0; null != filelist && i < filelist.length; ++i) {
            String formatedFileSize = HumanReadable.getHumanReadableByteSize(filelist[i].length());
            String fileNameAndSize = filelist[i].getName() + " [" + formatedFileSize + "]";
            optionlist.append("<option value=\"").append(filelist[i].getName()).append("\">").append(fileNameAndSize).append("</option>");
        }
        return optionlist.toString();
    }

    private String getDirectoryOption(File dir) throws IOException {
        File webappPath = WebAppGlobalConstants.getInstance().getAbsoluteWebAppPath();
        String displayDir = this.getPathRelativeTo(dir, webappPath);
        return this.getDirectoryOption(dir, displayDir);
    }

    private String getDirectoryOption(File dir, String displayDir) {
        return "<option style=\"background-color:#f0f0f0\" value=\"" + dir + File.separator + "\">" + displayDir + File.separator + "</option>";
    }

    private Comparator getFileComparator() {
        return new Comparator(){

            public int compare(Object a, Object b) {
                File filea = (File)a;
                File fileb = (File)b;
                if (filea.isDirectory() && !fileb.isDirectory()) {
                    return -1;
                }
                if (!filea.isDirectory() && fileb.isDirectory()) {
                    return 1;
                }
                return filea.getName().compareToIgnoreCase(fileb.getName());
            }
        };
    }
}

