/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Parser;
import imcode.util.Utility;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AdminListDocs
extends Administrator {
    private static final Logger log = Logger.getLogger((String)AdminListDocs.class.getName());
    private static final String TEMPLATE_LISTDOC = "AdminListDocs.html";
    private static final String TEMPLATE_LISTDOC_LIST_MODIFIED = "AdminListDocs_doclList_modified.html";
    private static final String TEMPLATE_LISTDOC_LIST_CREATED = "AdminListDocs_doclList_created.html";
    private static final String TEMPLATE_LISTDOC_LIST_ELEMENT = "AdminListDocs_doclList_element.html";
    private static final String ERROR_HEADER = "AdminListDocs";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!user.isSuperAdmin()) {
            return;
        }
        Map allDocumentTypeIdsAndNames = imcref.getDocumentMapper().getAllDocumentTypeIdsAndNamesInUsersLanguage(user);
        StringBuffer optionList = new StringBuffer();
        Iterator iterator = allDocumentTypeIdsAndNames.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer documentTypeId = (Integer)entry.getKey();
            String documentTypeName = (String)entry.getValue();
            optionList.append(Html.option("" + documentTypeId, documentTypeName, false));
        }
        VariableManager vm = new VariableManager();
        vm.addProperty("DOCUMENT_TYPES", optionList.toString());
        this.sendHtml(request, response, vm, TEMPLATE_LISTDOC);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        String eMailServerMaster = imcref.getSystemData().getServerMasterAddress();
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminListDocs. ";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(request, response, header, msg);
            return;
        }
        if (request.getParameter("CANCEL") != null) {
            response.sendRedirect("AdminManager");
            return;
        }
        if (request.getParameter("LISTDOC_LIST") != null) {
            boolean noErrors = true;
            String parseTemplate = null;
            int[] docTypesToShow = null;
            String[] docTypeStrings = request.getParameterValues("DOC_TYPES");
            int[] docTypes = new int[docTypeStrings.length];
            for (int i = 0; i < docTypeStrings.length; ++i) {
                docTypes[i] = Integer.parseInt(docTypeStrings[i]);
            }
            String listMod = request.getParameter("LISTMOD");
            String startDate = request.getParameter("START_DATE");
            String endDate = request.getParameter("END_DATE");
            try {
                if (listMod != null) {
                    int mod = Integer.parseInt(listMod);
                    if (mod != 1 && mod != 2) {
                        noErrors = false;
                    } else {
                        switch (mod) {
                            case 1: {
                                parseTemplate = TEMPLATE_LISTDOC_LIST_CREATED;
                                break;
                            }
                            default: {
                                parseTemplate = TEMPLATE_LISTDOC_LIST_MODIFIED;
                            }
                        }
                    }
                } else {
                    noErrors = false;
                }
                if (docTypes != null) {
                    docTypesToShow = docTypes;
                    for (int i = 0; i < docTypes.length; ++i) {
                        int testVar = docTypes[i];
                        if (testVar != 0) continue;
                        docTypesToShow = DocumentTypeDomainObject.getAllDocumentTypeIds();
                    }
                } else {
                    noErrors = false;
                }
            }
            catch (NumberFormatException e) {
                noErrors = false;
            }
            if (startDate != null) {
                if (startDate.length() > 0) {
                    if (!this.isDateInRightFormat(startDate)) {
                        noErrors = false;
                    }
                } else {
                    startDate = "0";
                }
            } else {
                noErrors = false;
            }
            if (endDate != null) {
                if (endDate.length() > 0) {
                    if (!this.isDateInRightFormat(endDate)) {
                        noErrors = false;
                    }
                } else {
                    endDate = "0";
                }
            } else {
                noErrors = false;
            }
            if (noErrors) {
                String htmlListElement = imcref.getAdminTemplate(TEMPLATE_LISTDOC_LIST_ELEMENT, user, null);
                String[] tagData = new String[]{"#META_ID#", null, "#DOC_TYPE#", null, "#HEADER#", null, "#DATE#", null};
                StringBuffer listOfDocs = new StringBuffer();
                String languagePrefix = user.getLanguageIso639_2();
                for (int i = 0; i < docTypesToShow.length; ++i) {
                    String[][] queryResult = imcref.sqlProcedureMulti("ListDocsByDate", new String[]{listMod, "" + docTypesToShow[i], startDate, endDate, languagePrefix});
                    for (int j = 0; j < queryResult.length; ++j) {
                        tagData[1] = queryResult[j][0];
                        tagData[3] = queryResult[j][1];
                        tagData[5] = queryResult[j][2];
                        tagData[7] = queryResult[j][3];
                        listOfDocs.append(Parser.parseDoc(htmlListElement, tagData));
                    }
                }
                String selectedDocTypesName = this.getSelectedDocTypeNames(imcref, docTypes, user);
                VariableManager vm = new VariableManager();
                vm.addProperty("LIST_DOCUMENT", listOfDocs.toString());
                vm.addProperty("selectedDocTypes", selectedDocTypesName);
                vm.addProperty("selectedStartDate", startDate);
                vm.addProperty("selectedEndDate", endDate);
                this.sendHtml(request, response, vm, parseTemplate);
            } else {
                this.sendErrorMessage(imcref, eMailServerMaster, user, ERROR_HEADER, 10, response);
            }
        }
    }

    private String getSelectedDocTypeNames(ImcmsServices imcref, int[] selectedDocTypeIds, UserDomainObject user) {
        ArrayList selectedDocTypeNames = new ArrayList();
        Map allDocTypes = imcref.getDocumentMapper().getAllDocumentTypeIdsAndNamesInUsersLanguage(user);
        for (int i = 0; i < selectedDocTypeIds.length; ++i) {
            int selectedDocTypeId = selectedDocTypeIds[i];
            selectedDocTypeNames.add(allDocTypes.get(new Integer(selectedDocTypeId)));
        }
        return StringUtils.join(selectedDocTypeNames.iterator(), (String)", ");
    }

    private boolean isDateInRightFormat(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            formatter.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }
}

