/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AdminIpAccess
extends Administrator {
    Logger log = Logger.getLogger((Class)AdminIpAccess.class);
    private final String HTML_TEMPLATE = "AdminIpAccess.htm";
    private final String HTML_IP_SNIPPET = "AdminIpAccessList.htm";
    private final String ADD_IP_TEMPLATE = "AdminIpAccess_Add.htm";
    private final String WARN_DEL_IP_TEMPLATE = "AdminIpAccess_Delete2.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        String[][] multi = imcref.sqlProcedureMulti("IPAccessesGetAll", new String[0]);
        Vector<String> tags = new Vector<String>();
        tags.add("IP_ACCESS_ID");
        tags.add("USER_ID");
        tags.add("LOGIN_NAME");
        tags.add("IP_START");
        tags.add("IP_END");
        String recs = "";
        int nbrOfRows = multi.length;
        for (int counter = 0; counter < nbrOfRows; ++counter) {
            Vector<String> aRecV = new Vector<String>(Arrays.asList(multi[counter]));
            VariableManager vmRec = new VariableManager();
            aRecV.setElementAt(Utility.ipLongToString(Long.parseLong(aRecV.elementAt(3))), 3);
            aRecV.setElementAt(Utility.ipLongToString(Long.parseLong(aRecV.elementAt(4))), 4);
            for (int i = 0; i < tags.size(); ++i) {
                vmRec.addProperty(tags.get(i), aRecV.get(i));
            }
            vmRec.addProperty("RECORD_COUNTER", "" + counter);
            recs = recs + super.createHtml(req, vmRec, "AdminIpAccessList.htm");
        }
        VariableManager vm = new VariableManager();
        vm.addProperty("ALL_IP_ACCESSES", recs);
        super.sendHtml(req, res, vm, "AdminIpAccess.htm");
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminCounter.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            this.log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        if (req.getParameter("ADD_IP_ACCESS") != null) {
            String[] usersArr = imcref.sqlProcedure("GetAllUsersInList", new String[0]);
            Vector<String> usersV = new Vector<String>(Arrays.asList(usersArr));
            String usersOption = Html.createOptionList("", usersV);
            VariableManager vm = new VariableManager();
            vm.addProperty("USERS_LIST", usersOption);
            super.sendHtml(req, res, vm, "AdminIpAccess_Add.htm");
            return;
        }
        if (req.getParameter("CANCEL_ADD_IP") != null || req.getParameter("IP_CANCEL_DELETE") != null) {
            res.sendRedirect("AdminIpAccess?action=start");
            return;
        }
        if (req.getParameter("IP_CANCEL_DELETE") != null) {
            res.sendRedirect("AdminIpAccess?action=start");
            return;
        }
        if (req.getParameter("ADD_NEW_IP_ACCESS") != null) {
            this.log.debug((Object)"Now's ADD_IP_ACCESS running");
            Properties params = this.getAddParameters(req);
            params = this.validateParameters(params, req, res, imcref, user);
            if (params == null) {
                return;
            }
            imcref.sqlUpdateProcedure("IPAccessAdd", new String[]{params.getProperty("USER_ID"), params.getProperty("IP_START"), params.getProperty("IP_END")});
            res.sendRedirect("AdminIpAccess?action=start");
            return;
        }
        if (req.getParameter("RESAVE_IP_ACCESS") != null) {
            String[] reSavesIds = this.getEditedIpAccesses(req);
            if (reSavesIds != null) {
                for (int i = 0; i < reSavesIds.length; ++i) {
                    this.log.debug((Object)("ResaveId: " + reSavesIds[i]));
                    String tmpId = reSavesIds[i];
                    String ipAccessId = req.getParameter("IP_ACCESS_ID_" + tmpId);
                    String ipUserId = req.getParameter("IP_USER_ID_" + tmpId);
                    String ipStart = req.getParameter("IP_START_" + tmpId);
                    String ipEnd = req.getParameter("IP_END_" + tmpId);
                    long ipStartInt = Utility.ipStringToLong(ipStart);
                    long ipEndInt = Utility.ipStringToLong(ipEnd);
                    imcref.sqlUpdateProcedure("IPAccessUpdate", new String[]{ipAccessId, ipUserId, "" + ipStartInt, "" + ipEndInt});
                }
            }
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("IP_WARN_DELETE") != null) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                Enumeration enumNames = req.getParameterNames();
                while (enumNames.hasMoreElements()) {
                    String paramName = (String)enumNames.nextElement();
                    String[] arr = req.getParameterValues(paramName);
                    session.setAttribute("IP." + paramName, (Object)arr);
                }
            } else {
                String header = "Error in AdminIpAccess, delete. ";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminIpAccess/no_session") + "<br>";
                this.log.debug((Object)(header + "- session could not be created"));
                new AdminError(req, res, header, msg);
                return;
            }
            VariableManager vm = new VariableManager();
            super.sendHtml(req, res, vm, "AdminIpAccess_Delete2.htm");
            return;
        }
        if (req.getParameter("DEL_IP_ACCESS") != null) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                this.log.debug((Object)("Ok, ta bort en Ip-access: " + session.toString()));
                String[] deleteIds = (String[])session.getAttribute("IP.EDIT_IP_ACCESS");
                if (deleteIds != null) {
                    for (int i = 0; i < deleteIds.length; ++i) {
                        String tmpId = "IP.IP_ACCESS_ID_" + deleteIds[i];
                        String[] tmpArr = (String[])session.getAttribute(tmpId);
                        String ipAccessId = tmpArr[0];
                        imcref.sqlUpdateProcedure("IPAccessDelete", new String[]{ipAccessId});
                    }
                }
            } else {
                String header = "Error in AdminIpAccess, delete.";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminIpAccess/no_session") + "<br>";
                this.log.debug((Object)(header + "- session could not be created"));
                new AdminError(req, res, header, msg);
                return;
            }
            this.doGet(req, res);
            return;
        }
    }

    private Properties getAddParameters(HttpServletRequest req) {
        Properties ipInfo = new Properties();
        String user_id = req.getParameter("USER_ID") == null ? "" : req.getParameter("USER_ID").trim();
        String ipStart = req.getParameter("IP_START") == null ? "" : req.getParameter("IP_START").trim();
        String ipEnd = req.getParameter("IP_END") == null ? "" : req.getParameter("IP_END").trim();
        long ipStartInt = Utility.ipStringToLong(ipStart);
        long ipEndInt = Utility.ipStringToLong(ipEnd);
        ipInfo.setProperty("USER_ID", user_id);
        ipInfo.setProperty("IP_START", String.valueOf(ipStartInt));
        ipInfo.setProperty("IP_END", String.valueOf(ipEndInt));
        return ipInfo;
    }

    private String[] getEditedIpAccesses(HttpServletRequest req) {
        String[] replyId = req.getParameterValues("EDIT_IP_ACCESS");
        return replyId;
    }

    private Properties validateParameters(Properties aPropObj, HttpServletRequest req, HttpServletResponse res, ImcmsServices imcref, UserDomainObject user) throws IOException {
        if (!this.assertNoEmptyStringsInPropertyValues(aPropObj)) {
            String header = "Error in AdminIpAccess, assertNoEmptyStringsInPropertyValues.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/AdminIpAccess/vaidate_form_parameters") + "<br>";
            this.log.debug((Object)(header + "- values is missing for some parameters"));
            new AdminError(req, res, header, msg);
            return null;
        }
        return aPropObj;
    }
}

