/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AdminDeleteDoc
extends Administrator {
    private static final Logger log = Logger.getLogger((String)AdminDeleteDoc.class.getName());
    private static final String HTML_TEMPLATE = "AdminDeleteDoc.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminCounter.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        VariableManager vm = new VariableManager();
        super.sendHtml(req, res, vm, HTML_TEMPLATE);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminCounter.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        if (req.getParameter("DELETE_DOC") != null) {
            Properties params = this.getParameters(req);
            if (!this.validateParameters(params)) {
                String header = "Error in AdminDeleteDoc.";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminDeleteDoc/no_valid_metaid") + "<br>";
                log.debug((Object)(header + "- no valid metaid"));
                new AdminError(req, res, header, msg);
                return;
            }
            int metaId = Integer.parseInt(params.getProperty("DEL_META_ID"));
            String foundMetaId = imcref.sqlProcedureStr("FindMetaId", new String[]{"" + metaId});
            log.debug((Object)("FoundMetaId: " + foundMetaId));
            if (foundMetaId == null) {
                String header = "Error in AdminDeleteDoc. ";
                Properties langproperties = imcref.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminDeleteDoc/no_metaid_in_db") + "( " + metaId + " ) <br>";
                log.debug((Object)(header + "- metaid could not be found in db"));
                new AdminError(req, res, header, msg);
                return;
            }
            DocumentMapper documentMapper = imcref.getDocumentMapper();
            DocumentDomainObject document = documentMapper.getDocument(metaId);
            documentMapper.deleteDocument(document);
            imcref.updateMainLog("Document  [" + document.getId() + "] ALL deleted by user: [" + user.getFullName() + "]");
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("GO_BACK") != null) {
            String url = "AdminManager";
            res.sendRedirect(url);
            return;
        }
        log.debug((Object)"Unidentified argument was sent!");
        this.doGet(req, res);
    }

    private Properties getParameters(HttpServletRequest req) {
        Properties params = new Properties();
        String del_meta_id = req.getParameter("delete_meta_id") == null ? "" : req.getParameter("delete_meta_id");
        params.setProperty("DEL_META_ID", del_meta_id);
        return params;
    }

    private boolean validateParameters(Properties params) {
        if (!super.assertNoEmptyStringsInPropertyValues(params)) {
            return false;
        }
        try {
            Integer.parseInt(params.getProperty("DEL_META_ID"));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

