/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AdminCounter
extends Administrator {
    private static final Logger log = Logger.getLogger((String)AdminCounter.class.getName());
    private static final String HTML_TEMPLATE = "AdminCounter.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminCounter.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<BR>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        if (req.getParameter("CancelCounter") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
        if (req.getParameter("setSessionCounter") != null) {
            Properties props = this.getParameters(req);
            String userVal = props.getProperty("COUNTER_VALUE");
            int theUserInt = 0;
            boolean ok = true;
            try {
                if (userVal.equals("")) {
                    ok = false;
                }
                theUserInt = Integer.parseInt(userVal);
            }
            catch (Exception e) {
                ok = false;
            }
            if (ok) {
                imcref.setSessionCounter(theUserInt);
            }
        }
        String errormsg = "";
        Date currentDate = imcref.getSessionCounterDate();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String newDateStr = dateFormat.format(currentDate);
        if (req.getParameter("setDate") != null) {
            String dateStr = req.getParameter("date_value");
            try {
                Date date = dateFormat.parse(dateStr);
                newDateStr = dateFormat.format(date);
                if (!newDateStr.equals(dateStr)) {
                    Properties langproperties = imcref.getLanguageProperties(user);
                    errormsg = langproperties.getProperty("error/servlet/AdminCounter/no_valid_date");
                    newDateStr = dateStr;
                } else {
                    imcref.setSessionCounterDate(date);
                }
            }
            catch (ParseException pe) {
                Properties langproperties = imcref.getLanguageProperties(user);
                errormsg = langproperties.getProperty("error/servlet/AdminCounter/no_valid_date");
                newDateStr = dateStr;
            }
        }
        String counterValue = "" + imcref.getSessionCounter();
        currentDate = imcref.getSessionCounterDate();
        VariableManager vm = new VariableManager();
        vm.addProperty("COUNTER_VALUE", counterValue);
        vm.addProperty("CURRENT_DATE_VALUE", dateFormat.format(currentDate));
        vm.addProperty("NEW_DATE_VALUE", newDateStr);
        vm.addProperty("ERRORMSG", errormsg);
        this.sendHtml(req, res, vm, HTML_TEMPLATE);
    }

    private Properties getParameters(HttpServletRequest req) {
        Properties reqParams = new Properties();
        String counterVal = req.getParameter("counter_value") == null ? "" : req.getParameter("counter_value");
        reqParams.setProperty("COUNTER_VALUE", counterVal);
        return reqParams;
    }
}

