/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.misc;

import imcode.server.HTMLConv;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.fortune.DateRange;
import imcode.util.fortune.Poll;
import imcode.util.fortune.Quote;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class QuestionEngine
extends HttpServlet {
    private static final String questionTemplate = "QuestionEngine.htm";
    private static final Logger log = Logger.getLogger((String)QuestionEngine.class.getName());

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Poll thePoll;
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        String inFile = req.getParameter("file");
        if (inFile == null) {
            inFile = "poll";
        }
        List pollList = imcref.getPollList(inFile + ".current.txt");
        Date now = new Date();
        if (pollList.isEmpty()) {
            pollList = this.getNewQuestion(imcref, inFile);
        }
        if (!(thePoll = (Poll)pollList.get(0)).getDateRange().contains(now)) {
            if (!"".equals(thePoll.getQuestion())) {
                List pollStatsList = imcref.getPollList(inFile + ".stat.txt");
                pollStatsList.add(thePoll);
                imcref.setPollList(inFile + ".stat.txt", pollStatsList);
            }
            pollList = this.getNewQuestion(imcref, inFile);
            thePoll = (Poll)pollList.get(0);
        }
        String question = thePoll.getQuestion();
        question = HTMLConv.toHTMLSpecial(question);
        Vector<String> values = new Vector<String>();
        values.add("#question#");
        values.add(question);
        values.add("#file#");
        values.add(inFile);
        String parsed = imcref.getTemplateFromDirectory(questionTemplate, user, values, "106");
        out.print(parsed);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doGet(req, res);
    }

    private List getNewQuestion(ImcmsServices imcref, String inFile) throws IOException {
        List questionList = imcref.getQuoteList(inFile + ".poll.txt");
        Date date = new Date();
        Iterator qIterator = questionList.iterator();
        while (qIterator.hasNext()) {
            Quote aPollQuestion = (Quote)qIterator.next();
            if (!aPollQuestion.getDateRange().contains(date)) continue;
            String questionString = aPollQuestion.getText();
            LinkedList<Poll> newPollList = new LinkedList<Poll>();
            newPollList.add(new Poll(questionString, aPollQuestion.getDateRange()));
            imcref.setPollList(inFile + ".current.txt", newPollList);
            return newPollList;
        }
        log.error((Object)"QuestionEngine: There are no current polls!");
        LinkedList<Poll> newPollList = new LinkedList<Poll>();
        DateRange dateRange = new DateRange(new Date(0L), new Date(0L));
        newPollList.add(new Poll("", dateRange));
        return newPollList;
    }
}

