/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.ConfError;
import com.imcode.imcms.servlet.conference.Conference;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfHelp
extends Conference {
    private static final String USER_TEMPLATE = "conf_help_user.htm";
    private static final String ADMIN_TEMPLATE = "conf_help_admin.htm";
    private static final String ADMIN_TEMPLATE2 = "conf_help_admin2.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = this.getParameters(req);
        this.log("tyest");
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (this.isUserAuthorized(req, res, user)) {
            ImcmsServices imcref = Imcms.getServices();
            VariableManager vm = new VariableManager();
            String file = "";
            if (params.getProperty("HELP_MODE").equalsIgnoreCase("USER")) {
                file = USER_TEMPLATE;
            } else if (params.getProperty("HELP_MODE").equalsIgnoreCase("ADMIN")) {
                int metaId = this.getMetaId(req);
                if (this.userHasAdminRights(imcref, metaId, user)) {
                    file = ADMIN_TEMPLATE;
                    if (params.getProperty("HELP_AREA").equalsIgnoreCase("TEMPLATESPEC")) {
                        file = ADMIN_TEMPLATE2;
                    }
                } else {
                    String header = "ConfHelp servlet. ";
                    new ConfError(req, res, header, 6, user);
                    return;
                }
            }
            this.sendHtml(req, res, vm, file);
            return;
        }
    }

    private Properties getParameters(HttpServletRequest req) {
        Properties params = MetaInfo.createPropertiesFromMetaInfoParameters(super.getConferenceSessionParameters(req));
        super.addExtSessionParametersToProperties(req, params);
        String helpInfo = req.getParameter("helparea") == null ? "" : req.getParameter("helparea");
        String helpMode = req.getParameter("helpmode") == null ? "" : req.getParameter("helpmode");
        params.setProperty("HELP_AREA", helpInfo);
        params.setProperty("HELP_MODE", helpMode);
        this.log(req.getParameter("helpmode"));
        return params;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String action = req.getMethod();
        if (action.equals("POST")) {
            this.doPost(req, res);
        } else {
            this.doPost(req, res);
        }
    }

    public void log(String str) {
        super.log(str);
        System.out.println("ConfHelp: " + str);
    }
}

