/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.Conference;
import imcode.external.diverse.SettingsAccessor;
import imcode.external.diverse.VariableManager;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfError
extends Conference {
    private static final String ERROR_FILE = "conf_error.htm";
    private String myErrorHeader;
    private String myErrorMessage;

    public ConfError() {
        this.myErrorHeader = "";
        this.myErrorMessage = "";
    }

    public ConfError(HttpServletRequest req, HttpServletResponse res, String header, int errorCode, UserDomainObject user) throws IOException {
        this.myErrorHeader = header;
        VariableManager vm = new VariableManager();
        String myErrorMessage = this.getErrorMessage(req, errorCode);
        vm.addProperty("ERROR_HEADER", header);
        vm.addProperty("ERROR_MESSAGE", myErrorMessage);
        this.sendErrorHtml(req, res, vm, ERROR_FILE, user);
    }

    public String getErrorString() {
        return this.myErrorHeader + " " + this.myErrorMessage;
    }

    public String getErrorMsg() {
        return this.myErrorMessage;
    }

    public String getErrorMessage(HttpServletRequest req, int errCode) {
        try {
            SettingsAccessor setObj = new SettingsAccessor("errmsg.ini", Utility.getLoggedOnUser(req), "102");
            setObj.setDelimiter("=");
            setObj.loadSettings();
            this.myErrorMessage = setObj.getSetting("" + errCode);
            if (this.myErrorMessage == null) {
                this.myErrorMessage = "Missing Errorcode " + errCode;
            }
        }
        catch (Exception e) {
            this.log("An error occured while reading the errmsg.ini file");
        }
        return this.myErrorMessage;
    }

    public ConfError(HttpServletRequest req, HttpServletResponse res, String header, int errorCode, String fileName, UserDomainObject user) throws IOException {
        this.myErrorHeader = header;
        VariableManager vm = new VariableManager();
        this.myErrorMessage = this.getErrorMessage(req, errorCode);
        vm.addProperty("ERROR_CODE", "" + errorCode);
        vm.addProperty("ERROR_HEADER", header);
        vm.addProperty("ERROR_MESSAGE", this.myErrorMessage);
        this.sendErrorHtml(req, res, vm, fileName, user);
    }

    private void sendErrorHtml(HttpServletRequest req, HttpServletResponse res, VariableManager vm, String htmlFile, UserDomainObject user) throws IOException {
        String imagePath = this.getExternalImageFolder(req);
        vm.addProperty("IMAGE_URL", imagePath);
        vm.addProperty("SERVLET_URL", "");
        String html = this.getTemplate(htmlFile, user, vm.getTagsAndData());
        PrintWriter out = res.getWriter();
        Utility.setDefaultHtmlContentType(res);
        out.print(html);
    }
}

