/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.ConfError;
import com.imcode.imcms.servlet.conference.Conference;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ConfAdd
extends Conference {
    private static final String HTML_TEMPLATE = "conf_add.htm";
    private static final String SERVLET_NAME = "ConfAdd";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int metaId;
        Properties params = this.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String addType = req.getParameter("ADDTYPE");
        ImcmsServices imcref = Imcms.getServices();
        if (this.userHasRightToEdit(imcref, metaId = Integer.parseInt(params.getProperty("META_ID")), user)) {
            if (req.getParameter("CANCEL") != null || req.getParameter("CANCEL.x") != null) {
                res.sendRedirect("ConfDiscView");
                return;
            }
            if (addType.equalsIgnoreCase("DISCUSSION") && (req.getParameter("ADD") != null || req.getParameter("ADD.x") != null)) {
                String level;
                String aForumId = params.getProperty("FORUM_ID");
                String userId = "";
                HttpSession session = req.getSession(false);
                if (session != null) {
                    userId = (String)session.getAttribute("Conference.user_id");
                }
                if ((level = imcref.sqlProcedureStr("A_ConfUsersGetUserLevel", new String[]{params.getProperty("META_ID"), userId})).equalsIgnoreCase("-1")) {
                    this.log("An error occured in reading the users level");
                    level = "0";
                }
                String addHeader = super.verifySqlText(params.getProperty("ADD_HEADER"));
                String addText = super.verifySqlText(params.getProperty("ADD_TEXT"));
                imcref.sqlUpdateProcedure("A_AddNewDisc", new String[]{aForumId, userId, addHeader, addText, level});
                if (session != null) {
                    String latestDiscId = imcref.sqlProcedureStr("A_GetLastDiscussionId", new String[]{params.getProperty("META_ID"), aForumId});
                    session.setAttribute("Conference.disc_id", (Object)latestDiscId);
                }
                res.sendRedirect("ConfDiscView");
                return;
            }
            if (addType.equalsIgnoreCase("REPLY") && (req.getParameter("ADD") != null || req.getParameter("ADD.x") != null)) {
                String level;
                String discId = params.getProperty("DISC_ID");
                String userId = "";
                HttpSession session = req.getSession(false);
                if (session != null) {
                    userId = (String)session.getAttribute("Conference.user_id");
                }
                if ((level = imcref.sqlProcedureStr("A_ConfUsersGetUserLevel", new String[]{params.getProperty("META_ID"), userId})).equalsIgnoreCase("-1")) {
                    this.log("An error occured in reading the users level");
                    level = "0";
                }
                String addHeader = super.verifySqlText(params.getProperty("ADD_HEADER"));
                String addText = super.verifySqlText(params.getProperty("ADD_TEXT"));
                if (addText.length() > 32000) {
                    String header = "ConfAdd servlet. ";
                    new ConfError(req, res, header, 74, user);
                    return;
                }
                imcref.sqlUpdateProcedure("A_AddReply", new String[]{userId, discId, addHeader, addText, level});
                res.sendRedirect("ConfDiscView");
                return;
            }
        } else {
            String header = "ConfAdd servlet. ";
            new ConfError(req, res, header, 100, user);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        int metaId;
        Properties params = this.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        if (this.userHasRightToEdit(imcref, metaId = Integer.parseInt(params.getProperty("META_ID")), user)) {
            String aDiscId;
            String[] arr;
            String addTypeHeader;
            ConfError err;
            String loginUserId = "";
            HttpSession session = req.getSession(false);
            if (session != null) {
                loginUserId = (String)session.getAttribute("Conference.user_id");
            }
            VariableManager vm = new VariableManager();
            String firstName = imcref.sqlProcedureStr("A_GetConfLoginNames", new String[]{params.getProperty("META_ID"), loginUserId, "1"});
            String lastName = imcref.sqlProcedureStr("A_GetConfLoginNames", new String[]{params.getProperty("META_ID"), loginUserId, "2"});
            vm.addProperty("FIRST_NAME", firstName);
            vm.addProperty("LAST_NAME", lastName);
            vm.addProperty("ADD_TYPE", params.getProperty("ADD_TYPE"));
            String currForum = imcref.sqlProcedureStr("A_GetForumName", new String[]{params.getProperty("FORUM_ID")});
            vm.addProperty("CURRENT_FORUM_NAME", currForum);
            if (params.getProperty("ADD_TYPE").equalsIgnoreCase("REPLY")) {
                err = new ConfError();
                addTypeHeader = err.getErrorMessage(req, 72);
            } else {
                err = new ConfError();
                addTypeHeader = err.getErrorMessage(req, 73);
            }
            vm.addProperty("ADD_TYPE_HEADER", addTypeHeader);
            String discHeader = "";
            if (params.getProperty("ADD_TYPE").equalsIgnoreCase("REPLY") && (arr = imcref.sqlProcedure("A_GetDiscussionHeader", new String[]{aDiscId = params.getProperty("DISC_ID")})) != null && arr.length > 0) {
                discHeader = arr[0];
            }
            vm.addProperty("DISC_HEADER", discHeader);
            this.sendHtml(req, res, vm, HTML_TEMPLATE);
            return;
        }
        String header = "ConfAdd servlet. ";
        new ConfError(req, res, header, 100, user);
    }

    private Properties getParameters(HttpServletRequest req) {
        ConfError err;
        String addText;
        MetaInfo.Parameters metaParams = super.getConferenceSessionParameters(req);
        Properties params = MetaInfo.createPropertiesFromMetaInfoParameters(metaParams);
        super.addExtSessionParametersToProperties(req, params);
        String addType = req.getParameter("ADDTYPE") == null ? "" : req.getParameter("ADDTYPE");
        String addHeader = req.getParameter("ADDHEADER") == null ? "" : req.getParameter("ADDHEADER");
        String string = addText = req.getParameter("ADDTEXT") == null ? "" : req.getParameter("ADDTEXT");
        if (addHeader.equals("")) {
            err = new ConfError();
            addHeader = err.getErrorMessage(req, 70);
        }
        if (addText.equals("")) {
            err = new ConfError();
            addText = err.getErrorMessage(req, 71);
        }
        params.setProperty("ADD_HEADER", addHeader);
        params.setProperty("ADD_TEXT", addText);
        params.setProperty("ADD_TYPE", addType);
        return params;
    }
}

