/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.chat;

import imcode.external.chat.ChatBase;
import imcode.external.chat.ChatError;
import imcode.external.chat.ChatMember;
import imcode.external.chat.ChatSystemMessage;
import imcode.external.diverse.MetaInfo;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ChatManager
extends ChatBase {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MetaInfo.Parameters params = MetaInfo.getParameters(req);
        UserDomainObject user = super.getUserObj(req);
        if (user == null) {
            return;
        }
        int testMetaId = params.getMetaId();
        if (!this.isUserAuthorized(res, testMetaId, user, req)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            String header = "ChatManager servlet. ";
            ChatError err = new ChatError(req, res, header, 3);
            this.log(header + err.getErrorMsg());
            return;
        }
        if (action.equalsIgnoreCase("NEW")) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                this.setSessionAttributes(session, params);
            }
            req.setAttribute("action", (Object)"NEW");
            RequestDispatcher myDispatcher = req.getRequestDispatcher("/servlet/ChatCreator");
            myDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (action.equalsIgnoreCase("VIEW")) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                ChatMember theChatMember = (ChatMember)session.getAttribute("theChatMember");
                if (theChatMember != null) {
                    ChatSystemMessage systemMessage = new ChatSystemMessage(theChatMember, 4);
                    ImcmsServices imcref = Imcms.getServices();
                    this.logOutMember(theChatMember, systemMessage, imcref);
                }
                this.setSessionAttributes(session, params);
            }
            req.setAttribute("login_type", (Object)"login");
            RequestDispatcher myDispatcher = req.getRequestDispatcher("/servlet/ChatLogin");
            myDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (action.equalsIgnoreCase("CHANGE")) {
            req.setAttribute("metadata", (Object)"meta");
            RequestDispatcher myDispatcher = req.getRequestDispatcher("ChangeExternalDoc2");
            myDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
    }

    private void setSessionAttributes(HttpSession session, MetaInfo.Parameters params) {
        session.setAttribute("Chat.meta_id", (Object)("" + params.getMetaId()));
    }
}

