/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.chat;

import com.imcode.imcms.servlet.BackDoc;
import imcode.external.chat.Chat;
import imcode.external.chat.ChatBase;
import imcode.external.chat.ChatError;
import imcode.external.chat.ChatGroup;
import imcode.external.chat.ChatMember;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ChatLogin
extends ChatBase {
    private String LOGIN_HTML = "clogin4.htm";
    private String LOGIN_ERROR_HTML = "chat_error.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Chat myChat;
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession(true);
        ServletContext myContext = this.getServletContext();
        UserDomainObject user = super.getUserObj(req);
        if (user == null) {
            return;
        }
        String metaId = req.getParameter("meta_id");
        int meta_id = Integer.parseInt(metaId);
        if (!this.isUserAuthorized(res, meta_id, user, req)) {
            this.log("user not Authorized");
            return;
        }
        Stack history = (Stack)user.get("history");
        int parentMetaId = BackDoc.getLastTextDocumentFromHistory(history, false, imcref);
        if (parentMetaId == 0) {
            try {
                parentMetaId = Integer.parseInt(req.getParameter("chat_return_meta_id"));
            }
            catch (NumberFormatException nfe) {
                parentMetaId = imcref.getSystemData().getStartDocument();
            }
        }
        if ((myChat = (Chat)myContext.getAttribute("theChat" + metaId)) == null) {
            this.log("OBS m\u00e5ste skapa en ny Chat");
            myChat = this.createChat(meta_id);
            myContext.setAttribute("theChat" + metaId, (Object)myChat);
            session.setAttribute("myChat", (Object)myChat);
        }
        if (session.getAttribute("theChatMember") != null) {
            res.sendRedirect("ChatViewer");
            return;
        }
        Vector rolV = myChat.getSelectedAuto();
        boolean loggedOnOk = false;
        boolean aliasBol = rolV.contains("1");
        boolean imCmsRegBol = rolV.contains("2");
        if (!user.getLoginName().equals("user")) {
            loggedOnOk = true;
        }
        this.LOGIN_HTML = aliasBol && !imCmsRegBol ? "clogin1.htm" : (!aliasBol && imCmsRegBol ? (loggedOnOk ? "clogin2.htm" : "clogin3.htm") : (loggedOnOk ? "clogin5.htm" : "clogin4.htm"));
        Map docInfo = imcref.sqlProcedureHash("getDocumentInfo", new String[]{"" + meta_id});
        String[] chatName = (String[])docInfo.get("meta_headline");
        String error_msg = "";
        if (req.getParameter("alias") != null) {
            Vector<String> tags = new Vector<String>();
            tags.add("#ALIAS#");
            tags.add(req.getParameter("alias"));
            String libName = ChatLogin.getTemplateSetDirectoryName(myChat.getChatId());
            error_msg = imcref.getTemplateFromSubDirectoryOfDirectory("alias_error_msg.html", user, tags, "103", libName);
        }
        String userName = user.getLoginName();
        Vector<String> tags = new Vector<String>();
        tags.add("#userName#");
        tags.add(userName);
        tags.add("#chatName#");
        tags.add(chatName[0]);
        tags.add("#parent_meta_id#");
        tags.add("" + parentMetaId);
        tags.add("#IMAGE_URL#");
        tags.add(this.getExternalImageFolder(req));
        tags.add("#ALIAS#");
        tags.add(req.getParameter("alias") == null ? "" : req.getParameter("alias"));
        tags.add("#ALIAS_ERROR#");
        tags.add(error_msg);
        this.sendHtml(req, res, tags, this.LOGIN_HTML, null);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ServletContext myContext;
        Chat theChat;
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession(true);
        Properties params = super.getSessionParameters(req);
        UserDomainObject user = super.getUserObj(req);
        if (user == null) {
            return;
        }
        String metaId = params.getProperty("META_ID");
        int meta_id = Integer.parseInt(metaId);
        if (!this.isUserAuthorized(res, meta_id, user, req)) {
            return;
        }
        String loginType = req.getParameter("login_type") == null ? "" : req.getParameter("login_type");
        this.log("Logintype \u00e4r nu: " + loginType);
        String chatAlias = null;
        if (req.getParameter("loginToImCms") != null) {
            this.log("Ok, nu f\u00f6rs\u00f6ker vi verifiera logga in!");
            Properties lparams = this.getLoginParams(req);
            String userName = lparams.getProperty("LOGIN_NAME");
            String password = lparams.getProperty("PASSWORD");
            String userId = imcref.sqlProcedureStr("GetUserIdFromName", new String[]{userName, password});
            if (userId == null) {
                String header = "ChatLogin servlet.";
                ChatError err = new ChatError(req, res, header, 50, this.LOGIN_ERROR_HTML);
                this.log(header + err.getErrorMsg());
                return;
            }
            UserDomainObject oldUser = user;
            user = this.allowUser(userName, password, imcref);
            user.put("history", oldUser.get("history"));
            Utility.makeUserLoggedIn(req, user);
            chatAlias = user.getLoginName();
        }
        if ((theChat = (Chat)(myContext = this.getServletContext()).getAttribute("theChat" + metaId)) == null) {
            theChat = this.createChat(meta_id);
            myContext.setAttribute("theChat" + metaId, (Object)theChat);
            session.setAttribute("myChat", (Object)theChat);
        }
        if (req.getParameter("loginAlias") != null && "".equals(chatAlias = req.getParameter("alias").trim())) {
            res.sendRedirect("ChatLogin?meta_id=" + metaId);
            return;
        }
        if (req.getParameter("loginUserName") != null) {
            chatAlias = user.getLoginName();
        }
        if (theChat.hasMemberName(chatAlias)) {
            String urlEncodedChatAlias = URLEncoder.encode(chatAlias);
            res.sendRedirect("ChatLogin?alias=" + urlEncodedChatAlias + "&meta_id=" + meta_id);
            return;
        }
        int parentMetaId = Integer.parseInt(req.getParameter("parent_meta_id"));
        ChatMember myMember = theChat.createChatMember(user, parentMetaId);
        myMember.setName(chatAlias);
        myMember.setIpNr(req.getRemoteHost());
        ChatGroup myGroup = theChat.getChatGroup();
        myGroup.addNewGroupMember(myMember);
        this.createEnterMessageAndAddToGroup(theChat, imcref, user, myMember, myGroup, metaId);
        myMember.addMessageHistory();
        session.setAttribute("theChatMember", (Object)myMember);
        super.prepareChatBoardSettings(myMember, req, false);
        String url = "ChatViewer";
        res.sendRedirect(url);
    }

    private Properties getLoginParams(HttpServletRequest req) {
        Properties login = new Properties();
        String login_name = req.getParameter("login_name") == null ? "" : req.getParameter("login_name");
        String password1 = req.getParameter("password") == null ? "" : req.getParameter("password");
        login.setProperty("LOGIN_NAME", login_name.trim());
        login.setProperty("PASSWORD", password1.trim());
        return login;
    }

    private UserDomainObject allowUser(String user_name, String passwd, ImcmsServices imcref) {
        return imcref.verifyUser(user_name, passwd);
    }
}

