/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.chat;

import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Parser;
import imcode.util.Utility;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChatAdmin
extends Administrator {
    private static final String TEMPLATE_CONF = "AdminChat.html";
    private static final String TEMPLATE_LIST_TOOL = "AdminChat_list_tool.html";
    private static final String TEMPLATE_LIST = "AdminChat_list.html";
    private static final String TEMPLATE_CONF_ELEMENT = "AdminChat_list_Chat_element.html";
    private static final String TEMPLATE_FORUM_ELEMENT = "AdminChat_list_forum_element.html";
    private static final String ERROR_HEADER = "AdminChat";
    private static final String DATE_FORMATE = "yyyy-MM-dd";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        String eMailServerMaster = imcref.getSystemData().getServerMasterAddress();
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!user.isSuperAdmin()) {
            this.sendErrorMessage(imcref, eMailServerMaster, user, ERROR_HEADER, 2, response);
            return;
        }
        VariableManager vm = new VariableManager();
        if (request.getParameter("VIEW_CHAT_LIST_TOOL") != null) {
            this.sendHtml(request, response, vm, TEMPLATE_LIST_TOOL);
        } else if (request.getParameter("VEIW_CHAT_LIST") != null) {
            this.listChats(request, response, user);
        } else if (request.getParameter("CANCEL") != null) {
            response.sendRedirect("AdminManager");
        } else if (request.getParameter("CANCEL_CHAT_LIST") != null) {
            response.sendRedirect("ChatAdmin");
        } else {
            this.sendHtml(request, response, vm, TEMPLATE_CONF);
        }
    }

    private boolean isDateInRightFormat(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMATE);
        try {
            formatter.parse(date);
        }
        catch (ParseException e) {
            return false;
        }
        return true;
    }

    private void listChats(HttpServletRequest request, HttpServletResponse response, UserDomainObject user) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        String eMailServerMaster = imcref.getSystemData().getServerMasterAddress();
        boolean noErrors = true;
        String listMode = request.getParameter("LISTMOD");
        String startDate = request.getParameter("START_DATE");
        String endDate = request.getParameter("END_DATE");
        try {
            if (listMode != null) {
                int mode = Integer.parseInt(listMode);
                if (mode != 1 && mode != 2) {
                    noErrors = false;
                }
            } else {
                noErrors = false;
            }
        }
        catch (NumberFormatException e) {
            noErrors = false;
        }
        if (startDate != null) {
            if (startDate.length() > 0) {
                if (!this.isDateInRightFormat(startDate)) {
                    noErrors = false;
                }
            } else {
                startDate = "0";
            }
        } else {
            noErrors = false;
        }
        if (endDate != null) {
            if (endDate.length() > 0) {
                if (!this.isDateInRightFormat(endDate)) {
                    noErrors = false;
                }
            } else {
                endDate = "0";
            }
        } else {
            noErrors = false;
        }
        if (noErrors) {
            String htmlChatElement = imcref.getAdminTemplate(TEMPLATE_CONF_ELEMENT, user, null);
            String htmlForumElement = imcref.getAdminTemplate(TEMPLATE_FORUM_ELEMENT, user, null);
            String[][] listOfChats = imcref.sqlProcedureMulti("ListChats", new String[0]);
            StringBuffer chatListTag = new StringBuffer();
            Hashtable<String, String> chatTags = new Hashtable<String, String>();
            Hashtable<String, String> forumTags = new Hashtable<String, String>();
            Hashtable<String, String> debateTags = new Hashtable<String, String>();
            for (int i = 0; i < listOfChats.length; ++i) {
                String metaId = listOfChats[i][0];
                String[][] queryResultForum = imcref.sqlProcedureMulti("C_AdminStatistics1", new String[]{metaId, startDate, endDate, listMode});
                StringBuffer forumList = new StringBuffer();
                for (int j = 0; j < queryResultForum.length; ++j) {
                    String forumId = queryResultForum[j][0];
                    String[][] queryResultDebate = imcref.sqlProcedureMulti("C_AdminStatistics2", new String[]{metaId, forumId, startDate, endDate, listMode});
                    StringBuffer debateList = new StringBuffer();
                    for (int k = 0; k < queryResultDebate.length; ++k) {
                        debateTags.put("DEBATE", queryResultDebate[k][1]);
                        debateTags.put("DATE", queryResultDebate[k][2]);
                    }
                    forumTags.put("FORUM", queryResultForum[j][1]);
                    forumTags.put("DEBATE_LIST", debateList.toString());
                    forumList.append(Parser.parseTags(new StringBuffer(htmlForumElement), '#', " <>\n\r\t", forumTags, true, 1).toString());
                }
                if (queryResultForum.length <= 0) continue;
                chatTags.put("SERVLET_URL", "");
                chatTags.put("META_ID", metaId);
                chatTags.put("CONFERENCE", listOfChats[i][1]);
                chatTags.put("FORUM_LIST", forumList.toString());
                chatListTag.append(Parser.parseTags(new StringBuffer(htmlChatElement), '#', " <>\n\r\t", chatTags, true, 1).toString());
            }
            VariableManager vm = new VariableManager();
            vm.addProperty("CHAT_LIST", chatListTag.toString());
            this.sendHtml(request, response, vm, TEMPLATE_LIST);
        } else {
            this.sendErrorMessage(imcref, eMailServerMaster, user, ERROR_HEADER, 10, response);
        }
    }
}

