/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import com.imcode.imcms.servlet.billboard.BillBoard;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BillBoardReply
extends BillBoard {
    private static final String NEW_COMMENT_TEMPLATE = "billboard_reply_new_comment.htm";
    private static final String ADMIN_LINK_TEMPLATE = "billboard_reply_admin_link.htm";
    private static final String HTML_TEMPLATE_MAIL_SENT = "billboard_reply_mail_sent.htm";
    private static final String HTML_TEMPLATE = "billboard_reply.htm";
    private static final String RECS_HTML = "billboard_reply_list.htm";
    private static final String RECS_PREV_HTML = "billboard_reply_list_prev.htm";
    private static final String HTML_TEMPLATE_START = "billboard_reply_welcome.htm";
    private static final String header = "header";
    private static final String text = "text";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        if (req.getParameter("UPDATE") != null) {
            this.doGet(req, res);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        Properties params = this.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        File templateLib = super.getExternalTemplateFolder(req);
        File aSnippetFile = new File(templateLib, RECS_PREV_HTML);
        Hashtable billPrevData = (Hashtable)session.getAttribute("billPrevData");
        if (billPrevData != null && req.getParameter("PREVIEWMODE") != null) {
            String addHeader = (String)billPrevData.get(header);
            String addText = (String)billPrevData.get(text);
            String datum = imcref.sqlProcedureStr("B_GetTime", new String[0]);
            String addType = req.getParameter("ADDTYPE");
            String addType2 = req.getParameter("ADDTYPE");
            String[][] tempArr = new String[][]{{"", addHeader, addText, "", datum, addType, addType2}};
            Vector tags = this.buildTagsV();
            tags.add("#ADD_TYPE#");
            tags.add("#ADD_TYPE2#");
            String currRec1 = this.preParse(tempArr, tags, aSnippetFile);
            VariableManager vm1 = new VariableManager();
            vm1.addProperty("REPLIE_RECORD", currRec1);
            vm1.addProperty("CURRENT_BILL_HEADER", billPrevData.get(header));
            vm1.addProperty("ADMIN_LINK_HTML", "");
            this.sendHtml(req, res, vm1, HTML_TEMPLATE);
            return;
        }
        String discId = params.getProperty("DISC_ID");
        if (session != null) {
            session.setAttribute("BillBoard.disc_id", (Object)discId);
        }
        if (discId.equals("-1")) {
            VariableManager vm = new VariableManager();
            this.sendHtml(req, res, vm, HTML_TEMPLATE_START);
            return;
        }
        if (req.getParameter("MAIL_SENT") != null) {
            VariableManager vm = new VariableManager();
            this.sendHtml(req, res, vm, HTML_TEMPLATE_MAIL_SENT);
            return;
        }
        String[][] sqlAnswer = imcref.sqlProcedureMulti("B_GetCurrentBill", new String[]{discId});
        String discHeader = imcref.sqlProcedureStr("B_GetBillHeader", new String[]{discId});
        if (discHeader == null || discId.equalsIgnoreCase("-1")) {
            discHeader = " ";
        }
        String metaId = params.getProperty("META_ID");
        int intMetaId = Integer.parseInt(metaId);
        aSnippetFile = new File(templateLib, RECS_HTML);
        String currentRec = " ";
        if (sqlAnswer != null) {
            currentRec = this.preParse(sqlAnswer, this.buildTagsV(), aSnippetFile);
        }
        String commentButton = "&nbsp;";
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(intMetaId);
        if (user.canAccess(document) && imcref.checkDocAdminRights(intMetaId, user)) {
            VariableManager vmButtons = new VariableManager();
            vmButtons.addProperty("#SERVLET_URL#", "");
            vmButtons.addProperty("#IMAGE_URL#", this.getExternalImageFolder(req));
            commentButton = this.getTemplate(NEW_COMMENT_TEMPLATE, user, vmButtons.getTagsAndData());
        }
        VariableManager vm = new VariableManager();
        vm.addProperty("NEW_REPLIE", commentButton);
        vm.addProperty("REPLIE_RECORD", currentRec);
        vm.addProperty("CURRENT_BILL_HEADER", discHeader);
        vm.addProperty("ADMIN_LINK_HTML", ADMIN_LINK_TEMPLATE);
        this.sendHtml(req, res, vm, HTML_TEMPLATE);
    }

    private Vector buildTagsV() {
        Vector<String> tagsV = new Vector<String>();
        tagsV.add("#REPLY_BILL_ID#");
        tagsV.add("#REPLY_HEADER#");
        tagsV.add("#REPLY_TEXT#");
        tagsV.add("#C_REPLIES#");
        tagsV.add("#REPLY_DATE#");
        return tagsV;
    }

    private String preParse(String[][] DBArr, Vector tagsV, File htmlCodeFile) throws IOException {
        StringBuffer htmlStr = new StringBuffer("");
        for (int i = 0; i < DBArr.length; ++i) {
            Vector<String> dataV = new Vector<String>();
            for (int j = 0; j < DBArr[i].length; ++j) {
                dataV.add(DBArr[i][j]);
            }
            htmlStr.append(this.parseOneRecord(tagsV, dataV, htmlCodeFile));
        }
        return htmlStr.toString();
    }

    private Properties getParameters(HttpServletRequest req) {
        HttpSession session;
        String confDiscId;
        Properties reqParams = MetaInfo.createPropertiesFromMetaInfoParameters(super.getBillBoardSessionParameters(req));
        String string = confDiscId = req.getParameter("disc_id") == null ? "" : req.getParameter("disc_id");
        if (confDiscId.equals("") && (session = req.getSession(false)) != null) {
            confDiscId = (String)session.getAttribute("BillBoard.disc_id");
        }
        reqParams.setProperty("DISC_ID", confDiscId);
        return reqParams;
    }

    public void log(String msg) {
        super.log("BillBoardReply: " + msg);
    }
}

