/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.servlet.admin.AdminDoc;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaveInclude
extends HttpServlet {
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS ");

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String tempstring;
        ImcmsServices imcref = Imcms.getServices();
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        String meta_id_str = req.getParameter("meta_id");
        int meta_id = Integer.parseInt(meta_id_str);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!imcref.checkDocAdminRights(meta_id, user, 0x100000)) {
            this.sendPermissionDenied(imcref, out, meta_id, user);
            return;
        }
        String included_meta_id = req.getParameter("include_meta_id");
        String include_id = req.getParameter("include_id");
        if (included_meta_id != null && include_id != null) {
            included_meta_id = included_meta_id.trim();
            include_id = include_id.trim();
            if ("".equals(included_meta_id)) {
                DocumentMapper documentMapper = imcref.getDocumentMapper();
                TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(meta_id);
                document.removeInclude(Integer.parseInt(include_id));
                documentMapper.saveDocument(document, user);
                imcref.updateMainLog(dateFormat.format(new Date()) + "Include nr [" + include_id + "] on [" + meta_id_str + "] removed by user: [" + user.getFullName() + "]");
            } else {
                try {
                    int included_meta_id_int = Integer.parseInt(included_meta_id);
                    String[] docTypeStrArr = imcref.sqlProcedure("GetDocType", new String[]{included_meta_id});
                    int docType = Integer.parseInt(docTypeStrArr[0]);
                    if (null == docTypeStrArr || 0 == docTypeStrArr.length || 2 != docType) {
                        this.sendBadId(imcref, out, meta_id, user);
                        return;
                    }
                    DocumentMapper documentMapper = imcref.getDocumentMapper();
                    DocumentDomainObject includedDocument = documentMapper.getDocument(included_meta_id_int);
                    if (!user.canAddDocumentToAnyMenu(includedDocument)) {
                        this.sendPermissionDenied(imcref, out, meta_id, user);
                        return;
                    }
                    TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(meta_id);
                    document.setInclude(Integer.parseInt(include_id), includedDocument.getId());
                    documentMapper.saveDocument(document, user);
                    documentMapper.setInclude(meta_id, Integer.parseInt(include_id), included_meta_id_int);
                    imcref.updateMainLog(dateFormat.format(new Date()) + "Include nr [" + include_id + "] on [" + meta_id_str + "] changed to [" + included_meta_id + "]  by user: [" + user.getFullName() + "]");
                }
                catch (NumberFormatException ignored) {
                    this.sendBadId(imcref, out, meta_id, user);
                    return;
                }
            }
        }
        if ((tempstring = AdminDoc.adminDoc(meta_id, user, req, res)) != null) {
            ((Writer)out).write(tempstring);
        }
    }

    private void sendPermissionDenied(ImcmsServices imcref, Writer out, int meta_id, UserDomainObject user) throws IOException {
        ArrayList<String> vec = new ArrayList<String>(2);
        vec.add("#meta_id#");
        vec.add(String.valueOf(meta_id));
        String htmlStr = imcref.getAdminTemplate("include_permission_denied.html", user, vec);
        out.write(htmlStr);
    }

    private void sendBadId(ImcmsServices imcref, Writer out, int meta_id, UserDomainObject user) throws IOException {
        ArrayList<String> vec = new ArrayList<String>(2);
        vec.add("#meta_id#");
        vec.add(String.valueOf(meta_id));
        String htmlStr = imcref.getAdminTemplate("include_bad_id.html", user, vec);
        out.write(htmlStr);
    }
}

