/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.server.Imcms;
import imcode.server.WebAppGlobalConstants;
import imcode.util.Prefs;
import java.io.File;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;
import org.apache.log4j.xml.DOMConfigurator;

public class MainInitServlet
extends HttpServlet {
    public void init(ServletConfig config) throws ServletException {
        NDC.push((String)"init");
        try {
            super.init(config);
            File realPathToWebApp = new File(this.getServletContext().getRealPath("/"));
            WebAppGlobalConstants.init(realPathToWebApp);
            File configPath = new File(realPathToWebApp, "WEB-INF/conf");
            Prefs.setConfigPath(configPath);
            this.configureLogging(realPathToWebApp, configPath);
            this.kickstartImcms();
        }
        catch (Exception e) {
            this.log(e.getMessage(), e);
        }
        NDC.pop();
    }

    private void kickstartImcms() {
        Imcms.getServices();
    }

    private void configureLogging(File root, File configPath) {
        System.setProperty("com.imcode.imcms.path", root.toString());
        File configFile = new File(configPath, "log4j.xml");
        DOMConfigurator.configureAndWatch((String)configFile.toString());
        Logger log = Logger.getLogger((Class)MainInitServlet.class);
        log.info((Object)"Logging started");
        this.logPlatformInfo(this.getServletContext(), log);
    }

    private void logPlatformInfo(ServletContext application, Logger log) {
        String javaVersion = "java.version";
        String javaVendor = "java.vendor";
        String javaClassPath = "java.class.path";
        String osName = "os.name";
        String osArch = "os.arch";
        String osVersion = "os.version";
        log.info((Object)("Servlet Engine: " + application.getServerInfo()));
        log.info((Object)("java.version: " + System.getProperty("java.version")));
        log.info((Object)("java.vendor: " + System.getProperty("java.vendor")));
        log.info((Object)("java.class.path: " + System.getProperty("java.class.path")));
        log.info((Object)("os.name: " + System.getProperty("os.name")));
        log.info((Object)("os.arch: " + System.getProperty("os.arch")));
        log.info((Object)("os.version: " + System.getProperty("os.version")));
    }
}

