/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.flow;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.OkCancelPage;
import imcode.server.Imcms;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DocumentPermissionSetPage
extends OkCancelPage {
    private static final String URL_I15D_PAGE__DOCUMENT_PERMISSION_SET = "/jsp/docadmin/document_permission_set.jsp";
    private DocumentPermissionSetDomainObject documentPermissionSet;
    private boolean forNew;
    public static final String REQUEST_PARAMETER__EDIT_PERMISSIONS = "editPermissions";
    public static final String REQUEST_PARAMETER__EDIT = "edit";
    public static final String REQUEST_PARAMETER__EDIT_DOCUMENT_INFORMATION = "editDocumentInformation";
    public static final String REQUEST_PARAMETER__EDIT_TEXTS = "editTexts";
    public static final String REQUEST_PARAMETER__EDIT_IMAGES = "editImages";
    public static final String REQUEST_PARAMETER__EDIT_INCLUDES = "editIncludes";
    public static final String REQUEST_PARAMETER__EDIT_MENUS = "editMenus";
    public static final String REQUEST_PARAMETER__ALLOWED_DOCUMENT_TYPE_IDS = "allowedDocumentTypeIds";
    public static final String REQUEST_PARAMETER__ALLOWED_TEMPLATE_GROUP_IDS = "allowedTemplateGroupIds";
    public static final String REQUEST_PARAMETER__EDIT_TEMPLATES = "editTemplates";
    public static final String REQUEST_PARAMETER__DEFAULT_TEMPLATE_ID = "defaultTemplateId";

    public DocumentPermissionSetPage(DocumentPermissionSetDomainObject documentPermissionSet, boolean forNew, DispatchCommand okDispatchCommand, DispatchCommand cancelDispatchCommand) {
        super(okDispatchCommand, cancelDispatchCommand);
        this.documentPermissionSet = documentPermissionSet;
        this.forNew = forNew;
    }

    public DocumentPermissionSetDomainObject getDocumentPermissionSet() {
        return this.documentPermissionSet;
    }

    protected void updateFromRequest(HttpServletRequest request) {
        this.documentPermissionSet.setEditPermissions(null != request.getParameter(REQUEST_PARAMETER__EDIT_PERMISSIONS));
        this.documentPermissionSet.setEditDocumentInformation(null != request.getParameter(REQUEST_PARAMETER__EDIT_DOCUMENT_INFORMATION));
        if (this.documentPermissionSet instanceof TextDocumentPermissionSetDomainObject) {
            TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)this.documentPermissionSet;
            textDocumentPermissionSet.setEditTexts(Utility.parameterIsSet(request, REQUEST_PARAMETER__EDIT_TEXTS));
            textDocumentPermissionSet.setEditImages(Utility.parameterIsSet(request, REQUEST_PARAMETER__EDIT_IMAGES));
            textDocumentPermissionSet.setEditIncludes(Utility.parameterIsSet(request, REQUEST_PARAMETER__EDIT_INCLUDES));
            textDocumentPermissionSet.setEditMenus(Utility.parameterIsSet(request, REQUEST_PARAMETER__EDIT_MENUS));
            textDocumentPermissionSet.setEditTemplates(Utility.parameterIsSet(request, REQUEST_PARAMETER__EDIT_TEMPLATES));
            textDocumentPermissionSet.setAllowedDocumentTypeIds(Utility.getParameterInts(request, REQUEST_PARAMETER__ALLOWED_DOCUMENT_TYPE_IDS));
            int[] allowedTemplateGroupIds = Utility.getParameterInts(request, REQUEST_PARAMETER__ALLOWED_TEMPLATE_GROUP_IDS);
            TemplateGroupDomainObject[] allowedTemplateGroups = new TemplateGroupDomainObject[allowedTemplateGroupIds.length];
            TemplateMapper templateMapper = Imcms.getServices().getTemplateMapper();
            for (int i = 0; i < allowedTemplateGroupIds.length; ++i) {
                allowedTemplateGroups[i] = templateMapper.getTemplateGroupById(allowedTemplateGroupIds[i]);
            }
            textDocumentPermissionSet.setAllowedTemplateGroups(allowedTemplateGroups);
            TemplateDomainObject defaultTemplate = null;
            try {
                int defaultTemplateId = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__DEFAULT_TEMPLATE_ID));
                defaultTemplate = templateMapper.getTemplateById(defaultTemplateId);
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            textDocumentPermissionSet.setDefaultTemplate(defaultTemplate);
        } else {
            this.documentPermissionSet.setEdit(null != request.getParameter(REQUEST_PARAMETER__EDIT));
        }
    }

    public void forward(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        this.putInSessionAndForwardToPath("/imcms/" + user.getLanguageIso639_2() + URL_I15D_PAGE__DOCUMENT_PERMISSION_SET, request, response);
    }

    public boolean isForNew() {
        return this.forNew;
    }
}

