/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Mail;
import com.imcode.imcms.api.MailException;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.RoleAlreadyExistsException;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.SecurityChecker;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserAlreadyExistsException;
import imcode.server.db.IntegrityConstraintViolationSQLException;
import imcode.server.db.StringTruncationSQLException;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;

public class UserService {
    private ContentManagementSystem contentManagementSystem;

    UserService(ContentManagementSystem contentManagementSystem) {
        this.contentManagementSystem = contentManagementSystem;
    }

    private ImcmsAuthenticatorAndUserAndRoleMapper getMapper() {
        return this.contentManagementSystem.getInternal().getImcmsAuthenticatorAndUserAndRoleMapper();
    }

    private SecurityChecker getSecurityChecker() {
        return this.contentManagementSystem.getSecurityChecker();
    }

    public User[] getAllUsers() throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        UserDomainObject[] internalUsers = this.getMapper().getAllUsers();
        User[] result = new User[internalUsers.length];
        for (int i = 0; i < result.length; ++i) {
            UserDomainObject internalUser = internalUsers[i];
            result[i] = new User(internalUser);
        }
        return result;
    }

    public User getUser(String userLoginName) throws NoPermissionException {
        UserDomainObject internalUser = this.getMapper().getUser(userLoginName);
        if (null == internalUser) {
            return null;
        }
        return new User(internalUser);
    }

    public Role[] getAllRoles() throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        RoleDomainObject[] roleDOs = this.getMapper().getAllRoles();
        Role[] roles = new Role[roleDOs.length];
        for (int i = 0; i < roleDOs.length; ++i) {
            roles[i] = new Role(roleDOs[i]);
        }
        return roles;
    }

    public String[] getAllRolesNames() throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        return this.getMapper().getAllRoleNames();
    }

    public String[] getRoleNames(User user) throws NoPermissionException {
        return user.getRoleNames();
    }

    public Role getRole(int roleId) throws NoPermissionException {
        RoleDomainObject roleDO = this.getMapper().getRoleById(roleId);
        return null == roleDO ? null : new Role(roleDO);
    }

    public Role getRole(String roleName) throws NoPermissionException {
        RoleDomainObject roleDO = this.getMapper().getRoleByName(roleName);
        return null == roleDO ? null : new Role(roleDO);
    }

    public void deleteRole(Role role) throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        this.getMapper().deleteRole(role.getInternal());
    }

    public void setUserRoles(User user, String[] roleNames) throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        this.getMapper().setUserRoles(user.getInternal(), roleNames);
    }

    public Role addNewRole(String roleName) throws NoPermissionException, SaveException {
        Role role = this.createNewRole(roleName);
        this.saveRole(role);
        return role;
    }

    public User[] getAllUserWithRole(String roleName) throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        return this.getAllUsersWithRole(this.getRole(roleName));
    }

    public User[] getAllUsersWithRole(Role role) throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        UserDomainObject[] internalUsersWithRole = this.getMapper().getAllUsersWithRole(role.getInternal());
        User[] users = new User[internalUsersWithRole.length];
        for (int i = 0; i < internalUsersWithRole.length; ++i) {
            UserDomainObject user = internalUsersWithRole[i];
            users[i] = new User(user);
        }
        return users;
    }

    public void deleteRole(String role) throws NoPermissionException {
        this.getSecurityChecker().isSuperAdmin();
        ImcmsAuthenticatorAndUserAndRoleMapper mapper = this.getMapper();
        mapper.deleteRole(mapper.getRoleByName(role));
    }

    public Role createNewRole(String roleName) {
        return new Role(new RoleDomainObject(roleName));
    }

    public void saveRole(Role role) throws NoPermissionException, SaveException {
        if (null == role) {
            return;
        }
        this.getSecurityChecker().isSuperAdmin();
        try {
            this.getMapper().saveRole(role.getInternal());
        }
        catch (IntegrityConstraintViolationSQLException icvse) {
            throw new RoleAlreadyExistsException("A role with the name \"" + role.getName() + "\" already exists.");
        }
        catch (StringTruncationSQLException stse) {
            throw new SaveException("Role name too long.");
        }
    }

    public User createNewUser(String loginName, String password) {
        UserDomainObject internalUser = new UserDomainObject();
        internalUser.setLoginName(loginName);
        internalUser.setPassword(password);
        internalUser.setLanguageIso639_2(this.contentManagementSystem.getInternal().getDefaultLanguage());
        internalUser.setActive(true);
        return new User(internalUser);
    }

    public void saveUser(User user) throws NoPermissionException, SaveException {
        if (null == user) {
            return;
        }
        this.getSecurityChecker().isSuperAdminOrSameUser(user);
        try {
            ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = this.getMapper();
            if (0 == user.getId()) {
                imcmsAuthenticatorAndUserAndRoleMapper.addUser(user.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal());
            } else {
                imcmsAuthenticatorAndUserAndRoleMapper.saveUser(user.getInternal(), this.contentManagementSystem.getCurrentUser().getInternal());
            }
        }
        catch (IntegrityConstraintViolationSQLException icvse) {
            throw new UserAlreadyExistsException("A user with the login name \"" + user.getLoginName() + "\" already exists.");
        }
    }

    public void sendPasswordReminderMail(User user, String fromAddress, String subject, String body, String bodyPasswordPlaceHolderRegex) throws MailException {
        UserDomainObject userDO = user.getInternal();
        String password = userDO.getPassword();
        String bodyWithPassword = body.replaceAll(bodyPasswordPlaceHolderRegex, password);
        Mail mail = new Mail(fromAddress);
        mail.setSubject(subject);
        mail.setBody(bodyWithPassword);
        mail.setToAddresses(new String[]{userDO.getEmailAddress()});
        MailService mailService = this.contentManagementSystem.getMailService();
        mailService.sendMail(mail);
    }
}

