/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentAlreadyInMenuException;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.Image;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Template;
import com.imcode.imcms.api.TemplateGroup;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentPredicate;
import imcode.server.document.DocumentReference;
import imcode.server.document.DocumentStoringVisitor;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImagesPathRelativePathImageSource;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.document.textdocument.TreeSortKeyDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.CloneTransformer;
import org.apache.commons.collections.map.TransformedSortedMap;
import org.apache.commons.lang.StringUtils;

public class TextDocument
extends Document {
    public static final int TYPE_ID = 2;

    TextDocument(TextDocumentDomainObject textDocument, ContentManagementSystem contentManagementSystem) {
        super(textDocument, contentManagementSystem);
    }

    public SortedMap getTextFields() {
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object o) {
                Map.Entry entry = (Map.Entry)o;
                TextDomainObject tempTextField = (TextDomainObject)entry.getValue();
                return StringUtils.isNotEmpty((String)tempTextField.getText());
            }
        };
        Transformer fromDomainToAPITransformer = new Transformer(){

            public Object transform(Object o) {
                TextDomainObject tempTextField = (TextDomainObject)o;
                return new TextField(tempTextField);
            }
        };
        Map textFieldsMap = this.getInternalTextDocument().getTexts();
        return this.filterAndConvertValues(textFieldsMap, predicate, fromDomainToAPITransformer);
    }

    public SortedMap getImages() {
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object o) {
                Map.Entry entry = (Map.Entry)o;
                ImageDomainObject tempImage = (ImageDomainObject)entry.getValue();
                return !tempImage.isEmpty();
            }
        };
        Transformer fromDomainToAPITransformer = new Transformer(){

            public Object transform(Object o) {
                ImageDomainObject tempImage = (ImageDomainObject)o;
                return new Image(tempImage);
            }
        };
        Map imagesMap = this.getInternalTextDocument().getImages();
        return this.filterAndConvertValues(imagesMap, predicate, fromDomainToAPITransformer);
    }

    public SortedMap getIncludes() {
        Predicate predicate = new Predicate(){

            public boolean evaluate(Object o) {
                Map.Entry entry = (Map.Entry)o;
                Integer tempMetaId = (Integer)entry.getValue();
                return null != tempMetaId;
            }
        };
        Transformer fromDomainToAPITransformer = new Transformer(){

            public Object transform(Object o) {
                Integer tempMetaId = (Integer)o;
                return DocumentService.wrapDocumentDomainObject(TextDocument.this.getDocumentMapper().getDocument(tempMetaId), TextDocument.this.contentManagementSystem);
            }
        };
        Map includeMap = this.getInternalTextDocument().getIncludes();
        return this.filterAndConvertValues(includeMap, predicate, fromDomainToAPITransformer);
    }

    private DocumentMapper getDocumentMapper() {
        return this.contentManagementSystem.getInternal().getDocumentMapper();
    }

    private SortedMap filterAndConvertValues(Map map, Predicate predicate, Transformer transformer) {
        Collection nonEmptyTextFields = CollectionUtils.select(map.entrySet(), (Predicate)predicate);
        SortedMap sortedMap = TransformedSortedMap.decorate(new TreeMap(), (Transformer)CloneTransformer.INSTANCE, (Transformer)transformer);
        Iterator iterator = nonEmptyTextFields.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            sortedMap.put(entry.getKey(), entry.getValue());
        }
        return sortedMap;
    }

    public TextField getTextField(int textFieldIndexInDocument) throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        TextDomainObject imcmsText = this.getInternalTextDocument().getText(textFieldIndexInDocument);
        TextField textField = new TextField(imcmsText);
        return textField;
    }

    private TextDocumentDomainObject getInternalTextDocument() {
        return (TextDocumentDomainObject)this.getInternal();
    }

    public void setPlainTextField(int textFieldIndexInDocument, String newText) throws NoPermissionException {
        this.setTextField(textFieldIndexInDocument, newText, 0);
    }

    public void setHtmlTextField(int textFieldIndexInDocument, String newText) throws NoPermissionException {
        this.setTextField(textFieldIndexInDocument, newText, 1);
    }

    private void setTextField(int textFieldIndexInDocument, String newText, int textType) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        TextDomainObject imcmsText = new TextDomainObject(newText, textType);
        this.getInternalTextDocument().setText(textFieldIndexInDocument, imcmsText);
    }

    public void setImage(int imageIndexInDocument, String image_src, String image_name, int width, int heigth, int border, int v_space, int h_space, String align, String link_target, String link_targetname, String link_href, String alt_text, String low_src) throws NoPermissionException {
        this.setImage(imageIndexInDocument, image_src, image_name, width, heigth, border, v_space, h_space, align, link_target, link_href, alt_text, low_src);
    }

    public void setImage(int imageIndexInDocument, String image_src, String image_name, int width, int heigth, int border, int v_space, int h_space, String align, String link_target, String link_href, String alt_text, String low_src) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        ImageDomainObject internalImage = new ImageDomainObject();
        internalImage.setSource(new ImagesPathRelativePathImageSource(image_src));
        internalImage.setName(image_name);
        internalImage.setWidth(width);
        internalImage.setHeight(heigth);
        internalImage.setBorder(border);
        internalImage.setVerticalSpace(v_space);
        internalImage.setHorizontalSpace(h_space);
        internalImage.setTarget(link_target);
        internalImage.setAlign(align);
        internalImage.setAlternateText(alt_text);
        internalImage.setLowResolutionUrl(low_src);
        internalImage.setLinkUrl(link_href);
        DocumentStoringVisitor.saveDocumentImage(this.getId(), imageIndexInDocument, internalImage);
    }

    public Image getImage(int imageIndexInDocument) throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        ImageDomainObject internalImage = this.getInternalTextDocument().getImage(imageIndexInDocument);
        if (null != internalImage) {
            return new Image(internalImage);
        }
        return null;
    }

    public Template getTemplate() {
        TemplateDomainObject template = this.getInternalTextDocument().getTemplate();
        Template result = new Template(template);
        return result;
    }

    public void setTemplate(TemplateGroup templateGroup, Template template) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.getInternalTextDocument().setTemplate(template.getInternal());
        if (null != templateGroup) {
            this.getInternalTextDocument().setTemplateGroupId(templateGroup.getId());
        }
    }

    public void setTemplate(Template template) throws NoPermissionException {
        this.setTemplate(null, template);
    }

    public Document getInclude(int includeIndexInDocument) throws NoPermissionException {
        DocumentDomainObject includedDocument;
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        Integer includedDocumentId = this.getInternalTextDocument().getIncludedDocumentId(includeIndexInDocument);
        if (null != includedDocumentId && null != (includedDocument = this.getDocumentMapper().getDocument(includedDocumentId))) {
            return DocumentService.wrapDocumentDomainObject(includedDocument, this.contentManagementSystem);
        }
        return null;
    }

    public void setInclude(int includeIndexInDocument, TextDocument documentToBeIncluded) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        if (null == documentToBeIncluded) {
            this.getInternalTextDocument().removeInclude(includeIndexInDocument);
        } else {
            this.getInternalTextDocument().setInclude(includeIndexInDocument, documentToBeIncluded.getId());
        }
    }

    public Menu getMenu(int menuIndexInDocument) throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return new Menu(this, menuIndexInDocument);
    }

    public SortedMap getMenus() {
        Map internalMenus = this.getInternalTextDocument().getMenus();
        TreeMap<Integer, Menu> menus = new TreeMap<Integer, Menu>();
        Iterator iterator = internalMenus.keySet().iterator();
        while (iterator.hasNext()) {
            Integer menuIndex = (Integer)iterator.next();
            menus.put(menuIndex, new Menu(this, menuIndex));
        }
        return menus;
    }

    public void setImage(int imageIndex, Image image) {
        TextDocumentDomainObject textDocument = (TextDocumentDomainObject)this.getInternal();
        textDocument.setImage(imageIndex, image.getInternal());
    }

    ContentManagementSystem getContentManagementSystem() {
        return this.contentManagementSystem;
    }

    public static class Menu {
        public static final int SORT_BY_HEADLINE = 1;
        public static final int SORT_BY_MANUAL_ORDER_DESCENDING = 2;
        public static final int SORT_BY_MODIFIED_DATETIME_DESCENDING = 3;
        public static final int SORT_BY_TREE_ORDER_DESCENDING = 4;
        private final TextDocument textDocument;
        private final TextDocumentDomainObject internalTextDocument;
        private final int menuIndex;
        private final ContentManagementSystem contentManagementSystem;

        Menu(TextDocument document, int menuIndex) {
            this.textDocument = document;
            this.internalTextDocument = document.getInternalTextDocument();
            this.menuIndex = menuIndex;
            this.contentManagementSystem = document.getContentManagementSystem();
        }

        public void addDocument(Document documentToAdd) throws NoPermissionException, DocumentAlreadyInMenuException {
            this.contentManagementSystem.getSecurityChecker().hasEditPermission(this.textDocument);
            this.contentManagementSystem.getSecurityChecker().userHasPermissionToAddDocumentToAnyMenu(documentToAdd);
            ImcmsServices internal = this.contentManagementSystem.getInternal();
            DocumentMapper documentMapper = internal.getDocumentMapper();
            DocumentReference documentReference = documentMapper.getDocumentReference(documentToAdd.getInternal());
            this.internalTextDocument.getMenu(this.menuIndex).addMenuItem(new MenuItemDomainObject(documentReference));
        }

        public void removeDocument(Document documentToRemove) throws NoPermissionException {
            this.contentManagementSystem.getSecurityChecker().hasEditPermission(this.textDocument);
            this.internalTextDocument.getMenu(this.menuIndex).removeMenuItemByDocumentId(documentToRemove.getId());
        }

        public void setSortOrder(int sortOrder) {
            this.internalTextDocument.getMenu(this.menuIndex).setSortOrder(sortOrder);
        }

        public int getSortOrder() {
            return this.internalTextDocument.getMenu(this.menuIndex).getSortOrder();
        }

        public MenuItem[] getVisibleMenuItems() {
            UserDomainObject user = this.contentManagementSystem.getCurrentUser().getInternal();
            DocumentPredicate documentPredicate = new DocumentPredicate(this, user){
                private final /* synthetic */ UserDomainObject val$user;
                private final /* synthetic */ Menu this$0;
                {
                    this.this$0 = this$0;
                    this.val$user = val$user;
                }

                public boolean evaluateDocument(DocumentDomainObject document) {
                    return this.val$user.canSeeDocumentInMenus(document);
                }
            };
            return this.getMenuItems(documentPredicate);
        }

        public Document[] getVisibleDocuments() {
            MenuItem[] menuItems = this.getVisibleMenuItems();
            Document[] documents = this.getDocumentsFromMenuItems(menuItems);
            return documents;
        }

        public MenuItem[] getMenuItems() {
            UserDomainObject user = this.contentManagementSystem.getCurrentUser().getInternal();
            return this.getMenuItems(new DocumentPredicate(this, user){
                private final /* synthetic */ UserDomainObject val$user;
                private final /* synthetic */ Menu this$0;
                {
                    this.this$0 = this$0;
                    this.val$user = val$user;
                }

                public boolean evaluateDocument(DocumentDomainObject document) {
                    return this.val$user.canSeeDocumentInMenus(document) || this.val$user.canEdit(document);
                }
            });
        }

        public Document[] getDocuments() {
            return this.getDocumentsFromMenuItems(this.getMenuItems());
        }

        private MenuItem[] getMenuItems(DocumentPredicate documentPredicate) {
            MenuItemDomainObject[] menuItemsDomainObjects = this.internalTextDocument.getMenu(this.menuIndex).getMenuItems();
            ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>(menuItemsDomainObjects.length);
            for (int i = 0; i < menuItemsDomainObjects.length; ++i) {
                MenuItemDomainObject menuItemDomainObject = menuItemsDomainObjects[i];
                DocumentDomainObject document = menuItemDomainObject.getDocument();
                if (!documentPredicate.evaluateDocument(document)) continue;
                menuItems.add(new MenuItem(menuItemDomainObject, this.contentManagementSystem));
            }
            return menuItems.toArray(new MenuItem[menuItems.size()]);
        }

        private Document[] getDocumentsFromMenuItems(MenuItem[] menuItems) {
            Document[] documents = new Document[menuItems.length];
            for (int i = 0; i < menuItems.length; ++i) {
                MenuItem menuItem = menuItems[i];
                documents[i] = menuItem.getDocument();
            }
            return documents;
        }
    }

    public static class MenuItem {
        MenuItemDomainObject internalMenuItem;
        Document child;

        public MenuItem(MenuItemDomainObject internalMenuItem, ContentManagementSystem contentManagementSystem) {
            this.internalMenuItem = internalMenuItem;
            DocumentService.ApiWrappingDocumentVisitor visitor = new DocumentService.ApiWrappingDocumentVisitor(contentManagementSystem);
            internalMenuItem.getDocument().accept(visitor);
            this.child = visitor.getDocument();
        }

        public Document getDocument() {
            return this.child;
        }

        public int getManualNumber() {
            Integer sortKey = this.internalMenuItem.getSortKey();
            if (null == sortKey) {
                return 0;
            }
            return sortKey;
        }

        public TreeKey getTreeKey() {
            return new TreeKey(this.internalMenuItem.getTreeSortKey());
        }

        public class TreeKey {
            TreeSortKeyDomainObject internalTreeSortKey;

            public TreeKey(TreeSortKeyDomainObject internalTreeSortKey) {
                this.internalTreeSortKey = internalTreeSortKey;
            }

            public int getLevelCount() {
                return this.internalTreeSortKey.getLevelCount();
            }

            public int getLevelKey(int level) {
                return this.internalTreeSortKey.getLevelKey(level - 1);
            }

            public String toString() {
                return this.internalTreeSortKey.toString();
            }
        }
    }

    public static class TextField {
        private TextDomainObject imcmsText;

        private TextField(TextDomainObject imcmsText) {
            this.imcmsText = imcmsText;
        }

        public void setHtmlFormat() {
            this.imcmsText.setType(1);
        }

        public void setPlainFormat() {
            this.imcmsText.setType(0);
        }

        public String getText() {
            if (null != this.imcmsText) {
                return this.imcmsText.getText();
            }
            return "";
        }

        public String getHtmlFormattedText() {
            if (null != this.imcmsText) {
                return this.imcmsText.toHtmlString();
            }
            return "";
        }
    }
}

