/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryAlreadyExistsException;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.TextDocument;
import com.imcode.imcms.api.User;
import imcode.server.Config;
import imcode.server.MockImcmsServices;
import imcode.server.db.MockDatabase;
import imcode.server.document.DocumentMapper;
import imcode.server.document.MockDocumentIndex;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import junit.framework.TestCase;

public class TestDocumentService
extends TestCase {
    private DocumentService documentService;
    private MockDatabase database;
    private User user;
    private MockContentManagementSystem contentManagementSystem;

    public void setUp() throws Exception {
        super.setUp();
        this.contentManagementSystem = new MockContentManagementSystem();
        this.user = new User(new UserDomainObject());
        this.contentManagementSystem.setCurrentUser(this.user);
        MockImcmsServices imcmsServices = new MockImcmsServices();
        this.database = new MockDatabase();
        imcmsServices.setDocumentMapper(new DocumentMapper(imcmsServices, this.database, null, null, new MockDocumentIndex(), null, new Config()));
        this.contentManagementSystem.setInternal(imcmsServices);
        this.documentService = new DocumentService(this.contentManagementSystem);
    }

    public void testSaveCategory() throws CategoryAlreadyExistsException, NoPermissionException {
        String[][] allCategoryTypesResult = new String[][]{{"1", "test", "0", "0"}};
        this.database.addExpectedSqlCall(new MockDatabase.MatchesRegexSqlCallPredicate("SELECT category_types.category_type_id"), allCategoryTypesResult);
        CategoryType categoryType = this.documentService.getAllCategoryTypes()[0];
        TestDocumentService.assertEquals((boolean)false, (boolean)categoryType.isInherited());
        String categoryName = "name";
        Category category = new Category(categoryName, categoryType);
        category.setDescription("description");
        category.setImage("image");
        try {
            this.documentService.saveCategory(category);
            TestDocumentService.fail();
        }
        catch (NoPermissionException e) {
            // empty catch block
        }
        this.user.addRole(new Role(RoleDomainObject.SUPERADMIN));
        this.database.addExpectedSqlCall(new MockDatabase.MatchesRegexSqlCallPredicate("insert.*categories.*IDENTITY"), "1");
        this.documentService.saveCategory(category);
        this.database.verifyExpectedSqlCalls();
        String[] categoryResult = new String[]{"1", category.getName(), category.getDescription(), category.getImage()};
        this.database.addExpectedSqlCall(new MockDatabase.EqualsSqlCallPredicate("SELECT categories.category_id, categories.name, categories.description, categories.image\nFROM categories\nJOIN category_types\nON categories.category_type_id = category_types.category_type_id\nWHERE category_types.name = ?\nAND categories.name = ?"), categoryResult);
        this.documentService.saveCategory(category);
        this.database.verifyExpectedSqlCalls();
        this.database.addExpectedSqlCall(new MockDatabase.EqualsSqlCallPredicate("SELECT categories.category_id, categories.name, categories.description, categories.image\nFROM categories\nJOIN category_types\nON categories.category_type_id = category_types.category_type_id\nWHERE category_types.name = ?\nAND categories.name = ?"), categoryResult);
        Category otherCategory = new Category(categoryName, categoryType);
        try {
            this.documentService.saveCategory(otherCategory);
            TestDocumentService.fail();
        }
        catch (CategoryAlreadyExistsException e) {
            // empty catch block
        }
        this.database.verifyExpectedSqlCalls();
        String otherName = "other name";
        category.setName(otherName);
        category.setDescription("other description");
        category.setImage("other image");
        this.documentService.saveCategory(category);
        this.database.assertCalled(new MockDatabase.UpdateTableSqlCallPredicate("categories", otherName));
    }

    public void testDeleteDocument() throws Exception {
        TextDocument document = new TextDocument(new TextDocumentDomainObject(), (ContentManagementSystem)this.contentManagementSystem);
        try {
            this.documentService.deleteDocument(document);
            TestDocumentService.fail((String)"Expected NoPermissionException");
        }
        catch (NoPermissionException e) {
            // empty catch block
        }
        UserDomainObject admin = new UserDomainObject();
        admin.addRole(RoleDomainObject.SUPERADMIN);
        this.contentManagementSystem.setCurrentInternalUser(admin);
        this.documentService.deleteDocument(document);
    }
}

