/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.TextDocument;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public class TestDocument
extends TestCase {
    public void testGetAllRolesMappedToPermissions() throws NoPermissionException {
        MockContentManagementSystem contentManagementSystem = new MockContentManagementSystem();
        contentManagementSystem.setCurrentInternalUser(new UserDomainObject());
        TextDocumentDomainObject textDocument = new TextDocumentDomainObject();
        textDocument.setPermissionSetIdForRole(RoleDomainObject.USERADMIN, 0);
        textDocument.setPermissionSetIdForRole(RoleDomainObject.USERS, 0);
        textDocument.setPermissionSetIdForRole(new RoleDomainObject(3, "test", 0), 0);
        TextDocument doc = new TextDocument(textDocument, (ContentManagementSystem)contentManagementSystem);
        Map allRolesMappedToPermissions = doc.getAllRolesMappedToPermissions();
        Iterator iterator = allRolesMappedToPermissions.keySet().iterator();
        String roleName = (String)iterator.next();
        TestDocument.assertEquals((String)RoleDomainObject.USERADMIN.getName(), (String)roleName);
        roleName = (String)iterator.next();
        TestDocument.assertEquals((String)"Users", (String)roleName);
        roleName = (String)iterator.next();
        TestDocument.assertEquals((String)"test", (String)roleName);
    }
}

