/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.shop;

import imcode.util.shop.ShoppingCart;
import imcode.util.shop.ShoppingItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;

public class TestShoppingCart
extends TestCase {
    private ShoppingItem[] items = new ShoppingItem[7];

    public TestShoppingCart(String name) {
        super(name);
    }

    protected void setUp() {
        this.items[0] = new ShoppingItem();
        this.items[0].setDescription(2, "Desc");
        this.items[0].setPrice(0.1);
        this.items[1] = new ShoppingItem();
        this.items[1].setDescription(2, "XXX");
        this.items[1].setPrice(1.2);
        this.items[2] = new ShoppingItem();
        this.items[2].setDescription(1, "Desc");
        this.items[2].setPrice(2.3);
        this.items[3] = new ShoppingItem();
        this.items[3].setDescription(1, "Desc");
        this.items[3].setDescription(2, "Desc");
        this.items[3].setPrice(3.4);
        this.items[4] = new ShoppingItem();
        this.items[4].setDescription(1, "Desc");
        this.items[4].setDescription(2, "XXX");
        this.items[4].setPrice(4.5);
        this.items[5] = new ShoppingItem();
        this.items[5].setDescription(1, "XXX");
        this.items[5].setDescription(2, "Desc");
        this.items[5].setPrice(5.6);
        this.items[6] = new ShoppingItem();
        this.items[6].setDescription(1, "XXX");
        this.items[6].setDescription(2, "XXX");
        this.items[6].setPrice(6.7);
    }

    public void testAddAndCountAndRemove() {
        ShoppingCart theCart = new ShoppingCart();
        ShoppingItem item1 = new ShoppingItem();
        item1.setPrice(1.0);
        ShoppingItem item2 = new ShoppingItem();
        item2.setPrice(2.0);
        theCart.addItem(item1, 1);
        TestShoppingCart.assertEquals((int)1, (int)theCart.countItem(item1));
        TestShoppingCart.assertEquals((int)1, (int)theCart.countItems());
        theCart.addItem(item2, 2);
        TestShoppingCart.assertEquals((int)2, (int)theCart.countItem(item2));
        TestShoppingCart.assertEquals((int)3, (int)theCart.countItems());
        theCart.removeItem(item1);
        TestShoppingCart.assertEquals((int)0, (int)theCart.countItem(item1));
        TestShoppingCart.assertEquals((int)2, (int)theCart.countItem(item2));
        TestShoppingCart.assertEquals((int)2, (int)theCart.countItems());
        theCart.putItem(item2, 4);
        TestShoppingCart.assertEquals((int)0, (int)theCart.countItem(item1));
        TestShoppingCart.assertEquals((int)4, (int)theCart.countItem(item2));
        TestShoppingCart.assertEquals((int)4, (int)theCart.countItems());
    }

    public void testSorted() {
        ShoppingCart cart = new ShoppingCart();
        ArrayList<ShoppingItem> list = new ArrayList<ShoppingItem>(Arrays.asList(this.items));
        Collections.reverse(list);
        cart.addAll(list);
        ShoppingItem[] cartItems = cart.getItems();
        for (int i = 0; i < this.items.length; ++i) {
            for (int j = 0; j < this.items.length; ++j) {
                if (i == j) {
                    TestShoppingCart.assertEquals((String)("items[" + i + "] == cartItems[" + j + "]\n" + this.itemsToString(cartItems)), (Object)this.items[i], (Object)cartItems[j]);
                    continue;
                }
                TestShoppingCart.assertTrue((String)("items[" + i + "] != cartItems[" + j + "]\n" + this.itemsToString(cartItems)), (this.items[i] != cartItems[j] ? 1 : 0) != 0);
            }
        }
    }

    private String itemsToString(ShoppingItem[] items) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            result.append(items[i].toString());
            result.append('\n');
        }
        return result.toString();
    }
}

