/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.oro.util.CacheLRU;

public class FileCache {
    private final int fileCacheSize = 100;
    private CacheLRU fileCache = new CacheLRU(100);

    private StringBuffer loadFile(File file) throws IOException {
        StringBuffer tempbuffer = new StringBuffer();
        char[] charbuffer = new char[16384];
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        int chars_read = 0;
        while (-1 < (chars_read = br.read(charbuffer))) {
            tempbuffer.append(charbuffer, 0, chars_read);
        }
        br.close();
        return tempbuffer;
    }

    public synchronized String getCachedFileString(File file) throws IOException {
        Object[] file_and_date = (Object[])this.fileCache.getElement((Object)file);
        if (file_and_date == null || file.lastModified() > (Long)file_and_date[1]) {
            String temp = this.loadFile(file).toString();
            this.fileCache.addElement((Object)file, (Object)new Object[]{temp, new Long(System.currentTimeMillis())});
            return temp;
        }
        return (String)file_and_date[0];
    }

    public String getUncachedFileString(File file) throws IOException {
        return this.loadFile(file).toString();
    }
}

