/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.Imcms;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;

public class LazilyLoadedUserDomainObject
extends UserDomainObject {
    private boolean attributesLoaded;
    private boolean phoneNumbersLoaded;
    private boolean rolesLoaded;

    public LazilyLoadedUserDomainObject(int id) {
        this(id, true);
    }

    public LazilyLoadedUserDomainObject(int id, boolean loadAttributes) {
        this.id = id;
        this.attributesLoaded = !loadAttributes;
    }

    private void loadAttributes() {
        if (this.attributesLoaded) {
            return;
        }
        this.attributesLoaded = true;
        if (0 != this.id) {
            ImcmsAuthenticatorAndUserAndRoleMapper userMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
            userMapper.initUserAttributes(this);
        }
    }

    private void loadPhoneNumbers() {
        if (this.phoneNumbersLoaded) {
            return;
        }
        this.phoneNumbersLoaded = true;
        if (0 != this.id) {
            ImcmsAuthenticatorAndUserAndRoleMapper userMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
            userMapper.initUserPhoneNumbers(this);
        }
    }

    private void loadRoles() {
        if (this.rolesLoaded) {
            return;
        }
        this.rolesLoaded = true;
        if (0 != this.id) {
            ImcmsAuthenticatorAndUserAndRoleMapper userMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
            userMapper.initUserRoles(this);
        }
    }

    public void addRole(RoleDomainObject role) {
        this.loadRoles();
        super.addRole(role);
    }

    public String getAddress() {
        this.loadAttributes();
        return super.getAddress();
    }

    public String getCity() {
        this.loadAttributes();
        return super.getCity();
    }

    public String getCompany() {
        this.loadAttributes();
        return super.getCompany();
    }

    public String getCountry() {
        this.loadAttributes();
        return super.getCountry();
    }

    public String getCountyCouncil() {
        this.loadAttributes();
        return super.getCountyCouncil();
    }

    public String getCreateDate() {
        this.loadAttributes();
        return super.getCreateDate();
    }

    public String getEmailAddress() {
        this.loadAttributes();
        return super.getEmailAddress();
    }

    public String getFaxPhone() {
        this.loadPhoneNumbers();
        return super.getFaxPhone();
    }

    public String getFirstName() {
        this.loadAttributes();
        return super.getFirstName();
    }

    public String getHomePhone() {
        this.loadPhoneNumbers();
        return super.getHomePhone();
    }

    public String getLanguageIso639_2() {
        this.loadAttributes();
        return super.getLanguageIso639_2();
    }

    public String getLastName() {
        this.loadAttributes();
        return super.getLastName();
    }

    public String getLoginName() {
        this.loadAttributes();
        return super.getLoginName();
    }

    public String getMobilePhone() {
        this.loadPhoneNumbers();
        return super.getMobilePhone();
    }

    public String getOtherPhone() {
        this.loadPhoneNumbers();
        return super.getOtherPhone();
    }

    public String getPassword() {
        this.loadAttributes();
        return super.getPassword();
    }

    public RoleDomainObject[] getRoles() {
        this.loadRoles();
        return super.getRoles();
    }

    public String getTitle() {
        this.loadAttributes();
        return super.getTitle();
    }

    public String getWorkPhone() {
        this.loadPhoneNumbers();
        return super.getWorkPhone();
    }

    public String getZip() {
        this.loadAttributes();
        return super.getZip();
    }

    public boolean hasRole(RoleDomainObject role) {
        this.loadRoles();
        return super.hasRole(role);
    }

    public boolean isActive() {
        this.loadAttributes();
        return super.isActive();
    }

    public boolean isImcmsExternal() {
        this.loadAttributes();
        return super.isImcmsExternal();
    }

    public void removeRole(RoleDomainObject role) {
        this.loadRoles();
        super.removeRole(role);
    }

    public void setActive(boolean active) {
        this.loadAttributes();
        super.setActive(active);
    }

    public void setAddress(String address) {
        this.loadAttributes();
        super.setAddress(address);
    }

    public void setCity(String city) {
        this.loadAttributes();
        super.setCity(city);
    }

    public void setCompany(String company) {
        this.loadAttributes();
        super.setCompany(company);
    }

    public void setCountry(String country) {
        this.loadAttributes();
        super.setCountry(country);
    }

    public void setCountyCouncil(String countyCouncil) {
        this.loadAttributes();
        super.setCountyCouncil(countyCouncil);
    }

    public void setCreateDate(String create_date) {
        this.loadAttributes();
        super.setCreateDate(create_date);
    }

    public void setEmailAddress(String emailAddress) {
        this.loadAttributes();
        super.setEmailAddress(emailAddress);
    }

    public void setFaxPhone(String faxphone) {
        this.loadPhoneNumbers();
        super.setFaxPhone(faxphone);
    }

    public void setFirstName(String firstName) {
        this.loadAttributes();
        super.setFirstName(firstName);
    }

    public void setHomePhone(String homephone) {
        this.loadPhoneNumbers();
        super.setHomePhone(homephone);
    }

    public void setImcmsExternal(boolean external) {
        this.loadAttributes();
        super.setImcmsExternal(external);
    }

    public void setLanguageIso639_2(String languageIso639_2) {
        this.loadAttributes();
        super.setLanguageIso639_2(languageIso639_2);
    }

    public void setLastName(String lastName) {
        this.loadAttributes();
        super.setLastName(lastName);
    }

    public void setLoginName(String loginName) {
        this.loadAttributes();
        super.setLoginName(loginName);
    }

    public void setMobilePhone(String mobilephone) {
        this.loadPhoneNumbers();
        super.setMobilePhone(mobilephone);
    }

    public void setOtherPhone(String otherphone) {
        this.loadPhoneNumbers();
        super.setOtherPhone(otherphone);
    }

    public void setPassword(String password) {
        this.loadAttributes();
        super.setPassword(password);
    }

    public void setRoles(RoleDomainObject[] rolesForUser) {
        this.loadRoles();
        super.setRoles(rolesForUser);
    }

    public void setTitle(String title) {
        this.loadAttributes();
        super.setTitle(title);
    }

    public void setWorkPhone(String workphone) {
        this.loadPhoneNumbers();
        super.setWorkPhone(workphone);
    }

    public void setZip(String zip) {
        this.loadAttributes();
        super.setZip(zip);
    }
}

