/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import com.imcode.util.HumanReadable;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.index.AnalyzerImpl;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.index.IndexDocumentFactory;
import imcode.server.document.index.IndexException;
import imcode.server.user.UserDomainObject;
import imcode.util.IntervalSchedule;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

class DirectoryIndex
implements DocumentIndex {
    private File directory;
    private IndexDocumentFactory indexDocumentFactory = new IndexDocumentFactory();
    private static final int INDEXING_LOG_PERIOD__MILLISECONDS = 60000;
    private boolean inconsistent;
    private static final Logger log = Logger.getLogger((String)DirectoryIndex.class.getName());

    DirectoryIndex(File directory) {
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentDomainObject[] search(Query query, UserDomainObject searchingUser) throws IndexException {
        DocumentDomainObject[] documentDomainObjectArray;
        IndexSearcher indexSearcher = new IndexSearcher(this.directory.toString());
        try {
            StopWatch searchStopWatch = new StopWatch();
            searchStopWatch.start();
            Hits hits = indexSearcher.search(query);
            long searchTime = searchStopWatch.getTime();
            List documentList = this.getDocumentListForHits(hits, searchingUser);
            log.debug((Object)("Search for " + query.toString() + ": " + searchTime + "ms. Total: " + searchStopWatch.getTime() + "ms."));
            documentDomainObjectArray = documentList.toArray(new DocumentDomainObject[documentList.size()]);
        }
        catch (Throwable throwable) {
            try {
                indexSearcher.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new IndexException(e);
            }
        }
        indexSearcher.close();
        return documentDomainObjectArray;
    }

    public void rebuild() {
        try {
            this.indexAllDocuments();
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    private List getDocumentListForHits(Hits hits, UserDomainObject searchingUser) throws IOException {
        ArrayList<DocumentDomainObject> documentList = new ArrayList<DocumentDomainObject>(hits.length());
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        for (int i = 0; i < hits.length(); ++i) {
            int metaId = Integer.parseInt(hits.doc(i).get("meta_id"));
            DocumentDomainObject document = documentMapper.getDocument(metaId);
            if (null == document) {
                this.inconsistent = true;
                continue;
            }
            if (!searchingUser.canSearchFor(document)) continue;
            documentList.add(document);
        }
        return documentList;
    }

    public void indexDocument(DocumentDomainObject document) throws IndexException {
        try {
            this.removeDocument(document);
            this.addDocument(document);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDocument(DocumentDomainObject document) throws IndexException {
        try {
            IndexReader indexReader = IndexReader.open((File)this.directory);
            try {
                indexReader.delete(new Term("meta_id", "" + document.getId()));
            }
            finally {
                indexReader.close();
            }
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDocument(DocumentDomainObject document) throws IOException {
        IndexWriter indexWriter = this.createIndexWriter(false);
        try {
            this.addDocumentToIndex(document, indexWriter);
        }
        finally {
            indexWriter.close();
        }
    }

    private IndexWriter createIndexWriter(boolean createIndex) throws IOException {
        return new IndexWriter(this.directory, (Analyzer)new AnalyzerImpl(), createIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexAllDocuments() throws IOException {
        IndexWriter indexWriter = this.createIndexWriter(true);
        try {
            this.indexAllDocumentsToIndexWriter(indexWriter);
        }
        finally {
            indexWriter.close();
        }
    }

    private void addDocumentToIndex(DocumentDomainObject document, IndexWriter indexWriter) throws IOException {
        Document indexDocument = this.indexDocumentFactory.createIndexDocument(document);
        indexWriter.addDocument(indexDocument);
    }

    private void indexAllDocumentsToIndexWriter(IndexWriter indexWriter) throws IOException {
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        int[] documentIds = documentMapper.getAllDocumentIds();
        this.logIndexingStarting(documentIds.length);
        IntervalSchedule indexingLogSchedule = new IntervalSchedule(60000L);
        for (int i = 0; i < documentIds.length; ++i) {
            try {
                this.addDocumentToIndex(documentMapper.getDocument(documentIds[i]), indexWriter);
            }
            catch (Exception ex) {
                log.error((Object)("Could not index document with meta_id " + documentIds[i] + ", trying next document."), (Throwable)ex);
            }
            if (indexingLogSchedule.isTime()) {
                this.logIndexingProgress(i, documentIds.length, indexingLogSchedule.getStopWatch());
            }
            Thread.yield();
        }
        this.logIndexingCompleted(documentIds.length, indexingLogSchedule.getStopWatch());
        this.optimizeIndex(indexWriter);
    }

    private void logIndexingStarting(int documentCount) {
        log.info((Object)("Building index of all " + documentCount + " documents"));
    }

    private void logIndexingProgress(int documentsCompleted, int numberOfDocuments, StopWatch stopWatch) {
        int indexPercentageCompleted = (int)((float)documentsCompleted * (100.0f / (float)numberOfDocuments));
        long elapsedTime = stopWatch.getTime();
        long estimatedTime = (long)numberOfDocuments * elapsedTime / (long)documentsCompleted;
        long estimatedTimeLeft = estimatedTime - elapsedTime;
        Date eta = new Date(System.currentTimeMillis() + estimatedTimeLeft);
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        log.info((Object)("Indexed " + documentsCompleted + " documents (" + indexPercentageCompleted + "%). ETA " + dateFormat.format(eta)));
    }

    private void logIndexingCompleted(int numberOfDocuments, StopWatch indexingStopWatch) {
        long time = indexingStopWatch.getTime();
        String humanReadableTime = HumanReadable.getHumanReadableTimeSpan(time);
        long timePerDocument = time / (long)numberOfDocuments;
        log.info((Object)("Indexed " + numberOfDocuments + " documents in " + humanReadableTime + ". " + timePerDocument + "ms per document."));
    }

    private void optimizeIndex(IndexWriter indexWriter) throws IOException {
        StopWatch optimizeStopWatch = new StopWatch();
        optimizeStopWatch.start();
        indexWriter.optimize();
        optimizeStopWatch.stop();
        log.info((Object)("Optimized index in " + optimizeStopWatch.getTime() + "ms"));
    }

    File getDirectory() {
        return this.directory;
    }

    public boolean isInconsistent() {
        return this.inconsistent;
    }
}

