/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.Config;
import imcode.server.MockImcmsServices;
import imcode.server.db.MockDatabase;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.MockDocumentIndex;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import java.io.Serializable;
import junit.framework.TestCase;

public class TestDocumentMapper
extends TestCase {
    private DocumentMapper documentMapper;
    private MockDatabase database;
    private UserDomainObject user;
    private RoleDomainObject testRole;
    private RoleDomainObject userRole;
    private TextDocumentDomainObject textDocument;
    private TextDocumentDomainObject oldDocument;

    protected void setUp() throws Exception {
        super.setUp();
        this.user = new UserDomainObject();
        this.userRole = new RoleDomainObject(1, "Userrole", 0);
        this.user.addRole(this.userRole);
        this.testRole = new RoleDomainObject(2, "Testrole", 0);
        this.oldDocument = new TextDocumentDomainObject();
        this.oldDocument.setId(1001);
        this.textDocument = new TextDocumentDomainObject();
        this.textDocument.setId(1002);
        this.database = new MockDatabase();
        ImcmsAuthenticatorAndUserAndRoleMapper userRegistry = new ImcmsAuthenticatorAndUserAndRoleMapper(null, null){

            public UserDomainObject getUser(int userId) {
                return TestDocumentMapper.this.user;
            }
        };
        MockImcmsServices services = new MockImcmsServices();
        services.setTemplateMapper(new TemplateMapper(null){

            public TemplateDomainObject getTemplateById(int template_id) {
                return null;
            }
        });
        this.documentMapper = new DocumentMapper(services, this.database, userRegistry, new DocumentPermissionSetMapper(this.database, services), new MockDocumentIndex(), null, new Config());
    }

    public void testNotSerializable() {
        if (DocumentMapper.class.isAssignableFrom(Serializable.class)) {
            TestDocumentMapper.fail((String)"DocumentMapper must not be serializable so it can't be put in the session.");
        }
    }

    public void testUpdateDocumentRolePermissionsWithNoPermissions() throws Exception {
        this.textDocument.setPermissionSetIdForRole(this.testRole, 3);
        this.documentMapper.updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)0, (int)this.database.getSqlCallCount());
    }

    public void testUpdateDocumentRolePermissionsWithRestricted1Permission() throws Exception {
        this.oldDocument.setPermissionSetIdForRole(this.userRole, 1);
        this.textDocument.setRolesMappedToPermissionSetIds(this.oldDocument.getRolesMappedToPermissionSetIds());
        this.textDocument.setPermissionSetIdForRole(this.testRole, 3);
        DocumentPermissionSetDomainObject permissionSetForRestrictedOne = new DocumentPermissionSetDomainObject(1){

            void setFromBits(DocumentDomainObject document, DocumentPermissionSetMapper documentPermissionSetMapper, int permissionBits, boolean forNewDocuments) {
            }
        };
        this.oldDocument.setPermissionSetForRestrictedOne(permissionSetForRestrictedOne);
        permissionSetForRestrictedOne.setEditPermissions(false);
        this.documentMapper.updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)0, (int)this.database.getSqlCallCount());
        permissionSetForRestrictedOne.setEditPermissions(true);
        this.documentMapper.updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)2, (int)this.database.getSqlCallCount());
        this.textDocument.setPermissionSetIdForRole(this.testRole, 1);
        this.documentMapper.updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        this.database.assertCalled(new MockDatabase.ProcedureSqlCallPredicate("SetRoleDocPermissionSetId"));
    }

    public void testUpdateDocumentRolePermissionsWithFullPermission() throws Exception {
        this.oldDocument.setPermissionSetIdForRole(this.userRole, 0);
        this.textDocument.setPermissionSetIdForRole(this.testRole, 3);
        this.textDocument.setRolesMappedToPermissionSetIds(this.oldDocument.getRolesMappedToPermissionSetIds());
        this.documentMapper.updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        TestDocumentMapper.assertEquals((int)1, (int)this.database.getSqlCallCount());
    }

    public void testUpdateDocumentRolePermissionsRemovesPermission() {
        this.oldDocument.setPermissionSetIdForRole(this.userRole, 0);
        this.documentMapper.updateDocumentRolePermissions(this.textDocument, this.user, this.oldDocument);
        this.database.assertNotCalled(new MockDatabase.EqualsWithParametersSqlCallPredicate("SetRoleDocPermissionSetId", new String[]{"" + this.userRole.getId(), "" + this.textDocument.getId(), "0"}));
        this.database.assertCalled(new MockDatabase.EqualsWithParametersSqlCallPredicate("SetRoleDocPermissionSetId", new String[]{"" + this.userRole.getId(), "" + this.textDocument.getId(), "4"}));
        TestDocumentMapper.assertEquals((int)1, (int)this.database.getSqlCallCount());
    }

    public void testUpdateDocumentRolePermissionsAllowsNullOldDocument() throws Exception {
        this.documentMapper.updateDocumentRolePermissions(this.textDocument, this.user, null);
    }

    public void testSaveNewBrowserDocument() throws Exception {
        BrowserDocumentDomainObject browserDocument = new BrowserDocumentDomainObject();
        browserDocument.setPermissionSetIdForRole(this.userRole, 0);
        browserDocument.setBrowserDocumentId(BrowserDocumentDomainObject.Browser.DEFAULT, 1001);
        this.database.addExpectedSqlCall(new MockDatabase.InsertIntoTableSqlCallPredicate("meta"), "1002");
        this.documentMapper.saveNewDocument(browserDocument, this.user);
        this.database.verifyExpectedSqlCalls();
        this.database.assertCallCount(1, new MockDatabase.InsertIntoTableSqlCallPredicate("browser_docs"));
        TestDocumentMapper.assertEquals((int)1002, (int)browserDocument.getId());
    }

    public void testDeleteDocument() {
        String[] documentResultRow = new String[19];
        documentResultRow[0] = "" + this.textDocument.getId();
        documentResultRow[1] = "" + this.textDocument.getDocumentTypeId();
        documentResultRow[5] = "" + this.user.getId();
        documentResultRow[16] = "" + this.textDocument.getStatus();
        this.database.addExpectedSqlCall(new MockDatabase.ProcedureSqlCallPredicate("GetDocumentInfo"), documentResultRow);
        String[] textDocsResultRow = new String[]{"1", "1", "1", "1", "1"};
        this.database.addExpectedSqlCall(new MockDatabase.MatchesRegexSqlCallPredicate("FROM text_docs"), textDocsResultRow);
        TestDocumentMapper.assertNotNull((Object)this.documentMapper.getDocument(this.textDocument.getId()));
        this.documentMapper.deleteDocument(this.textDocument);
        this.database.addExpectedSqlCall(new MockDatabase.ProcedureSqlCallPredicate("GetDocumentInfo"), new String[0]);
        TestDocumentMapper.assertNull((Object)this.documentMapper.getDocument(this.textDocument.getId()));
    }

    public void testCreateTextDocument() {
        this.user.addRole(RoleDomainObject.SUPERADMIN);
        TextDocumentDomainObject document = (TextDocumentDomainObject)this.documentMapper.createDocumentOfTypeFromParent(2, this.textDocument, this.user);
        document.setTemplate(new TemplateDomainObject(1, "test", "test"));
        this.database.addExpectedSqlCall(new MockDatabase.MatchesRegexSqlCallPredicate("@@IDENTITY"), "1002");
        this.documentMapper.saveNewDocument(document, this.user);
    }

    public void testCreateHtmlDocument() {
        this.user.addRole(RoleDomainObject.SUPERADMIN);
        DocumentDomainObject document = this.documentMapper.createDocumentOfTypeFromParent(7, this.textDocument, this.user);
        this.database.addExpectedSqlCall(new MockDatabase.MatchesRegexSqlCallPredicate("@@IDENTITY"), "1002");
        this.documentMapper.saveNewDocument(document, this.user);
    }

    public void testCreateUrlDocument() {
        this.user.addRole(RoleDomainObject.SUPERADMIN);
        DocumentDomainObject document = this.documentMapper.createDocumentOfTypeFromParent(5, this.textDocument, this.user);
        this.database.addExpectedSqlCall(new MockDatabase.MatchesRegexSqlCallPredicate("@@IDENTITY"), "1002");
        this.documentMapper.saveNewDocument(document, this.user);
    }
}

