/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.db;

import imcode.server.db.Database;
import imcode.server.db.DatabaseCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.Assert;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class MockDatabase
implements Database {
    private List sqlCalls = new ArrayList();
    private List expectedSqlCalls = new ArrayList();

    public String[] sqlProcedure(String procedure, String[] params) {
        String[] result = (String[])this.getResultForSqlCall(procedure, params);
        if (null == result) {
            return new String[0];
        }
        return result;
    }

    public Map sqlProcedureHash(String procedure, String[] params) {
        return (Map)this.getResultForSqlCall(procedure, params);
    }

    public int sqlUpdateProcedure(String procedure, String[] params) {
        this.getResultForSqlCall(procedure, params);
        return 0;
    }

    public int sqlUpdateQuery(String sqlStr, String[] params) {
        this.getResultForSqlCall(sqlStr, params);
        return 0;
    }

    public String sqlProcedureStr(String procedure, String[] params) {
        return (String)this.getResultForSqlCall(procedure, params);
    }

    public String[][] sqlProcedureMulti(String procedure, String[] params) {
        String[][] result = (String[][])this.getResultForSqlCall(procedure, params);
        if (null == result) {
            result = new String[0][0];
        }
        return result;
    }

    public String[] sqlQuery(String sqlStr, String[] params) {
        String[] result = (String[])this.getResultForSqlCall(sqlStr, params);
        if (null == result) {
            result = new String[]{};
        }
        return result;
    }

    public String sqlQueryStr(String sqlStr, String[] params) {
        return (String)this.getResultForSqlCall(sqlStr, params);
    }

    public String[][] sqlQueryMulti(String sqlstr, String[] params) {
        String[][] result = (String[][])this.getResultForSqlCall(sqlstr, params);
        if (null == result) {
            result = new String[0][0];
        }
        return result;
    }

    public void executeTransaction(DatabaseCommand databaseCommand) {
    }

    public void addExpectedSqlCall(final SqlCallPredicate sqlCallPredicate, final Object result) {
        this.expectedSqlCalls.add(new Map.Entry(){

            public Object getKey() {
                return sqlCallPredicate;
            }

            public Object getValue() {
                return result;
            }

            public Object setValue(Object value) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return sqlCallPredicate + ": " + result;
            }
        });
    }

    public void verifyExpectedSqlCalls() {
        if (!this.expectedSqlCalls.isEmpty()) {
            Assert.fail((String)("Remaining expected sql calls: " + this.expectedSqlCalls.toString()));
        }
    }

    public int getSqlCallCount() {
        return this.sqlCalls.size();
    }

    private Object getResultForSqlCall(String procedure, String[] params) {
        Map.Entry entry;
        SqlCallPredicate predicate;
        SqlCall sqlCall = new SqlCall(procedure, params);
        this.sqlCalls.add(sqlCall);
        Object result = null;
        if (!this.expectedSqlCalls.isEmpty() && (predicate = (SqlCallPredicate)(entry = (Map.Entry)this.expectedSqlCalls.get(0)).getKey()).evaluateSqlCall(sqlCall)) {
            result = entry.getValue();
            this.expectedSqlCalls.remove(0);
        }
        return result;
    }

    public List getSqlCalls() {
        return this.sqlCalls;
    }

    public void assertCalled(SqlCallPredicate predicate) {
        this.assertCalled(null, predicate);
    }

    public void assertCalled(String message, SqlCallPredicate predicate) {
        if (!this.called(predicate)) {
            String messagePrefix = null == message ? "" : message + " ";
            Assert.fail((String)(messagePrefix + "Expected at least one sql call: " + predicate.getFailureMessage()));
        }
    }

    private boolean called(SqlCallPredicate predicate) {
        return CollectionUtils.exists((Collection)this.sqlCalls, (Predicate)predicate);
    }

    public void assertNotCalled(SqlCallPredicate sqlCallPredicate) {
        this.assertNotCalled(null, sqlCallPredicate);
    }

    public void assertNotCalled(String message, SqlCallPredicate predicate) {
        if (this.called(predicate)) {
            String messagePrefix = null == message ? "" : message + " ";
            Assert.fail((String)(messagePrefix + "Got unexpected sql call: " + predicate.getFailureMessage()));
        }
    }

    public void assertCallCount(int expectedCount, SqlCallPredicate predicate) {
        int actualCount = CollectionUtils.countMatches((Collection)this.sqlCalls, (Predicate)predicate);
        if (expectedCount != actualCount) {
            Assert.fail((String)("Expected " + expectedCount + ", but got " + actualCount + " sql calls: " + predicate.getFailureMessage()));
        }
    }

    public static class EqualsWithParametersSqlCallPredicate
    extends EqualsSqlCallPredicate {
        private String[] parameters;

        public EqualsWithParametersSqlCallPredicate(String sql, String[] params) {
            super(sql);
            this.parameters = params;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return super.evaluateSqlCall(sqlCall) && Arrays.equals(this.parameters, sqlCall.getParameters());
        }

        String getFailureMessage() {
            return super.getFailureMessage() + " with parameters " + ArrayUtils.toString((Object)this.parameters);
        }
    }

    public static class StartsWithSqlCallPredicate
    extends SqlCallPredicate {
        private String prefix;

        public StartsWithSqlCallPredicate(String prefix) {
            this.prefix = prefix;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return sqlCall.getString().startsWith(this.prefix);
        }

        String getFailureMessage() {
            return "start with " + this.prefix;
        }
    }

    public static class EqualsWithParameterSqlCallPredicate
    extends EqualsSqlCallPredicate {
        private Object parameterValue;

        public EqualsWithParameterSqlCallPredicate(String sql, Object parameterValue) {
            super(sql);
            this.parameterValue = parameterValue;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return super.evaluateSqlCall(sqlCall) && ArrayUtils.contains((Object[])sqlCall.getParameters(), (Object)this.parameterValue);
        }

        String getFailureMessage() {
            return "parameter value \"" + this.parameterValue + "\" for sql " + this.sql;
        }
    }

    public static class EqualsSqlCallPredicate
    extends SqlCallPredicate {
        String sql;

        public EqualsSqlCallPredicate(String sql) {
            this.sql = sql;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return this.sql.equalsIgnoreCase(sqlCall.getString());
        }

        String getFailureMessage() {
            return "sql \"" + this.sql + "\"";
        }
    }

    public static class MatchesRegexSqlCallPredicate
    extends SqlCallPredicate {
        private String regex;

        public MatchesRegexSqlCallPredicate(String regex) {
            this.regex = regex;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            Pattern pattern = Pattern.compile(this.regex, 2);
            Matcher matcher = pattern.matcher(sqlCall.getString());
            boolean result = matcher.find();
            return result;
        }

        String getFailureMessage() {
            return "Expected call to match regex " + this.regex;
        }
    }

    public static class InsertIntoTableWithParameterSqlCallPredicate
    extends InsertIntoTableSqlCallPredicate {
        private String parameter;

        public InsertIntoTableWithParameterSqlCallPredicate(String tableName, String parameter) {
            super(tableName);
            this.parameter = parameter;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return super.evaluateSqlCall(sqlCall) && ArrayUtils.contains((Object[])sqlCall.getParameters(), (Object)this.parameter);
        }

        String getFailureMessage() {
            return super.getFailureMessage() + " with one parameter = \"" + this.parameter + "\"";
        }
    }

    public static class InsertIntoTableSqlCallPredicate
    extends SqlCallPredicate {
        private String tableName;

        public InsertIntoTableSqlCallPredicate(String tableName) {
            this.tableName = tableName;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            Pattern pattern = Pattern.compile("^insert\\s+(?:into\\s+)?" + this.tableName, 2);
            Matcher matcher = pattern.matcher(sqlCall.getString());
            boolean result = matcher.find();
            return result;
        }

        String getFailureMessage() {
            return "insert into table \"" + this.tableName + "\"";
        }
    }

    public static class UpdateTableSqlCallPredicate
    extends SqlCallPredicate {
        private String tableName;
        private String parameter;

        public UpdateTableSqlCallPredicate(String tableName, String parameter) {
            this.tableName = tableName;
            this.parameter = parameter;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            boolean stringMatchesUpdateTableName = Pattern.compile("^update\\s+" + this.tableName).matcher(sqlCall.getString().toLowerCase()).find();
            boolean parametersContainsParameter = ArrayUtils.contains((Object[])sqlCall.getParameters(), (Object)this.parameter);
            return stringMatchesUpdateTableName && parametersContainsParameter;
        }

        String getFailureMessage() {
            return "update of table " + this.tableName + " with one parameter = " + this.parameter;
        }
    }

    public static class ProcedureSqlCallPredicate
    extends SqlCallPredicate {
        String procedureName;

        public ProcedureSqlCallPredicate(String procedureName) {
            this.procedureName = procedureName;
        }

        boolean evaluateSqlCall(SqlCall sqlCall) {
            return this.procedureName.equalsIgnoreCase(sqlCall.getString());
        }

        String getFailureMessage() {
            return "procedure with name " + this.procedureName;
        }
    }

    public static abstract class SqlCallPredicate
    implements Predicate {
        public boolean evaluate(Object object) {
            return this.evaluateSqlCall((SqlCall)object);
        }

        abstract boolean evaluateSqlCall(SqlCall var1);

        abstract String getFailureMessage();

        public String toString() {
            return this.getFailureMessage();
        }
    }

    public static class SqlCall {
        private String string;
        private String[] parameters;
        private Object result;

        public SqlCall(String string, String[] parameters) {
            this.string = string;
            this.parameters = parameters;
        }

        public SqlCall(String string, String[] parameters, Object result) {
            this(string, parameters);
            this.result = result;
        }

        public String getString() {
            return this.string;
        }

        public String[] getParameters() {
            return this.parameters;
        }

        public Object getResult() {
            return this.result;
        }

        public String toString() {
            return this.getString() + " " + StringUtils.join((Object[])this.getParameters(), (String)", ");
        }

        public void setParameters(String[] parameters) {
            this.parameters = parameters;
        }
    }
}

