/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.UnhandledException;

public class DatabaseConnection {
    private Connection connection;

    public DatabaseConnection(Connection connection) {
        this.connection = connection;
    }

    public void executeUpdateQuery(String sql, String[] parameters) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
            this.setPreparedStatementParameters(preparedStatement, parameters);
            preparedStatement.executeUpdate();
        }
        catch (SQLException se) {
            throw new UnhandledException((Throwable)se);
        }
    }

    public String executeUpdateAndSelectString(String sql, String[] parameters) {
        try {
            ResultSet resultSet;
            PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
            this.setPreparedStatementParameters(preparedStatement, parameters);
            preparedStatement.execute();
            String result = null;
            if (preparedStatement.getMoreResults() && (resultSet = preparedStatement.getResultSet()).next()) {
                result = resultSet.getString(1);
            }
            return result;
        }
        catch (SQLException se) {
            throw new UnhandledException((Throwable)se);
        }
    }

    public Number executeUpdateAndGetGeneratedKey(String sql, String[] parameters) {
        try {
            PreparedStatement preparedStatement = this.connection.prepareStatement(sql, 1);
            this.setPreparedStatementParameters(preparedStatement, parameters);
            preparedStatement.executeUpdate();
            ResultSet generatedKeysResultSet = preparedStatement.getGeneratedKeys();
            Number result = null;
            if (generatedKeysResultSet.next()) {
                result = (Number)generatedKeysResultSet.getObject(1);
            }
            return result;
        }
        catch (SQLException se) {
            throw new UnhandledException((Throwable)se);
        }
    }

    private void setPreparedStatementParameters(PreparedStatement preparedStatement, String[] parameters) throws SQLException {
        for (int i = 0; i < parameters.length; ++i) {
            String parameter = parameters[i];
            preparedStatement.setString(i + 1, parameter);
        }
    }
}

