/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.db;

import imcode.server.db.ConnectionPool;
import imcode.server.db.IntegrityConstraintViolationSQLException;
import imcode.server.db.StringTruncationSQLException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.NullArgumentException;
import org.apache.log4j.Logger;

class DBConnect {
    private Connection connection = null;
    private ResultSet resultSet = null;
    private ResultSetMetaData resultSetMetaData = null;
    private PreparedStatement preparedStatement;
    private CallableStatement callableStatement = null;
    private String sqlQueryString = "";
    private String sqlProcedure = "";
    private String[] columnLabels;
    private int columnCount;
    private static final Logger log = Logger.getLogger((Class)DBConnect.class);

    DBConnect(ConnectionPool conPool) {
        try {
            this.connection = conPool.getConnection();
        }
        catch (SQLException e) {
            this.getException(e);
        }
    }

    List executeQuery() {
        ArrayList<String> results = new ArrayList<String>();
        try {
            this.preparedStatement.executeQuery();
            this.resultSet = this.preparedStatement.getResultSet();
            this.resultSetMetaData = this.resultSet.getMetaData();
            this.columnCount = this.resultSetMetaData.getColumnCount();
            this.columnLabels = new String[this.columnCount];
            int i = 0;
            while (i < this.columnCount) {
                this.columnLabels[i++] = this.resultSetMetaData.getColumnLabel(i);
            }
            while (this.resultSet.next()) {
                for (i = 1; i <= this.columnCount; ++i) {
                    String s = this.resultSet.getString(i);
                    results.add(s);
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)"Error in executeQuery()", (Throwable)ex);
            throw this.getException(ex);
        }
        finally {
            this.closeConnection();
        }
        return results;
    }

    private RuntimeException getException(SQLException ex) {
        String sqlState = ex.getSQLState();
        if ("23000".equals(sqlState)) {
            return new IntegrityConstraintViolationSQLException(ex);
        }
        if ("01004".equals(sqlState)) {
            return new StringTruncationSQLException(ex);
        }
        log.debug((Object)("SQLException with SQLState " + sqlState));
        return new RuntimeException(ex);
    }

    int executeUpdateQuery() {
        try {
            int n = this.preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException ex) {
            log.error((Object)"Error in executeUpdateQuery()", (Throwable)ex);
            throw this.getException(ex);
        }
        finally {
            this.closeConnection();
        }
    }

    private List executeProcedure() {
        ArrayList<String> results = new ArrayList<String>();
        try {
            this.resultSet = this.callableStatement.executeQuery();
            this.resultSetMetaData = this.resultSet.getMetaData();
            this.columnCount = this.resultSetMetaData.getColumnCount();
            this.columnLabels = new String[this.columnCount];
            int i = 0;
            while (i < this.columnCount) {
                this.columnLabels[i++] = this.resultSetMetaData.getColumnLabel(i);
            }
            while (this.resultSet.next()) {
                for (i = 1; i <= this.columnCount; ++i) {
                    String s = this.resultSet.getString(i);
                    results.add(s);
                }
            }
        }
        catch (SQLException ex) {
            log.error((Object)"Error in executeProcedure()", (Throwable)ex);
            throw this.getException(ex);
        }
        finally {
            this.closeConnection();
        }
        return results;
    }

    private int executeUpdateProcedure() {
        int res = 0;
        try {
            res = this.callableStatement.executeUpdate();
        }
        catch (SQLException ex) {
            log.error((Object)"Error in executeUpdateProcedure()", (Throwable)ex);
            throw this.getException(ex);
        }
        finally {
            this.closeConnection();
        }
        return res;
    }

    String[] getColumnLabels() {
        return this.columnLabels;
    }

    int getColumnCount() {
        return this.columnCount;
    }

    private void closeConnection() {
        try {
            if (null != this.resultSet) {
                this.resultSet.close();
            }
            if (null != this.preparedStatement) {
                this.preparedStatement.close();
            }
            if (null != this.callableStatement) {
                this.callableStatement.close();
            }
            this.connection.close();
        }
        catch (SQLException ex) {
            log.error((Object)"Failed to close connection.", (Throwable)ex);
        }
        this.connection = null;
    }

    private void prepareProcedureStatementAndSetParameters(String procedure, String[] params) {
        if (null == procedure) {
            throw new NullArgumentException(procedure);
        }
        this.sqlProcedure = "{call " + procedure + "}";
        try {
            this.callableStatement = this.connection.prepareCall(this.sqlProcedure);
            this.setParameters(this.callableStatement, params);
        }
        catch (SQLException ex) {
            log.error((Object)"Error in prepareProcedureStatementAndSetParameters()", (Throwable)ex);
            throw this.getException(ex);
        }
    }

    private void setParameters(PreparedStatement statement, String[] params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            statement.setString(i + 1, params[i]);
        }
    }

    int executeUpdateProcedure(String procedure, String[] params) {
        procedure = DBConnect.addQuestionMarksToProcedureCall(procedure, params);
        this.prepareProcedureStatementAndSetParameters(procedure, params);
        return this.executeUpdateProcedure();
    }

    List executeProcedure(String procedure, String[] params) {
        procedure = DBConnect.addQuestionMarksToProcedureCall(procedure, params);
        this.prepareProcedureStatementAndSetParameters(procedure, params);
        return this.executeProcedure();
    }

    private static String addQuestionMarksToProcedureCall(String procedure, String[] params) {
        StringBuffer procedureBuffer = new StringBuffer(procedure);
        procedureBuffer.append("(");
        if (params.length > 0) {
            procedureBuffer.append("?");
            for (int i = 1; i < params.length; ++i) {
                procedureBuffer.append(", ?");
            }
        }
        procedureBuffer.append(")");
        return procedureBuffer.toString();
    }

    void setSQLString(String sqlStr, String[] params) {
        this.sqlQueryString = sqlStr;
        this.prepareQueryStatementAndSetParameters(params);
    }

    private void prepareQueryStatementAndSetParameters(String[] params) {
        try {
            this.preparedStatement = this.connection.prepareStatement(this.sqlQueryString);
            this.setParameters(this.preparedStatement, params);
        }
        catch (SQLException ex) {
            log.error((Object)"Error in prepareQueryStatementAndSetParameters()", (Throwable)ex);
            throw this.getException(ex);
        }
    }
}

