/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.db;

import imcode.server.db.ConnectionPool;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.log4j.Logger;

public class ConnectionPoolForNonPoolingDriver
extends ConnectionPool {
    private BasicDataSource dataSource;
    private static final Logger log = Logger.getLogger((Class)ConnectionPoolForNonPoolingDriver.class);

    public ConnectionPoolForNonPoolingDriver(String driverClassName, String dbUrl, String userName, String password, int maxActiveConnections) throws Exception {
        BasicDataSource basicDataSource = new BasicDataSource();
        basicDataSource.setDriverClassName(driverClassName);
        basicDataSource.setUsername(userName);
        basicDataSource.setPassword(password);
        basicDataSource.setUrl(dbUrl);
        basicDataSource.setMaxActive(maxActiveConnections);
        basicDataSource.setMaxIdle(maxActiveConnections);
        this.dataSource = basicDataSource;
        this.logDatabaseVersion();
    }

    private void logDatabaseVersion() throws SQLException {
        Connection connection = this.getConnection();
        DatabaseMetaData metaData = connection.getMetaData();
        log.info((Object)("Database product version = " + metaData.getDatabaseProductVersion()));
        connection.close();
    }

    public synchronized Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void destroy() {
        try {
            this.dataSource.close();
        }
        catch (SQLException e) {
            log.error((Object)"Error closing datasource.", (Throwable)e);
        }
    }
}

