/*
 * Decompiled with CFR 0.152.
 */
package imcode.server;

import java.util.StringTokenizer;

public class HTMLConv {
    private static final String[] h_code = new String[]{"&nbsp;", "&iexcl;", "&cent;", "&pound;", "&curren;", "&yen;", "", "&sect;", "&uml;", "&copy;", "&ordf;", "&laquo;", "&not;", "&shy;", "&reg;", "&macr;", "&deg;", "&plusmn;", "", "", "&acute;", "&micro;", "&para;", "&middot;", "&cedil;", "", "&ordm;", "&raquo;", "", "", "", "&iquest;", "&Agrave;", "&Aacute;", "&Acirc;", "&Atilde;", "&Auml;", "&Aring;", "&AElig;", "&Ccedil;", "&Egrave;", "&Eacute;", "&Ecirc;", "&Euml;", "&Igrave;", "&Iacute;", "&Icirc;", "&Iuml;", "", "&Ntilde;", "&Ograve;", "&Oacute;", "&Ocirc;", "&Otilde;", "&Ouml;", "", "&Oslash;", "&Ugrave;", "&Uacute;", "&Ucirc;", "&Uuml;", "", "", "&szlig;", "&agrave;", "&aacute;", "&acirc;", "&atilde;", "&auml;", "&aring;", "&aelig;", "&ccedil;", "&egrave;", "&eacute;", "&ecirc;", "&euml;", "&igrave;", "&iacute;", "&icirc;", "&iuml;", "", "&ntilde;", "&ograve;", "&oacute;", "&ocirc;", "&otilde;", "&ouml;", "&divide;", "&oslash;", "&ugrave;", "&uacute;", "&ucirc;", "&uuml;", "", "", "&yuml;"};

    private HTMLConv() {
    }

    private static String toHTML(char ch) {
        if (ch > '\u009f') {
            return h_code[ch - 160];
        }
        return "" + ch;
    }

    public static String toHTML(String str) {
        StringBuffer htmlStr = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            htmlStr.append(HTMLConv.toHTML(str.charAt(i)));
        }
        return htmlStr.toString();
    }

    public static String toHTMLSpecial(String string) {
        StringTokenizer stok = new StringTokenizer(string, "\n&<>\"'", true);
        StringBuffer result = new StringBuffer();
        while (stok.hasMoreTokens()) {
            String token = stok.nextToken();
            if (token.length() == 1) {
                char ch = token.charAt(0);
                switch (ch) {
                    default: {
                        token = "" + ch;
                        break;
                    }
                    case '\n': {
                        token = "\n<BR>";
                        break;
                    }
                    case '&': {
                        token = "&amp;";
                        break;
                    }
                    case '>': {
                        token = "&gt;";
                        break;
                    }
                    case '<': {
                        token = "&lt;";
                        break;
                    }
                    case '\"': {
                        token = "&quot;";
                        break;
                    }
                    case '\'': {
                        token = "&apos;";
                    }
                }
            }
            result.append(token);
        }
        return result.toString();
    }
}

