/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.chat;

import imcode.external.chat.Chat;
import imcode.external.chat.ChatGroup;
import imcode.external.chat.ChatMessage;
import imcode.server.user.UserDomainObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ChatMember
implements Comparable {
    private int memberId;
    private String _ipNr;
    private UserDomainObject user;
    private ChatMessage _lastChatMsg;
    private int _lastMsgInt;
    private List _msgBuffer;
    private String _name;
    private ChatGroup group;
    private int _maxSize = 200;
    private Chat _parent;
    private int referrerMetaId;
    private int refreshTime;
    private boolean showDateTimesEnabled = false;
    private boolean showPrivateMessagesEnabled = true;
    private boolean autoRefreshEnabled = false;
    private boolean showEnterAndLeaveMessagesEnabled;
    private Date lastRequest = new Date();
    private int fontSize = 2;
    private static final int HOURS__BACK_FOR__HISTORY = 1;
    private static final int MINUTE__BACK_FOR__HISTORY = 0;
    private boolean isTimedOut;
    private boolean isKickedOut;

    ChatMember(int memberId, Chat parent, UserDomainObject user, int referrerMetaId) {
        this.referrerMetaId = referrerMetaId;
        this._msgBuffer = Collections.synchronizedList(new LinkedList());
        this.memberId = memberId;
        this.user = user;
        this._parent = parent;
        this.refreshTime = parent.getRefreshTime();
        this.isTimedOut = false;
        this.isKickedOut = false;
    }

    public Chat getParent() {
        return this._parent;
    }

    void setCurrentGroup(ChatGroup group) {
        this._msgBuffer = Collections.synchronizedList(new LinkedList());
        this._lastChatMsg = null;
        this.group = group;
    }

    public ChatGroup getGroup() {
        return this.group;
    }

    public int getLastMsgNr() {
        return this._lastMsgInt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator getMessages() {
        List list = this._msgBuffer;
        synchronized (list) {
            this._lastChatMsg = (ChatMessage)this._msgBuffer.get(0);
            this._lastMsgInt = this._lastChatMsg.getIdNumber();
            return ChatMember.copyList(this._msgBuffer).listIterator();
        }
    }

    private static List copyList(List listToCopy) {
        ArrayList _msgBufferCopy = new ArrayList(listToCopy.size());
        _msgBufferCopy.addAll(listToCopy);
        return _msgBufferCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNewMsg(ChatMessage msg) {
        List list = this._msgBuffer;
        synchronized (list) {
            this.pruneBuffer();
            this._msgBuffer.add(0, msg);
        }
    }

    private void pruneBuffer() {
        if (this._msgBuffer.size() > this._maxSize) {
            this._msgBuffer.remove(this._msgBuffer.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageHistory() {
        List historyMsg = this.getGroup().get_msgBuffer();
        List list = this._msgBuffer;
        synchronized (list) {
            this._msgBuffer = Collections.synchronizedList(new LinkedList(historyMsg));
            Calendar cal = Calendar.getInstance();
            cal.add(10, -1);
            cal.add(12, 0);
            Iterator it = this._msgBuffer.iterator();
            while (it.hasNext()) {
                ChatMessage tempMessage = (ChatMessage)it.next();
                if (!tempMessage.getDateTime().before(cal.getTime())) continue;
                it.remove();
            }
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name == null ? "" : this._name;
    }

    public int getMemberId() {
        return this.memberId;
    }

    public void setIpNr(String ipNr) {
        this._ipNr = ipNr;
    }

    public String getIpNr() {
        return this._ipNr == null ? "" : this._ipNr;
    }

    public String toString() {
        return "Id= " + this.memberId + " Namn = " + this._name;
    }

    public boolean isShowDateTimesEnabled() {
        return this.showDateTimesEnabled;
    }

    public boolean isShowPrivateMessagesEnabled() {
        return this.showPrivateMessagesEnabled;
    }

    public boolean isAutoRefreshEnabled() {
        return this.autoRefreshEnabled;
    }

    public boolean isShowEnterAndLeaveMessagesEnabled() {
        return this.showEnterAndLeaveMessagesEnabled;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setShowDateTimesEnabled(boolean onOff) {
        this.showDateTimesEnabled = onOff;
    }

    public void setShowPrivateMessagesEnabled(boolean onOff) {
        this.showPrivateMessagesEnabled = onOff;
    }

    public void setShowEnterAndLeaveMessagesEnabled(boolean showEnterAndLeaveMessagesEnabled) {
        this.showEnterAndLeaveMessagesEnabled = showEnterAndLeaveMessagesEnabled;
    }

    public void setAutoRefreshEnabled(boolean onOff) {
        this.autoRefreshEnabled = onOff;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChatMember)) {
            return false;
        }
        ChatMember chatMember = (ChatMember)o;
        return this.memberId == chatMember.memberId;
    }

    public int hashCode() {
        return this.memberId;
    }

    public Date getLastRequest() {
        return this.lastRequest;
    }

    public void setLastRequest(Date lastRequest) {
        this.lastRequest = lastRequest;
    }

    public UserDomainObject getUser() {
        return this.user;
    }

    public int compareTo(Object o) {
        ChatMember otherChatMember = (ChatMember)o;
        return this.getName().compareToIgnoreCase(otherChatMember.getName());
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public void setRefreshTime(int refreshTime) {
        this.refreshTime = refreshTime;
    }

    public int getReferrerMetaId() {
        return this.referrerMetaId;
    }

    public boolean isTimedOut() {
        return this.isTimedOut;
    }

    public void setTimedOut(boolean timedOut) {
        this.isTimedOut = timedOut;
    }

    public boolean isKickedOut() {
        return this.isKickedOut;
    }

    public void setKickedOut(boolean kickedOut) {
        this.isKickedOut = kickedOut;
    }
}

