/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.test.external;

import imcode.server.db.ConnectionPoolForNonPoolingDriver;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;

public class TestConnectionPoolForNonPoolingDriver
extends TestCase {
    private static final Logger log = Logger.getLogger((String)TestConnectionPoolForNonPoolingDriver.class.getName());
    private String driverClassName;
    private String userName;
    private String passWord;
    private String dbUrl;
    private static final String DATABASE_PROPERTIES_SYSTEM_PROPERTY = "test.db.properties";
    private static final String DEFAULT_DATABASE_PROPERTIES_FILE = "build.properties";
    private static final int HALF_A_SECOND_MILLIS = 500;

    public void setUp() throws Exception, ClassNotFoundException, IllegalAccessException, InstantiationException {
        ExtendedProperties databaseProperties = new ExtendedProperties();
        String databasePropertiesFilename = System.getProperty(DATABASE_PROPERTIES_SYSTEM_PROPERTY, DEFAULT_DATABASE_PROPERTIES_FILE);
        databaseProperties.load((InputStream)new FileInputStream(databasePropertiesFilename));
        this.userName = databaseProperties.getString("db-user");
        this.passWord = databaseProperties.getString("db-pass");
        this.driverClassName = databaseProperties.getString("db-driver");
        this.dbUrl = databaseProperties.getString("db-url");
    }

    public void testFullPoolAndReturningOfConnectionWhenClose() throws Exception {
        int poolSize = 1;
        ConnectionPoolForNonPoolingDriver cm = new ConnectionPoolForNonPoolingDriver(this.driverClassName, this.dbUrl, this.userName, this.passWord, poolSize);
        final Connection con1 = cm.getConnection();
        TestConnectionPoolForNonPoolingDriver.assertNotNull((Object)con1);
        String con1String = con1.toString();
        int sleepTimeInMs = 500;
        final long wakeUpTime = System.currentTimeMillis() + 500L;
        new Thread(){

            public void run() {
                TestConnectionPoolForNonPoolingDriver.this.sleepUntil(wakeUpTime);
                try {
                    con1.close();
                }
                catch (SQLException e) {
                    Assert.fail();
                }
            }
        }.start();
        Connection con2 = cm.getConnection();
        TestConnectionPoolForNonPoolingDriver.assertNotNull((Object)con2);
        TestConnectionPoolForNonPoolingDriver.assertEquals((String)con1String, (String)con2.toString());
        con2.close();
    }

    private void sleepUntil(long wakeUpTime) {
        long sleepLeft = wakeUpTime - System.currentTimeMillis();
        while (sleepLeft > 0L) {
            try {
                Thread.sleep(sleepLeft);
            }
            catch (InterruptedException e) {
                log.warn((Object)e);
            }
            sleepLeft = wakeUpTime - System.currentTimeMillis();
        }
    }

    public void testTwoDifferentConnections() throws Exception {
        ConnectionPoolForNonPoolingDriver cm = new ConnectionPoolForNonPoolingDriver(this.driverClassName, this.dbUrl, this.userName, this.passWord, 20);
        Connection con1 = cm.getConnection();
        TestConnectionPoolForNonPoolingDriver.assertNotNull((Object)con1);
        Connection con2 = cm.getConnection();
        TestConnectionPoolForNonPoolingDriver.assertNotNull((Object)con2);
        TestConnectionPoolForNonPoolingDriver.assertNotSame((Object)con1, (Object)con2);
    }

    public void testConnectionWithSQLDriverOnly() throws ClassNotFoundException, SQLException {
        Class.forName(this.driverClassName);
        Connection con = DriverManager.getConnection(this.dbUrl, this.userName, this.passWord);
        TestConnectionPoolForNonPoolingDriver.assertNotNull((Object)con);
    }

    public void testListAllTables() throws Exception {
        DatabaseMetaData metaData = TestConnectionPoolForNonPoolingDriver.getConnectionMetaData(this.driverClassName, this.dbUrl, this.userName, this.passWord);
        String[] types = new String[]{"TABLE"};
        ResultSet resultSet = metaData.getTables(null, null, "%", types);
        ArrayList<String> tableNames = new ArrayList<String>();
        while (resultSet.next()) {
            String tableName = resultSet.getString(3);
            tableNames.add(tableName);
        }
        TestConnectionPoolForNonPoolingDriver.assertFalse((boolean)tableNames.isEmpty());
    }

    public void testListAllStoredProcedures() throws Exception {
        DatabaseMetaData metaData = TestConnectionPoolForNonPoolingDriver.getConnectionMetaData(this.driverClassName, this.dbUrl, this.userName, this.passWord);
        ResultSet rs = metaData.getProcedures(null, null, "%");
        ArrayList<String> procedureNames = new ArrayList<String>();
        while (rs.next()) {
            String procedureName = rs.getString(3);
            procedureNames.add(procedureName);
        }
        TestConnectionPoolForNonPoolingDriver.assertFalse((boolean)procedureNames.isEmpty());
    }

    private static DatabaseMetaData getConnectionMetaData(String driverClassName, String dbUrl, String userName, String passWord) throws Exception {
        ConnectionPoolForNonPoolingDriver cm = new ConnectionPoolForNonPoolingDriver(driverClassName, dbUrl, userName, passWord, 20);
        Connection con = cm.getConnection();
        DatabaseMetaData metaData = con.getMetaData();
        return metaData;
    }

    static {
        SimpleLayout layout = new SimpleLayout();
        ConsoleAppender appender = new ConsoleAppender((Layout)layout);
        appender.setName("System.out");
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(Level.WARN);
        rootLogger.addAppender((Appender)appender);
    }
}

