/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import imcode.external.diverse.SettingsAccessor;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Administrator
extends HttpServlet {
    private static final String TEMPLATE_ERROR = "Error.html";

    protected boolean assertNoEmptyStringsInPropertyValues(Properties aPropObj) {
        Enumeration<Object> enumValues = aPropObj.elements();
        Enumeration<Object> enumKeys = aPropObj.keys();
        while (enumValues.hasMoreElements() && enumKeys.hasMoreElements()) {
            enumKeys.nextElement();
            Object oValue = enumValues.nextElement();
            String theVal = oValue.toString();
            if (!theVal.equals("")) continue;
            return false;
        }
        return true;
    }

    public static boolean checkAdminRights(HttpServletRequest req) {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        return user.isSuperAdmin();
    }

    File getAdminTemplateFolder(ImcmsServices imcref, UserDomainObject user) {
        File templateLib = imcref.getTemplatePath();
        String langPrefix = user.getLanguageIso639_2();
        templateLib = new File(templateLib, langPrefix + "/admin");
        return templateLib;
    }

    String createHtml(HttpServletRequest req, VariableManager vm, String htmlFile) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        vm.addProperty("SERVLET_URL", "");
        vm.addProperty("SERVLET_URL2", "");
        List tagsAndData = vm.getTagsAndData();
        String html = imcref.getAdminTemplate(htmlFile, user, tagsAndData);
        return html;
    }

    protected void sendHtml(HttpServletRequest req, HttpServletResponse res, VariableManager vm, String htmlFile) throws IOException {
        String str = this.createHtml(req, vm, htmlFile);
        PrintWriter out = res.getWriter();
        Utility.setDefaultHtmlContentType(res);
        out.println(str);
    }

    protected void sendErrorMessage(ImcmsServices imcref, String eMailServerMaster, UserDomainObject user, String errorHeader, int errorCode, HttpServletResponse response) throws IOException {
        String errorMessage = "";
        try {
            SettingsAccessor setObj = new SettingsAccessor("errmsg.ini", user, "admin");
            setObj.setDelimiter("=");
            setObj.loadSettings();
            errorMessage = setObj.getSetting("" + errorCode);
            if (errorMessage == null) {
                errorMessage = "Missing Errorcode";
            }
        }
        catch (Exception e) {
            errorMessage = "An error occured while reading the errorCode file";
        }
        Utility.setDefaultHtmlContentType(response);
        ServletOutputStream out = response.getOutputStream();
        Vector<String> tagParsList = new Vector<String>();
        tagParsList.add("#ERROR_HEADER#");
        tagParsList.add(errorHeader);
        tagParsList.add("#ERROR_MESSAGE#");
        tagParsList.add(errorMessage);
        tagParsList.add("#EMAIL_SERVER_MASTER#");
        tagParsList.add(eMailServerMaster);
        out.print(imcref.getAdminTemplate(TEMPLATE_ERROR, user, tagParsList));
    }
}

