/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AdminRoleBelongings
extends Administrator {
    private static final Logger log = Logger.getLogger((String)AdminRoleBelongings.class.getName());
    private static final String HTML_ADMIN_ROLE_BELONGING = "AdminRoleBelongings.html";
    private static final String HTML_ADMIN_ROLE_BELONGING_EDIT = "AdminRoleBelongings_edit.html";
    private static final String HTML_ADMIN_ROLE_BELONGING_ACTIVATE = "AdminRoleBelongings_activate.html";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            return;
        }
        String[][] queryResult = imcref.sqlProcedureMulti("RoleAdminGetAll", new String[0]);
        String optionList = this.createListOfOptions(queryResult);
        VariableManager vm = new VariableManager();
        vm.addProperty("ROLES_MENU", optionList);
        this.sendHtml(req, res, vm, HTML_ADMIN_ROLE_BELONGING);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String[] userIds;
        String roleId;
        int i;
        String[] userIds2;
        ImcmsServices imcref = Imcms.getServices();
        String eMailServerMaster = imcref.getSystemData().getServerMasterAddress();
        String errorHeader = "AdminRoleBelongings";
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminRoleBelongings.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        if (req.getParameter("CANCEL") != null) {
            res.sendRedirect("AdminRoles");
            return;
        }
        if (req.getParameter("BELONGING_CANCEL") != null) {
            this.doGet(req, res);
        }
        if (req.getParameter("VIEW_USER_BELONGING_ROLE") != null) {
            String roleId2 = req.getParameter("ROLE_ID");
            if (roleId2 == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 100, res);
                return;
            }
            String userOptionListTag = this.getUserOptionListTag(roleId2, imcref);
            String curentRoleId = roleId2;
            try {
                Integer.parseInt(curentRoleId);
            }
            catch (NumberFormatException e) {
                curentRoleId = "0";
            }
            String[][] roleQueryResult = imcref.sqlProcedureMulti("RoleGetAllApartFromRole", new String[]{curentRoleId});
            String roleOptionList = this.createListOfOptions(roleQueryResult);
            String curentRoleName = this.getRoleName(roleId2, imcref);
            VariableManager vm = new VariableManager();
            vm.addProperty("CURENT_ROLE_ID", roleId2);
            vm.addProperty("CURENT_ROLE_NAME", curentRoleName);
            vm.addProperty("USER_MENU", userOptionListTag);
            vm.addProperty("ROLES_MENU", roleOptionList);
            this.sendHtml(req, res, vm, HTML_ADMIN_ROLE_BELONGING_EDIT);
            return;
        }
        if (req.getParameter("VIEW_USER_ACTIVATE") != null) {
            String roleId3 = req.getParameter("ROLE_ID");
            if (roleId3 == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 100, res);
                return;
            }
            String userOptionListTag = this.getUserOptionListTag(roleId3, imcref);
            String curentRoleName = this.getRoleName(roleId3, imcref);
            VariableManager vm = new VariableManager();
            vm.addProperty("CURENT_ROLE_ID", roleId3);
            vm.addProperty("CURENT_ROLE_NAME", curentRoleName);
            vm.addProperty("USER_MENU", userOptionListTag);
            this.sendHtml(req, res, vm, HTML_ADMIN_ROLE_BELONGING_ACTIVATE);
            return;
        }
        if (req.getParameter("BELONGING_REMOVE_ROLE") != null) {
            String curentRoleId = req.getParameter("CURENT_ROLE_ID");
            userIds2 = req.getParameterValues("USER_ID");
            if (curentRoleId == null || userIds2 == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 101, res);
                return;
            }
            for (i = 0; i < userIds2.length; ++i) {
                this.removeUserFromRole(userIds2[i], curentRoleId, imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_ADD_ROLE") != null) {
            roleId = req.getParameter("ROLE_ID");
            userIds2 = req.getParameterValues("USER_ID");
            if (roleId == null || userIds2 == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 102, res);
                return;
            }
            for (i = 0; i < userIds2.length; ++i) {
                this.addUserToRole(userIds2[i], roleId, imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_MOVE_ROLE") != null) {
            roleId = req.getParameter("ROLE_ID");
            String curentRoleId = req.getParameter("CURENT_ROLE_ID");
            String[] userIds3 = req.getParameterValues("USER_ID");
            if (roleId == null || userIds3 == null || curentRoleId == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 102, res);
                return;
            }
            for (int i2 = 0; i2 < userIds3.length; ++i2) {
                this.removeUserFromRole(userIds3[i2], curentRoleId, imcref);
                this.addUserToRole(userIds3[i2], roleId, imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_DEACTIVATE") != null) {
            userIds = req.getParameterValues("USER_ID");
            if (userIds == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 101, res);
                return;
            }
            for (int i3 = 0; i3 < userIds.length; ++i3) {
                this.setUsersActive(userIds[i3], "0", imcref);
            }
            this.doGet(req, res);
        }
        if (req.getParameter("BELONGING_ACTIVATE") != null) {
            userIds = req.getParameterValues("USER_ID");
            if (userIds == null) {
                this.sendErrorMessage(imcref, eMailServerMaster, user, errorHeader, 101, res);
                return;
            }
            for (int i4 = 0; i4 < userIds.length; ++i4) {
                this.setUsersActive(userIds[i4], "1", imcref);
            }
            this.doGet(req, res);
        }
    }

    private String createListOfOptions(String[][] options) {
        StringBuffer optionList = new StringBuffer();
        for (int i = 0; i < options.length; ++i) {
            boolean selected = options[i].length == 3;
            optionList.append(this.createOption(options[i][0], options[i][1], selected));
        }
        return optionList.toString();
    }

    private String createListOfOptions(String[][] options, boolean selected) {
        StringBuffer optionList = new StringBuffer();
        for (int i = 0; i < options.length; ++i) {
            optionList.append(this.createOption(options[i][0], options[i][1], selected));
        }
        return optionList.toString();
    }

    private String createOption(String elementValue, String elementName, boolean selected) {
        StringBuffer option = new StringBuffer();
        option.append("<option value=\"" + elementValue + "\"");
        if (selected) {
            option.append(" selected");
        }
        option.append(">" + elementName + "</option>");
        return option.toString();
    }

    private void addUserToRole(String userId, String roleId, ImcmsServices imcref) {
        this.removeUserFromRole(userId, roleId, imcref);
        imcref.sqlUpdateProcedure("AddUserRole", new String[]{userId, roleId});
    }

    private void removeUserFromRole(String userId, String roleId, ImcmsServices imcref) {
        imcref.sqlUpdateProcedure("RemoveUserFromRole", new String[]{userId, roleId});
    }

    private String getUserOptionListTag(String roleId, ImcmsServices imcref) {
        String userOptionList;
        if (roleId.equals("ALL_USERS")) {
            String[][] userQueryResult = imcref.sqlProcedureMulti("GetAllUsersInList", new String[0]);
            userOptionList = this.createListOfOptions(userQueryResult);
        } else {
            String[][] userQueryResult = imcref.sqlProcedureMulti("GetUsersWhoBelongsToRole", new String[]{roleId});
            userOptionList = this.createListOfOptions(userQueryResult, true);
        }
        return userOptionList;
    }

    private String getRoleName(String roleId, ImcmsServices imcref) {
        String roleName = "";
        if (!roleId.equalsIgnoreCase("ALL_USERS")) {
            roleName = imcref.sqlProcedureStr("RoleGetName", new String[]{roleId});
        }
        return roleName;
    }

    private void setUsersActive(String userId, String state, ImcmsServices imcref) {
        String sqlD = "ChangeUserActiveStatus";
        imcref.sqlUpdateQuery(sqlD, new String[]{userId, state});
    }
}

