/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.ParsedTextFile;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class Conference
extends HttpServlet {
    private static final String ADMIN_BUTTON_TEMPLATE = "conf_admin_button.htm";
    private static final String UNADMIN_BUTTON_TEMPLATE = "conf_unadmin_button.htm";

    int getMetaId(HttpServletRequest req) {
        HttpSession session;
        String metaId = req.getParameter("meta_id");
        if (metaId == null && (session = req.getSession(false)) != null) {
            metaId = (String)session.getAttribute("Conference.meta_id");
        }
        return Integer.parseInt(metaId);
    }

    MetaInfo.Parameters getConferenceSessionParameters(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        String metaIdStr = (String)session.getAttribute("Conference.meta_id") == null ? "" : (String)session.getAttribute("Conference.meta_id");
        int metaId = Integer.parseInt(metaIdStr);
        return new MetaInfo.Parameters(metaId);
    }

    void addExtSessionParametersToProperties(HttpServletRequest req, Properties params) {
        String discId;
        HttpSession session = req.getSession(true);
        String forumId = (String)session.getAttribute("Conference.forum_id") == null ? "" : (String)session.getAttribute("Conference.forum_id");
        String string = discId = (String)session.getAttribute("Conference.disc_id") == null ? "" : (String)session.getAttribute("Conference.disc_id");
        if (params == null) {
            params = new Properties();
        }
        params.setProperty("FORUM_ID", forumId);
        params.setProperty("DISC_ID", discId);
    }

    File getExternalTemplateRootFolder(HttpServletRequest req) {
        ImcmsServices imcref = Imcms.getServices();
        int metaId = this.getMetaId(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        return imcref.getExternalTemplateFolder(metaId, user);
    }

    File getExternalTemplateFolder(HttpServletRequest req) {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        int metaId = this.getMetaId(req);
        File extFolder = imcref.getExternalTemplateFolder(metaId, user);
        return new File(extFolder, this.getTemplateLibName(metaId));
    }

    private String getTemplateLibName(int meta_id) {
        String libName = Imcms.getServices().sqlProcedureStr("A_GetTemplateLib", new String[]{"" + meta_id});
        if (libName == null) {
            libName = "original";
        }
        libName = libName + "/";
        return libName;
    }

    void sendHtml(HttpServletRequest req, HttpServletResponse res, VariableManager vm, String htmlFile) throws IOException {
        File templateLib = this.getExternalTemplateFolder(req);
        String imagePath = this.getExternalImageFolder(req);
        VariableManager adminButtonVM = new VariableManager();
        adminButtonVM.addProperty("IMAGE_URL", imagePath);
        adminButtonVM.addProperty("SERVLET_URL", "");
        adminButtonVM.addProperty("ADMIN_LINK_HTML", vm.getProperty("ADMIN_LINK_HTML"));
        VariableManager unAdminButtonVM = new VariableManager();
        unAdminButtonVM.addProperty("IMAGE_URL", imagePath);
        unAdminButtonVM.addProperty("SERVLET_URL", "");
        unAdminButtonVM.addProperty("UNADMIN_LINK_HTML", vm.getProperty("UNADMIN_LINK_HTML"));
        vm.addProperty("IMAGE_URL", imagePath);
        vm.addProperty("SERVLET_URL", "");
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String adminBtn = this.getAdminButtonLink(req, user, adminButtonVM);
        vm.addProperty("CONF_ADMIN_LINK", adminBtn);
        String unAdminBtn = this.getUnAdminButtonLink(req, user, unAdminButtonVM);
        vm.addProperty("CONF_UNADMIN_LINK", unAdminBtn);
        String html = this.getTemplate(htmlFile, user, vm.getTagsAndData());
        Utility.setDefaultHtmlContentType(res);
        res.getWriter().println(html);
    }

    protected String getTemplate(String htmlFile, UserDomainObject user, List tagsAndData) {
        return Imcms.getServices().getTemplateFromSubDirectoryOfDirectory(htmlFile, user, tagsAndData, "102", "original");
    }

    Vector convert2Vector(String[] arr) {
        Vector<String> rolesV = new Vector<String>();
        for (int i = 0; i < arr.length; ++i) {
            rolesV.add(arr[i]);
        }
        return rolesV;
    }

    boolean prepareUserForConf(HttpServletRequest req, HttpServletResponse res, MetaInfo.Parameters params, UserDomainObject user) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        String metaId = "" + params.getMetaId();
        String lastLoginDate = imcref.sqlProcedureStr("A_GetLastLoginDate2", new String[]{metaId, "" + user.getId()});
        if (lastLoginDate == null) {
            this.addUserToOneConference(user, metaId, imcref);
        }
        imcref.sqlUpdateProcedure("A_ConfUsersUpdate", new String[]{metaId, "" + user.getId(), "" + user.getFirstName(), "" + user.getLastName()});
        HttpSession session = req.getSession(false);
        if (session != null) {
            this.setSessionAttributes(session, params);
            session.setAttribute("Conference.viewedDiscList", (Object)new Properties());
            session.setAttribute("Conference.last_login_date", (Object)lastLoginDate);
            session.setAttribute("Conference.user_id", (Object)("" + user.getId()));
            session.setAttribute("Conference.disc_index", (Object)"0");
            String aForumId = imcref.sqlProcedureStr("A_GetFirstForum", new String[]{"" + params.getMetaId()});
            session.setAttribute("Conference.forum_id", (Object)aForumId);
            String aDiscId = imcref.sqlProcedureStr("A_GetLastDiscussionId", new String[]{"" + params.getMetaId(), aForumId});
            session.setAttribute("Conference.disc_id", (Object)aDiscId);
            res.sendRedirect("ConfViewer");
            return true;
        }
        return false;
    }

    String getExternalImageFolder(HttpServletRequest req) {
        int metaId = this.getMetaId(req);
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String lang_prefix = imcref.getDefaultLanguage();
        if (user != null) {
            lang_prefix = user.getLanguageIso639_2();
        }
        String extFolder = req.getContextPath() + "/imcms/" + lang_prefix + "/images/" + imcref.getDocType(metaId) + '/';
        extFolder = extFolder + this.getTemplateLibName(metaId);
        return extFolder;
    }

    private String getAdminButtonLink(HttpServletRequest req, UserDomainObject user, VariableManager adminButtonVM) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        String adminLink = "&nbsp;";
        int intMetaId = this.getMetaId(req);
        if (this.userHasAdminRights(imcref, intMetaId, user)) {
            VariableManager adminLinkVM = new VariableManager();
            adminLinkVM.addProperty("SERVLET_URL", adminButtonVM.getProperty("SERVLET_URL"));
            String adminLinkFile = adminButtonVM.getProperty("ADMIN_LINK_HTML");
            String adminBtn = this.getTemplate(ADMIN_BUTTON_TEMPLATE, user, adminButtonVM.getTagsAndData());
            adminLinkVM.addProperty("ADMIN_BUTTON", adminBtn);
            if (!adminLinkFile.equals("")) {
                adminLink = this.getTemplate(adminLinkFile, user, adminLinkVM.getTagsAndData());
            }
        }
        return adminLink;
    }

    private String getUnAdminButtonLink(HttpServletRequest req, UserDomainObject user, VariableManager unAdminButtonVM) {
        ImcmsServices imcref = Imcms.getServices();
        String unAdminLink = "&nbsp;";
        int intMetaId = this.getMetaId(req);
        if (this.userHasAdminRights(imcref, intMetaId, user)) {
            VariableManager unAdminLinkVM = new VariableManager();
            unAdminLinkVM.addProperty("SERVLET_URL", unAdminButtonVM.getProperty("SERVLET_URL"));
            String unAdminLinkFile = unAdminButtonVM.getProperty("UNADMIN_LINK_HTML");
            String unAdminBtn = this.getTemplate(UNADMIN_BUTTON_TEMPLATE, user, unAdminButtonVM.getTagsAndData());
            unAdminLinkVM.addProperty("UNADMIN_BUTTON", unAdminBtn);
            if (!unAdminLinkFile.equals("")) {
                unAdminLink = this.getTemplate(unAdminLinkFile, user, unAdminLinkVM.getTagsAndData());
            }
        }
        return unAdminLink;
    }

    String verifySqlText(String str) {
        StringBuffer buf = new StringBuffer(str);
        char apostrof = '\'';
        for (int i = 0; i < buf.length(); ++i) {
            if (buf.charAt(i) != apostrof) continue;
            buf.insert(i, apostrof);
            ++i;
        }
        str = buf.toString();
        return str;
    }

    Properties verifyForSql(Properties aPropObj) {
        Enumeration<Object> enumValues = aPropObj.elements();
        Enumeration<Object> enumKeys = aPropObj.keys();
        while (enumValues.hasMoreElements() && enumKeys.hasMoreElements()) {
            Object oKeys = enumKeys.nextElement();
            Object oValue = enumValues.nextElement();
            String theVal = oValue.toString();
            String theKey = oKeys.toString();
            aPropObj.setProperty(theKey, this.verifySqlText(theVal));
        }
        return aPropObj;
    }

    boolean isUserAuthorized(HttpServletRequest req, HttpServletResponse res, UserDomainObject user) throws IOException {
        boolean authorized;
        HttpSession session = req.getSession(true);
        String stringMetaId = (String)session.getAttribute("Conference.meta_id");
        if (stringMetaId == null) {
            authorized = false;
            Utility.redirectToStartDocument(req, res);
        } else {
            int metaId = Integer.parseInt(stringMetaId);
            authorized = this.isUserAuthorized(res, metaId, user, req);
        }
        return authorized;
    }

    boolean isUserAuthorized(HttpServletResponse res, int metaId, UserDomainObject user, HttpServletRequest req) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(metaId);
        boolean authorized = user.canAccess(document);
        if (!authorized) {
            Utility.redirectToStartDocument(req, res);
        }
        return authorized;
    }

    boolean userHasRightToEdit(ImcmsServices imcref, int metaId, UserDomainObject user) {
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(metaId);
        return user.canAccess(document) && imcref.checkDocAdminRights(metaId, user);
    }

    boolean userHasAdminRights(ImcmsServices imcref, int metaId, UserDomainObject user) {
        return imcref.checkDocAdminRights(metaId, user) && imcref.checkDocAdminRights(metaId, user, 65536);
    }

    String parseOneRecord(Vector tagsV, Vector dataV, File htmlCodeFile) throws IOException {
        ParsedTextFile parser = new ParsedTextFile(htmlCodeFile, tagsV, dataV);
        String oneRecordsHtmlCode = parser.toString();
        return oneRecordsHtmlCode;
    }

    void setSessionAttributes(HttpSession session, MetaInfo.Parameters params) {
        session.setAttribute("Conference.meta_id", (Object)("" + params.getMetaId()));
    }

    boolean userIsMemberOfConference(int metaId, int userId, ImcmsServices imcref) {
        String foundId = imcref.sqlProcedureStr("A_MemberInConf", new String[]{"" + metaId, "" + userId});
        return ("" + userId).equals(foundId);
    }

    void addAllConferenceSelfRegRolesToUser(UserDomainObject user, String metaId, ImcmsServices imcref) {
        String[] selfRegRolesIds = this.getAllSelfregRolesId(metaId + "", imcref);
        if (selfRegRolesIds != null) {
            for (int i = 0; i < selfRegRolesIds.length; i += 2) {
                String aRoleId = selfRegRolesIds[i].toString();
                if (!user.hasRoleWithPermission(RoleDomainObject.CONFERENCE_REGISTRATION_PERMISSION)) continue;
                imcref.sqlUpdateProcedure("AddUserRole", new String[]{user.getId() + "", aRoleId});
            }
        }
    }

    void addUserToOneConference(UserDomainObject user, String metaId, ImcmsServices imcref) {
        imcref.sqlUpdateProcedure("A_ConfUsersAdd", new String[]{user.getId() + "", metaId, user.getFirstName(), user.getLastName()});
    }

    String[] getAllSelfregRolesId(String metaId, ImcmsServices imcref) {
        String[] selfRegRolesId = imcref.sqlProcedure("A_SelfRegRoles_GetAll2", new String[]{"" + metaId});
        return selfRegRolesId;
    }
}

